/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.contrast.service.impl;

import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.contrast.dao.CompanyContrastMapper;
import com.els.base.certification.contrast.entity.CompanyContrast;
import com.els.base.certification.contrast.entity.CompanyContrastExample;
import com.els.base.certification.contrast.entity.CompanyContrastItem;
import com.els.base.certification.contrast.entity.CompanyContrastItemExample;
import com.els.base.certification.contrast.service.CompanyContrastItemService;
import com.els.base.certification.contrast.service.CompanyContrastService;
import com.els.base.certification.contrast.utils.CompanyContrastApproveEnum;
import com.els.base.certification.contrast.utils.CompanyContrastPrintUtils;
import com.els.base.certification.contrast.vo.CompanyContrastVO;
import com.els.base.certification.customer.entity.CompanyCustomer;
import com.els.base.certification.customer.entity.CompanyCustomerExample;
import com.els.base.certification.customer.service.CompanyCustomerService;
import com.els.base.certification.equipment.entity.CompanyEquipment;
import com.els.base.certification.equipment.entity.CompanyEquipmentExample;
import com.els.base.certification.equipment.service.CompanyEquipmentService;
import com.els.base.certification.finance.entity.CompanyFinance;
import com.els.base.certification.finance.entity.CompanyFinanceExample;
import com.els.base.certification.finance.service.CompanyFinanceService;
import com.els.base.certification.productservice.entity.CompanyProductService;
import com.els.base.certification.productservice.entity.CompanyProductServiceExample;
import com.els.base.certification.productservice.service.CompanyProductServiceService;
import com.els.base.certification.technology.entity.CompanyTechnology;
import com.els.base.certification.technology.entity.CompanyTechnologyExample;
import com.els.base.certification.technology.service.CompanyTechnologyService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyContrastService")
public class CompanyContrastServiceImpl
implements CompanyContrastService,
ITaskListener {
    private static final Logger logger = LoggerFactory.getLogger(CompanyContrastServiceImpl.class);
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
    @Resource
    private CompanyContrastItemService companyContrastItemService;
    @Resource
    private CompanyService companyService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private DicGroupItemService dicGroupItemService;
    @Resource
    private CompanyProductServiceService companyProductServiceService;
    @Resource
    private CompanyTechnologyService companyTechnologyService;
    @Resource
    private CompanyCustomerService companyCustomerService;
    @Resource
    private CompanyFinanceService companyFinanceService;
    @Resource
    private CompanyEquipmentService companyEquipmentService;
    @Resource
    private CompanyAuthService companyAuthService;
    @Resource
    protected CompanyContrastMapper companyContrastMapper;

    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void addObj(CompanyContrast t) {
        this.companyContrastMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyContrastMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void modifyObj(CompanyContrast t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyContrastMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyContrast"}, keyGenerator="redisKeyGenerator")
    public CompanyContrast queryObjById(String id) {
        return this.companyContrastMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyContrast"}, keyGenerator="redisKeyGenerator")
    public List<CompanyContrast> queryAllObjByExample(CompanyContrastExample example) {
        return this.companyContrastMapper.selectByExample(example);
    }

    @Cacheable(value={"companyContrast"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyContrast> queryObjByPage(CompanyContrastExample example) {
        PageView<CompanyContrast> pageView = example.getPageView();
        pageView.setQueryResult(this.companyContrastMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"companyContrast"}, keyGenerator="redisKeyGenerator")
    public CompanyContrastItem generateCompanyContrastInfo(String supCompanyId, String materialType) {
        if (StringUtils.isEmpty((String)supCompanyId)) {
            throw new CommonException("\u4f20\u9012\u7684\u4f9b\u5e94\u5546id\u4e3a\u7a7a!");
        }
        Company company = (Company)this.companyService.queryObjById((Object)supCompanyId);
        if (null == company) {
            throw new CommonException("\u67e5\u8be2\u7684\u4f9b\u5e94\u5546\u4e3a\u7a7a!");
        }
        CompanyProductServiceExample companyProductServiceExample = new CompanyProductServiceExample();
        companyProductServiceExample.createCriteria().andSupCompanyIdEqualTo(supCompanyId).andIsEnableEqualTo(Constant.YES_INT);
        List productServiceList = this.companyProductServiceService.queryAllObjByExample((IExample)companyProductServiceExample);
        CompanyCustomerExample companyCustomerExample = new CompanyCustomerExample();
        companyCustomerExample.createCriteria().andSupCompanyIdEqualTo(supCompanyId).andIsEnableEqualTo(Constant.YES_INT);
        List companyCustomerList = this.companyCustomerService.queryAllObjByExample((IExample)companyCustomerExample);
        CompanyTechnologyExample companyTechnologyExample = new CompanyTechnologyExample();
        companyTechnologyExample.createCriteria().andSupCompanyIdEqualTo(supCompanyId).andIsEnableEqualTo(Constant.YES_INT);
        List companyTechnologyList = this.companyTechnologyService.queryAllObjByExample((IExample)companyTechnologyExample);
        CompanyFinanceExample companyFinanceExample = new CompanyFinanceExample();
        companyFinanceExample.createCriteria().andSupCompanyIdEqualTo(supCompanyId).andIsEnableEqualTo(Constant.YES_INT);
        List financeList = this.companyFinanceService.queryAllObjByExample((IExample)companyFinanceExample);
        CompanyEquipmentExample companyEquipmentExample = new CompanyEquipmentExample();
        companyEquipmentExample.createCriteria().andSupCompanyIdEqualTo(supCompanyId).andIsEnableEqualTo(Constant.YES_INT);
        List equipmentList = this.companyEquipmentService.queryAllObjByExample((IExample)companyEquipmentExample);
        CompanyAuthExample companyAuthExample = new CompanyAuthExample();
        companyAuthExample.createCriteria().andSupCompanyIdEqualTo(supCompanyId).andIsEnableEqualTo(Constant.YES_INT);
        List authList = this.companyAuthService.queryAllObjByExample((IExample)companyAuthExample);
        CompanyContrastItem item = this.completeData(materialType, company, productServiceList, companyCustomerList, companyTechnologyList, financeList, equipmentList, authList);
        return item;
    }

    private CompanyContrastItem completeData(String materialType, Company company, List<CompanyProductService> productServiceList, List<CompanyCustomer> companyCustomerList, List<CompanyTechnology> companyTechnologyList, List<CompanyFinance> companyFinanceList, List<CompanyEquipment> equipmentList, List<CompanyAuth> authList) {
        DicGroupItem payAccountPeriodDicItem;
        String certificateTypeCode;
        DicGroupItem deliveryModeDicItem;
        CompanyContrastItem item = new CompanyContrastItem();
        item.setId(UUIDGenerator.generateUUID());
        item.setSupCompanyId(company.getId());
        item.setSupCompanySrmCode(company.getCompanyCode());
        item.setSupCompanyName(company.getCompanyFullName());
        item.setSupCompanyShortName(company.getCompanyName());
        item.setSupCompanyAddress(company.getAddress());
        if (company.getCompanyEstablishmentTime() != null) {
            String establishTime = formatter.format(company.getCompanyEstablishmentTime());
            item.setEstablishTime(establishTime);
        }
        item.setRegisterCapital(company.getRegisteredCapital());
        if (company.getTotalNumber() != null) {
            item.setEmployeeQuantity(company.getTotalNumber().toString());
        }
        if (CollectionUtils.isNotEmpty(companyFinanceList)) {
            BigDecimal saleAmount = BigDecimal.ZERO;
            BigDecimal profitRate = BigDecimal.ZERO;
            for (CompanyFinance cf : companyFinanceList) {
                if (StringUtils.isNotEmpty((String)cf.getBusinessVolume())) {
                    saleAmount = saleAmount.add(new BigDecimal(cf.getBusinessVolume()));
                }
                if (!StringUtils.isNotBlank((String)cf.getGrossProfitRate())) continue;
                profitRate = profitRate.add(new BigDecimal(cf.getGrossProfitRate()));
            }
            item.setThreeYearSaleAmount(saleAmount.toString());
            profitRate = profitRate.divide(new BigDecimal(companyFinanceList.size()), 2, 4);
            item.setProfitRate(profitRate.toString());
        } else {
            item.setThreeYearSaleAmount("0");
        }
        if (CollectionUtils.isNotEmpty(productServiceList)) {
            CompanyProductService productService = productServiceList.get(0);
            item.setMainProduct(productService.getProductServiceName());
            item.setPurchaseCycle(company.getProductSupplyCycle());
        }
        if (CollectionUtils.isNotEmpty(companyCustomerList)) {
            CompanyCustomer companyCustomer = companyCustomerList.get(0);
            item.setMainCustomer(companyCustomer.getCustomerName());
            if (companyCustomer.getCarIndustryPercent() != null) {
                item.setCarBusinessPercent(companyCustomer.getCarIndustryPercent().toString());
            }
            for (CompanyCustomer cc : companyCustomerList) {
                if (!"\u6c7d\u8f66".equals(cc.getIndustry())) continue;
                item.setCarIndustryMainCustomer(cc.getCustomerName());
                item.setCarBusinessSaleAmount(cc.getTotalSalePercent().toString());
                break;
            }
        }
        if (StringUtils.isNotEmpty((String)company.getDeliveryMode()) && null != (deliveryModeDicItem = this.dicGroupItemService.queryItems("zr_deliverymode", company.getDeliveryMode()))) {
            item.setTransportStyle(deliveryModeDicItem.getName());
        }
        if ("1".equals(materialType)) {
            if (company.getMonthlyCapacity() != null) {
                item.setMonthlyCapacity(company.getMonthlyCapacity().toString());
            }
        } else if ("3".equals(materialType) && null != company.getProductCapacity()) {
            System.out.println(company.getProductCapacity());
            BigDecimal result = company.getProductCapacity().divide(new BigDecimal(12), 2, 4);
            item.setMonthlyCapacity(result.toString());
        }
        if (CollectionUtils.isNotEmpty(authList) && StringUtils.isNotEmpty((String)(certificateTypeCode = authList.get(0).getCertificateTypeCode()))) {
            if ("ios9001".equals(certificateTypeCode)) {
                item.setSystemCertification("ISO9001\u4f53\u7cfb\u8bc1\u4e66");
                item.setQualityCertification("ISO9001\u4f53\u7cfb\u8bc1\u4e66");
            } else if ("iatf16949".equals(certificateTypeCode)) {
                item.setSystemCertification("IATF16949\u4f53\u7cfb\u8bc1\u4e66");
                item.setQualityCertification("IATF16949\u4f53\u7cfb\u8bc1\u4e66");
            } else if ("ios14000".equals(certificateTypeCode)) {
                item.setSystemCertification("ISO14000\u8bc1\u4e66");
                item.setQualityCertification("ISO14000\u8bc1\u4e66");
            } else if ("license".equals(certificateTypeCode)) {
                item.setSystemCertification("\u8425\u4e1a\u6267\u7167/\u767b\u8bb0\u8bc1\u4e66");
                item.setQualityCertification("\u8425\u4e1a\u6267\u7167/\u767b\u8bb0\u8bc1\u4e66");
            } else if ("proxyCard".equals(certificateTypeCode)) {
                item.setSystemCertification("\u4ee3\u7406\u8bc1/\u6388\u6743\u4e66");
                item.setQualityCertification("\u4ee3\u7406\u8bc1/\u6388\u6743\u4e66");
            } else if ("other".equals(certificateTypeCode)) {
                item.setSystemCertification("\u5176\u5b83\u8bc1\u4e66");
                item.setQualityCertification("\u5176\u5b83\u8bc1\u4e66");
            } else {
                item.setSystemCertification("");
                item.setQualityCertification("");
            }
        }
        item.setPpmPerformance(company.getPpmPerformance());
        if (StringUtils.isNotBlank((String)company.getFeedbackTime())) {
            item.setBdFeedbackTime(company.getFeedbackTime());
        }
        if (company.getQualityInspectorNumber() != null) {
            item.setQualityEngineerQuantity(company.getQualityInspectorNumber().toString());
        }
        if (CollectionUtils.isNotEmpty(equipmentList)) {
            CompanyEquipment companyEquipment = equipmentList.get(0);
            item.setMainTestDevice(companyEquipment.getEquipmentName());
        }
        if (null != company.getTechnicianNumber()) {
            item.setDevelopEngineerQuantity(company.getTechnicianNumber().toString());
        }
        if (CollectionUtils.isNotEmpty(companyTechnologyList)) {
            CompanyTechnology companyTechnology = companyTechnologyList.get(0);
            item.setKeyTechnology(companyTechnology.getPivotalTechnology());
            item.setCoreTechnology(companyTechnology.getCentralTechnology());
            item.setMainProductTechnology(companyTechnology.getMajorProductiveTechnology());
            item.setMainDevelopSoftware(companyTechnology.getMajorDevelopSoftware());
        }
        if (StringUtils.isNotEmpty((String)company.getPayConditionsCode()) && null != (payAccountPeriodDicItem = this.dicGroupItemService.queryItems("zr_fukuanfangshi", company.getPayConditionsCode()))) {
            item.setPaymentAccountPeriod(payAccountPeriodDicItem.getName());
        }
        return item;
    }

    @Override
    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void deleteByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVING.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_ABOLISH.getStatus());
        CompanyContrastExample example = new CompanyContrastExample();
        example.createCriteria().andIdIn((List)ids).andApproveStatusIn(statusList);
        if (this.companyContrastMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u62ec\u5df2\u4f5c\u5e9f\u6216\u6b63\u5728\u5ba1\u6279\u6216\u5ba1\u6279\u6210\u529f\u6216\u5ba1\u6279\u5931\u8d25\u7684\u5355\u636e,\u65e0\u6cd5\u5220\u9664\u6570\u636e!");
        }
        CompanyContrast companyContrast = new CompanyContrast();
        companyContrast.setIsEnable(Constant.NO_INT);
        companyContrast.setUpdateTime(new Date());
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        this.companyContrastMapper.updateByExampleSelective(companyContrast, example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void abolishByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_UN_APPROVE.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_ABOLISH.getStatus());
        CompanyContrastExample example = new CompanyContrastExample();
        example.createCriteria().andIdIn((List)ids).andApproveStatusIn(statusList);
        if (this.companyContrastMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u62ec\u5df2\u4f5c\u5e9f\u6216\u672a\u5ba1\u6279\u6216\u5ba1\u6279\u6210\u529f\u6216\u5ba1\u6279\u5931\u8d25\u7684\u5355\u636e,\u65e0\u6cd5\u4f5c\u5e9f\u6570\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        CompanyContrast companyContrast = new CompanyContrast();
        companyContrast.setApproveStatus(CompanyContrastApproveEnum.STATUS_ABOLISH.getStatus());
        companyContrast.setUpdateTime(new Date());
        this.companyContrastMapper.updateByExampleSelective(companyContrast, example);
        List<CompanyContrast> list = this.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            logger.debug("\u67e5\u8be2\u7684\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u4f5c\u5e9f\u5355\u636e!");
            return;
        }
        this.stopWorkFlowProce(list);
    }

    private void stopWorkFlowProce(List<CompanyContrast> list) {
        for (CompanyContrast item : list) {
            this.workFlowService.stopProcess("qzgysdbb", item.getContrastBillNo());
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void sendDataToApprove(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVING.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_ABOLISH.getStatus());
        CompanyContrastExample example = new CompanyContrastExample();
        example.createCriteria().andIdIn((List)ids).andApproveStatusIn(statusList);
        if (this.companyContrastMapper.countByExample(example) > 0) {
            throw new CommonException("\u60a8\u9009\u62e9\u7684\u6570\u636e\u4e2d\u5305\u62ec\u5df2\u4f5c\u5e9f\u6216\u6b63\u5728\u5ba1\u6279\u6216\u5ba1\u6279\u6210\u529f\u6216\u5ba1\u6279\u5931\u8d25\u7684\u5355\u636e,\u65e0\u6cd5\u53d1\u9001\u5ba1\u6279\u5355\u636e!");
        }
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        List<CompanyContrast> list = this.queryAllObjByExample(example);
        this.addToWorkFlow(list);
    }

    private void addToWorkFlow(List<CompanyContrast> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            for (CompanyContrast it : list) {
                ProcessStartVO vo = ProcessStartVO.newInstance((String)"qzgysdbb", (String)it.getContrastBillNo(), (String)it.getId(), (String)("supComparisonTable?id=" + it.getId()));
                vo.setListenerClass(this.getClass());
                ProcessInstance startProcess = this.workFlowService.startProcess(vo);
                if (null == startProcess) continue;
                CompanyContrast companyContrast = new CompanyContrast();
                companyContrast.setApproveStatus(CompanyContrastApproveEnum.STATUS_APPROVING.getStatus());
                companyContrast.setUpdateTime(new Date());
                companyContrast.setApproveTime(new Date());
                CompanyContrastExample example = new CompanyContrastExample();
                example.createCriteria().andIdEqualTo(it.getId());
                this.companyContrastMapper.updateByExampleSelective(companyContrast, example);
            }
        }
    }

    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void listen(TaskOperateEvent event) {
        if (null == event) {
            logger.debug("\u5ba1\u6279\u6d41\u8fd4\u56de\u76d1\u542c\u4e8b\u4ef6\u4e3a\u7a7a!");
            return;
        }
        if (StringUtils.isEmpty((String)event.getBusinessId())) {
            logger.debug("\u5ba1\u6279\u6d41\u8fd4\u56de\u7684\u4e1a\u52a1id\u4e3a\u7a7a!");
            return;
        }
        CompanyContrast data = this.queryObjById(event.getBusinessId());
        if (null == data) {
            logger.debug("\u5ba1\u6279\u6d41\u8fd4\u56de\u7684\u4e1a\u52a1id\u67e5\u8be2\u7684\u5355\u636e\u4e3a\u7a7a!");
            return;
        }
        CompanyContrastExample example = new CompanyContrastExample();
        example.createCriteria().andIdEqualTo(event.getBusinessId());
        CompanyContrast c = new CompanyContrast();
        c.setUpdateTime(new Date());
        c.setApproveUserName(event.getAssignee());
        if (StringUtils.isNotEmpty((String)data.getApproveSuggestion())) {
            c.setApproveSuggestion(data.getApproveSuggestion() + "       ");
        } else {
            c.setApproveSuggestion("");
        }
        if (StringUtils.isEmpty((String)event.getApproveDesc())) {
            c.setApproveSuggestion(c.getApproveSuggestion() + event.getAssignee() + ":\u65e0");
        } else {
            c.setApproveSuggestion(c.getApproveSuggestion() + event.getAssignee() + ":" + event.getApproveDesc());
        }
        if (event.isFinished() && event.isPass()) {
            c.setApproveStatus(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
        } else if (event.isFinished() && !event.isPass()) {
            c.setApproveStatus(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
        }
        this.companyContrastMapper.updateByExampleSelective(c, example);
    }

    @Override
    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void setSuggestedSupplier(CompanyContrast companyContrast) {
        if (null == companyContrast) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)companyContrast.getId())) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u7684id\u4e3a\u7a7a!");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_ABOLISH.getStatus());
        CompanyContrastExample example = new CompanyContrastExample();
        example.createCriteria().andIdEqualTo(companyContrast.getId()).andApproveStatusIn(statusList);
        if (this.companyContrastMapper.countByExample(example) > 0) {
            throw new CommonException("\u5ba1\u6279\u901a\u8fc7\u6216\u5df2\u9a73\u56de\u6216\u5df2\u4f5c\u5e9f\u7684\u5355\u636e\u65e0\u6cd5\u518d\u8bbe\u7f6e\u5efa\u8bae\u7684\u4f9b\u5e94\u5546!");
        }
        companyContrast.setUpdateTime(new Date());
        this.companyContrastMapper.updateByPrimaryKeySelective(companyContrast);
    }

    @Override
    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void setApproveSuggestion(CompanyContrast companyContrast) {
        if (null == companyContrast) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)companyContrast.getId())) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u7684id\u4e3a\u7a7a!");
        }
        companyContrast.setUpdateTime(new Date());
        this.companyContrastMapper.updateByPrimaryKeySelective(companyContrast);
    }

    @Override
    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void setCompanyContrastRemark(CompanyContrast companyContrast) {
        if (null == companyContrast) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)companyContrast.getId())) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u7684id\u4e3a\u7a7a!");
        }
        companyContrast.setUpdateTime(new Date());
        this.companyContrastMapper.updateByPrimaryKeySelective(companyContrast);
    }

    @Override
    @Transactional
    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void create(CompanyContrastVO vo) {
        this.addObj(vo);
        List<CompanyContrastItem> list = vo.getCompanyContrastItemList();
        for (CompanyContrastItem item : list) {
            if (StringUtils.isEmpty((String)item.getCompanyContrastId())) {
                throw new CommonException("\u884c\u6570\u636e\u4e2d\u7684\u5934id\u4e3a\u7a7a,\u65e0\u6cd5\u4fdd\u5b58\u6570\u636e");
            }
            this.companyContrastItemService.addObj(item);
        }
    }

    @Override
    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void modifyData(CompanyContrast companyContrast) {
        if (null == companyContrast) {
            throw new CommonException("\u4f20\u9012\u53c2\u6570\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((String)companyContrast.getId())) {
            throw new CommonException("\u4f20\u9012\u7684\u5355\u636eid\u4e3a\u7a7a!");
        }
        ArrayList<Integer> statusList = new ArrayList<Integer>();
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_FAIL.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVING.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_APPROVE_SUCCESS.getStatus());
        statusList.add(CompanyContrastApproveEnum.STATUS_ABOLISH.getStatus());
        CompanyContrastExample example = new CompanyContrastExample();
        example.createCriteria().andIdEqualTo(companyContrast.getId()).andApproveStatusIn(statusList);
        if (this.companyContrastMapper.countByExample(example) > 0) {
            throw new CommonException("\u8be5\u5355\u636e\u6b63\u5904\u4e8e\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u6216\u9a73\u56de\u72b6\u6001,\u65e0\u6cd5\u4fee\u6539\u6570\u636e!");
        }
        this.companyContrastMapper.updateByPrimaryKeySelective(companyContrast);
    }

    @Override
    public FileData print(String projectId, String companyId, List<CompanyContrast> data) {
        if (null == data) {
            throw new CommonException("\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a!");
        }
        ArrayList<String> ids = null;
        for (CompanyContrast item : data) {
            if (StringUtils.isEmpty((String)item.getId())) {
                throw new CommonException("\u4f20\u9012\u7684\u53c2\u6570\u5217\u8868\u4e2d\u5b58\u5728id\u4e3a\u7a7a!");
            }
            if (null == ids) {
                ids = new ArrayList<String>();
            }
            ids.add(item.getId());
        }
        CompanyContrastExample example = new CompanyContrastExample();
        example.createCriteria().andIdIn(ids);
        List<CompanyContrast> dataList = this.queryAllObjByExample(example);
        if (null == dataList) {
            throw new CommonException("\u67e5\u8be2\u5230\u7684\u6570\u636e\u4e3a\u7a7a,\u65e0\u6cd5\u6253\u5370\u5355\u636e!");
        }
        ArrayList<CompanyContrastVO> voList = new ArrayList<CompanyContrastVO>();
        for (CompanyContrast c : dataList) {
            CompanyContrastVO vo = new CompanyContrastVO();
            BeanUtils.copyProperties((Object)c, (Object)vo);
            CompanyContrastItemExample itemExample = new CompanyContrastItemExample();
            itemExample.createCriteria().andCompanyContrastIdEqualTo(c.getId());
            List itemList = this.companyContrastItemService.queryAllObjByExample((IExample)itemExample);
            vo.setCompanyContrastItemList(itemList);
            voList.add(vo);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("voList", voList);
        FileData fileData = null;
        try {
            fileData = CompanyContrastPrintUtils.generatePdf(projectId, companyId, params, "A4");
        }
        catch (Exception e) {
            throw new CommonException("\u751f\u6210pdf\u6587\u4ef6\u51fa\u9519!");
        }
        return fileData;
    }

    @CacheEvict(value={"companyContrast"}, allEntries=true)
    public void deleteByExample(CompanyContrastExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyContrastMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyContrast"}, allEntries=true)
    @Transactional
    public void addAll(List<CompanyContrast> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.companyContrastMapper.insertSelective((CompanyContrast)record));
    }
}

