/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.finance.service.impl;

import com.els.base.certification.finance.dao.CompanyFinanceMapper;
import com.els.base.certification.finance.entity.CompanyFinance;
import com.els.base.certification.finance.entity.CompanyFinanceExample;
import com.els.base.certification.finance.service.CompanyFinanceService;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCompanyFinanceService")
public class CompanyFinanceServiceImpl
implements CompanyFinanceService {
    @Resource
    private CompanyFinanceMapper companyFinanceMapper;

    @Override
    @Cacheable(value={"companyAuth"}, keyGenerator="redisKeyGenerator")
    public Integer isFinish(Project project, Company company) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(Constant.NO_INT);
        CompanyFinanceExample companyFinanceExample = new CompanyFinanceExample();
        companyFinanceExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        int count = this.companyFinanceMapper.countByExample(companyFinanceExample);
        if (count <= 0) {
            return 0;
        }
        companyFinanceExample.clear();
        companyFinanceExample.createCriteria().andProjectIdEqualTo(project.getId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andFinishFlagIn(list);
        int finishCount = this.companyFinanceMapper.countByExample(companyFinanceExample);
        if (finishCount > 0) {
            return 0;
        }
        return 1;
    }

    @Override
    @CacheEvict(value={"companyFinance"}, allEntries=true)
    @Transactional
    public void deleteObjByIds(String projectId, Company company, List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        CompanyFinanceExample companyFinanceExample = new CompanyFinanceExample();
        companyFinanceExample.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT).andIdIn((List)ids);
        CompanyFinance companyFinance = new CompanyFinance();
        companyFinance.setIsEnable(Constant.NO_INT);
        this.companyFinanceMapper.updateByExampleSelective(companyFinance, companyFinanceExample);
    }

    @Override
    @CacheEvict(value={"companyFinance"}, allEntries=true)
    @Transactional
    public Integer batchInsert(String projectId, Company company, List<CompanyFinance> companyFinanceList) {
        if (CollectionUtils.isEmpty(companyFinanceList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        CompanyFinanceExample companyFinanceExample = new CompanyFinanceExample();
        companyFinanceExample.createCriteria().andProjectIdEqualTo(projectId).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        CompanyFinance companyFinance = new CompanyFinance();
        companyFinance.setIsEnable(Constant.NO_INT);
        this.companyFinanceMapper.updateByExampleSelective(companyFinance, companyFinanceExample);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (CompanyFinance finance : companyFinanceList) {
            finance.setId(null);
            finance.setProjectId(projectId);
            finance.setSupCompanyId(company.getId());
            finance.setIsEnable(Constant.YES_INT);
            finance.setCreateTime(new Date());
            finance.setUpdateTime(new Date());
            Integer finishFlag = finance.getFinishFlag();
            finance.setFinishFlag(finishFlag);
            this.companyFinanceMapper.insertSelective(finance);
            list.add(finishFlag);
        }
        if (list.contains(Constant.NO_INT)) {
            return 0;
        }
        return 1;
    }

    @CacheEvict(value={"companyFinance"}, allEntries=true)
    public void addObj(CompanyFinance t) {
        this.companyFinanceMapper.insertSelective(t);
    }

    @CacheEvict(value={"companyFinance"}, allEntries=true)
    public void deleteObjById(String id) {
        this.companyFinanceMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"companyFinance"}, allEntries=true)
    public void modifyObj(CompanyFinance t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.companyFinanceMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"companyFinance"}, keyGenerator="redisKeyGenerator")
    public CompanyFinance queryObjById(String id) {
        return this.companyFinanceMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"companyFinance"}, keyGenerator="redisKeyGenerator")
    public List<CompanyFinance> queryAllObjByExample(CompanyFinanceExample example) {
        return this.companyFinanceMapper.selectByExample(example);
    }

    @Cacheable(value={"companyFinance"}, keyGenerator="redisKeyGenerator")
    public PageView<CompanyFinance> queryObjByPage(CompanyFinanceExample example) {
        PageView<CompanyFinance> pageView = example.getPageView();
        pageView.setQueryResult(this.companyFinanceMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"companyFinance"}, allEntries=true)
    public void deleteByExample(CompanyFinanceExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.companyFinanceMapper.deleteByExample(example);
    }

    @CacheEvict(value={"companyFinance"}, allEntries=true)
    @Transactional
    public void addAll(List<CompanyFinance> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.companyFinanceMapper.insertSelective((CompanyFinance)record));
    }
}

