/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.notice.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.common.CertificateTypeCodeEnum;
import com.els.base.certification.common.ConfirmStatusEnum;
import com.els.base.certification.notice.entity.CompanyAuditNotice;
import com.els.base.certification.notice.entity.CompanyAuditNoticeExample;
import com.els.base.certification.notice.service.CompanyAuditNoticeService;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.vo.CompanyProcessVO;
import com.els.base.certification.result.entity.CompanyResultNotice;
import com.els.base.certification.result.entity.CompanyResultNoticeExample;
import com.els.base.certification.result.service.CompanyResultNoticeService;
import com.els.base.certification.result.util.ResultNoticeEnum;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u901a\u77e5\u5355"})
@Controller
@RequestMapping(value={"companyAuditNotice"})
public class CompanyAuditNoticeController {
    @Resource
    private CompanyAuditNoticeService companyAuditNoticeService;
    @Resource
    private CompanyResultNoticeService companyResultNoticeService;
    @Resource
    private CompanyService companyService;
    @Resource
    private DicGroupItemService dicGroupItemService;
    @Resource
    private ProcessService processService;
    @Resource
    private CompanyAuthService companyAuthService;

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u4f9b\u5e94\u5546\u786e\u8ba4\u5ba1\u6838\u901a\u77e5\u5355")
    @RequestMapping(value={"service/confirm"})
    @ResponseBody
    public ResponseResult<String> confirm(@RequestBody(required=true) CompanyAuditNotice data) {
        Assert.isNotNull((Object)data, (String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u64cd\u4f5c\u5931\u8d25");
        this.companyAuditNoticeService.confirm(data);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u6279\u91cf\u4f5c\u5e9f\u5ba1\u6838\u901a\u77e5\u5355\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/abolish"})
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyAuditNoticeService.abolish(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u6279\u91cf\u53d1\u9001\u5ba1\u6838\u901a\u77e5\u5355\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/send"})
    @ResponseBody
    public ResponseResult<String> send(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u53d1\u9001\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyAuditNoticeService.send(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u901a\u77e5\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyAuditNotice companyAuditNotice) {
        Assert.isNotBlank((String)companyAuditNotice.getSupCompanySrmCode(), (String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.companyAuditNoticeService.insert(CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), companyAuditNotice);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u901a\u77e5\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyAuditNoticeService.deleteObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u901a\u77e5\u5355(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyAuditNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyAuditNotice>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        CompanyAuditNoticeExample example = new CompanyAuditNoticeExample();
        example.setPageView((PageView<CompanyAuditNotice>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        CompanyAuditNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andPurCompanyIdEqualTo(ProjectUtils.getCompanyId()).andPurUserIdEqualTo(SpringSecurityUtils.getLoginUserId()).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyAuditNoticeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u901a\u77e5\u5355(\u4f9b\u5e94\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyAuditNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<CompanyAuditNotice>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        CompanyAuditNoticeExample example = new CompanyAuditNoticeExample();
        example.setPageView((PageView<CompanyAuditNotice>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        CompanyAuditNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andSendStatusEqualTo(Constant.YES_INT).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyAuditNoticeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u65b0\u5efa\u7ed3\u679c\u901a\u77e5\u5355\u65f6\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u901a\u77e5\u5355\u6d88\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyAuditNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findNoticeByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyProcessVO>> findNoticeByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        PageView pageData;
        List companyList;
        List companyAuditNoticeList;
        PageView result = new PageView(pageNo, pageSize);
        ArrayList<String> lists = new ArrayList<String>();
        lists.add(ResultNoticeEnum.NOT_AUDITED.getCode());
        lists.add(ResultNoticeEnum.RECTIFICATION.getCode());
        lists.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        CompanyResultNoticeExample example = new CompanyResultNoticeExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andConfirmStatusIn(lists);
        List companyResultNoticeList = this.companyResultNoticeService.queryAllObjByExample((IExample)example);
        List companyCodeList1 = companyResultNoticeList.stream().map(CompanyResultNotice::getSupCompanySrmCode).collect(Collectors.toList());
        CompanyAuditNoticeExample noticeExample = new CompanyAuditNoticeExample();
        CompanyAuditNoticeExample.Criteria criteria = noticeExample.createCriteria().andConfirmStatusEqualTo(ConfirmStatusEnum.STATUS_CONFIRM.getStatus()).andIsEnableEqualTo(Constant.YES_INT);
        if (CollectionUtils.isNotEmpty(companyCodeList1)) {
            criteria.andSupCompanySrmCodeNotIn(companyCodeList1);
        }
        if (CollectionUtils.isEmpty((Collection)(companyAuditNoticeList = this.companyAuditNoticeService.queryAllObjByExample((IExample)noticeExample)))) {
            return ResponseResult.success((Object)result);
        }
        List companyCodeList2 = companyAuditNoticeList.stream().map(CompanyAuditNotice::getSupCompanySrmCode).collect(Collectors.toList());
        CompanyExample companyExample = new CompanyExample();
        companyExample.setPageView(new PageView(pageNo, pageSize));
        companyExample.setOrderByClause("CREATE_TIME DESC");
        CompanyExample.Criteria criteria2 = companyExample.createCriteria().andCompanyCodeIn(companyCodeList2).andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria2, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isEmpty((Collection)(companyList = (pageData = this.companyService.queryObjByPage((IExample)companyExample)).getQueryResult()))) {
            return ResponseResult.success((Object)result);
        }
        List<CompanyProcessVO> voList = this.getSuppliers(companyList);
        result.setQueryResult(voList);
        return ResponseResult.success((Object)result);
    }

    private List<CompanyProcessVO> getSuppliers(List<Company> companyList) {
        ArrayList<CompanyProcessVO> list = new ArrayList<CompanyProcessVO>();
        companyList.forEach(company -> {
            CompanyProcessVO vo = new CompanyProcessVO();
            BeanUtils.copyProperties((Object)company, (Object)((Object)vo));
            this.setSecondCompanyType((Company)company, vo);
            this.setSupplierCertification(vo);
            ProcessExample processExample = new ProcessExample();
            processExample.createCriteria().andCompanyIdEqualTo(company.getId());
            List processList = this.processService.queryAllObjByExample((IExample)processExample);
            if (CollectionUtils.isNotEmpty((Collection)processList)) {
                vo.setProcess((Process)processList.get(0));
            }
            list.add(vo);
        });
        return list;
    }

    private void setSupplierCertification(CompanyProcessVO vo) {
        CompanyAuthExample companyAuthExample = new CompanyAuthExample();
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IATF16949.getCode());
        List<CompanyAuth> companyAuthList = this.companyAuthService.selectByExampleAll(companyAuthExample);
        if (CollectionUtils.isNotEmpty(companyAuthList)) {
            JSONArray json;
            CompanyAuth companyAuth1 = companyAuthList.get(0);
            String str = "";
            if (StringUtils.isNotEmpty((CharSequence)companyAuth1.getCertificateFile()) && (json = JSONArray.fromObject((Object)companyAuth1.getCertificateFile())).size() > 0) {
                JSONObject job = json.getJSONObject(0);
                str = (String)job.get("name");
            }
            vo.setIATF16949FileName(str);
            vo.setIATF16949Name(companyAuth1.getCertificateFile());
            vo.setIATF16949EndTime(companyAuth1.getEndTime());
        }
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS9001.getCode());
        List<CompanyAuth> companyAuthList2 = this.companyAuthService.selectByExampleAll(companyAuthExample);
        if (CollectionUtils.isNotEmpty(companyAuthList2)) {
            JSONArray json;
            CompanyAuth companyAuth2 = companyAuthList2.get(0);
            String str = "";
            if (StringUtils.isNotEmpty((CharSequence)companyAuth2.getCertificateFile()) && (json = JSONArray.fromObject((Object)companyAuth2.getCertificateFile())).size() > 0) {
                JSONObject job = json.getJSONObject(0);
                str = (String)job.get("name");
            }
            vo.setISO9001FileName(str);
            vo.setISO9001Name(companyAuth2.getCertificateFile());
            vo.setISO9001EndTime(companyAuth2.getEndTime());
        }
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS14000.getCode());
        List<CompanyAuth> companyAuthList3 = this.companyAuthService.selectByExampleAll(companyAuthExample);
        if (CollectionUtils.isNotEmpty(companyAuthList3)) {
            JSONArray json;
            CompanyAuth companyAuth3 = companyAuthList3.get(0);
            String str = "";
            if (StringUtils.isNotEmpty((CharSequence)companyAuth3.getCertificateFile()) && (json = JSONArray.fromObject((Object)companyAuth3.getCertificateFile())).size() > 0) {
                JSONObject job = json.getJSONObject(0);
                str = (String)job.get("name");
            }
            vo.setISO14000FileName(str);
            vo.setISO14000Name(companyAuth3.getCertificateFile());
            vo.setISO14000EndTime(companyAuth3.getEndTime());
        }
    }

    private void setSecondCompanyType(Company company, CompanyProcessVO vo) {
        Object[] secondCompanyTypeStr;
        String secondCompanyType = company.getSecondCompanyType();
        if (StringUtils.isNotBlank((CharSequence)secondCompanyType) && ArrayUtils.isNotEmpty((Object[])(secondCompanyTypeStr = secondCompanyType.split(",")))) {
            if (secondCompanyTypeStr.length > 5) {
                vo.setSecondCompanyType1((String)secondCompanyTypeStr[0]);
                DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[0]);
                if (dicItem1 != null) {
                    vo.setSecondCompanyTypeDesc1(dicItem1.getName());
                } else {
                    vo.setSecondCompanyTypeDesc1("");
                }
                vo.setSecondCompanyType2((String)secondCompanyTypeStr[1]);
                DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[1]);
                if (dicItem2 != null) {
                    vo.setSecondCompanyTypeDesc2(dicItem2.getName());
                } else {
                    vo.setSecondCompanyTypeDesc2("");
                }
                vo.setSecondCompanyType3((String)secondCompanyTypeStr[2]);
                DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[2]);
                if (dicItem3 != null) {
                    vo.setSecondCompanyTypeDesc3(dicItem3.getName());
                } else {
                    vo.setSecondCompanyTypeDesc3("");
                }
                vo.setSecondCompanyType4((String)secondCompanyTypeStr[3]);
                DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[3]);
                if (dicItem4 != null) {
                    vo.setSecondCompanyTypeDesc4(dicItem4.getName());
                } else {
                    vo.setSecondCompanyTypeDesc4("");
                }
                vo.setSecondCompanyType5((String)secondCompanyTypeStr[4]);
                DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[4]);
                if (dicItem5 != null) {
                    vo.setSecondCompanyTypeDesc5(dicItem5.getName());
                } else {
                    vo.setSecondCompanyTypeDesc5("");
                }
            } else {
                for (int i = 1; i <= secondCompanyTypeStr.length; ++i) {
                    if (i == 1) {
                        vo.setSecondCompanyType1((String)secondCompanyTypeStr[0]);
                        DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[0]);
                        if (dicItem1 != null) {
                            vo.setSecondCompanyTypeDesc1(dicItem1.getName());
                            continue;
                        }
                        vo.setSecondCompanyTypeDesc1("");
                        continue;
                    }
                    if (i == 2) {
                        vo.setSecondCompanyType2((String)secondCompanyTypeStr[1]);
                        DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[1]);
                        if (dicItem2 != null) {
                            vo.setSecondCompanyTypeDesc2(dicItem2.getName());
                            continue;
                        }
                        vo.setSecondCompanyTypeDesc2("");
                        continue;
                    }
                    if (i == 3) {
                        vo.setSecondCompanyType3((String)secondCompanyTypeStr[2]);
                        DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[2]);
                        if (dicItem3 != null) {
                            vo.setSecondCompanyTypeDesc3(dicItem3.getName());
                            continue;
                        }
                        vo.setSecondCompanyTypeDesc3("");
                        continue;
                    }
                    if (i == 4) {
                        vo.setSecondCompanyType4((String)secondCompanyTypeStr[3]);
                        DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[3]);
                        if (dicItem4 != null) {
                            vo.setSecondCompanyTypeDesc4(dicItem4.getName());
                            continue;
                        }
                        vo.setSecondCompanyTypeDesc4("");
                        continue;
                    }
                    if (i != 5) continue;
                    vo.setSecondCompanyType5((String)secondCompanyTypeStr[4]);
                    DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[4]);
                    if (dicItem5 != null) {
                        vo.setSecondCompanyTypeDesc5(dicItem5.getName());
                        continue;
                    }
                    vo.setSecondCompanyTypeDesc5("");
                }
            }
        }
    }
}

