/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.process.web.controller;

import com.els.base.auth.service.RoleService;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.auth.entity.CompanyAuth;
import com.els.base.certification.auth.entity.CompanyAuthExample;
import com.els.base.certification.auth.service.CompanyAuthService;
import com.els.base.certification.common.CertificateTypeCodeEnum;
import com.els.base.certification.management.entity.ProcessManagement;
import com.els.base.certification.management.service.ProcessManagementService;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.util.AccessProcessEnum;
import com.els.base.certification.process.util.ReviewResultEnum;
import com.els.base.certification.process.vo.CompanyProcessVO;
import com.els.base.certification.process.vo.CompanyQualificationVO;
import com.els.base.certification.process.vo.ReportFormVO;
import com.els.base.certification.qualificationssm.entity.QualificationsSM;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlieExample;
import com.els.base.certification.qualificationssm.service.QualificationsSMFlieService;
import com.els.base.certification.qualificationssm.service.QualificationsSMService;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.company.utils.SupplierStatusEnum;
import com.els.base.core.entity.AbstractExample;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.core.web.interceptor.ProjectInitInterceptor;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u4f9b\u5e94\u5546\u51c6\u5165-\u51c6\u5165\u6d41\u7a0b"})
@Controller
@RequestMapping(value={"process"})
public class ProcessController {
    private Logger log = LoggerFactory.getLogger(ProjectInitInterceptor.class);
    @Resource
    protected ProcessService processService;
    @Resource
    protected CompanyService companyService;
    @Resource
    private DicGroupItemService dicGroupItemService;
    @Resource
    private CompanyAuthService companyAuthService;
    @Resource
    private QualificationsSMService qualificationsSMService;
    @Resource
    private QualificationsSMFlieService qualificationsSMFlieService;
    @Resource
    private ProcessManagementService processManagementService;
    @Resource
    protected RoleService roleService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u51c6\u5165\u6d41\u7a0b")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Process process) {
        Assert.isNotNull((Object)process, (String)"\u4fdd\u5b58\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)process.getCompanyId(), (String)"\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)process.getAccessProcess(), (String)"\u51c6\u5165\u6d41\u7a0b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)process.getProcessName(), (String)"\u51c6\u5165\u6d41\u7a0b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        this.processService.addObj(process);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u51c6\u5165-\u51c6\u5165\u6d41\u7a0b")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Process process) {
        Assert.isNotBlank((String)process.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.processService.modifyObj(process);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u51c6\u5165-\u51c6\u5165\u6d41\u7a0b")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.processService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u51c6\u5165\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Process", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Process>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ProcessExample example = new ProcessExample();
        example.setPageView((PageView<Process>)new PageView(pageNo, pageSize));
        example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.processService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8d44\u8d28\u5ba1\u6838\u3001\u73b0\u573a\u8003\u5bdf\u5355\u65f6\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0e\u51c6\u5165\u6d41\u7a0b\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="accessProcess", required=true, value="\u5ba1\u6838\u6d41\u7a0b\uff1a\u4e0d\u9700\u5ba1\u6838\uff0c\u53ea\u8d44\u8d28\u5ba1\u6838\uff0c\u53ea\u73b0\u573a\u8003\u6838\uff0c\u8d44\u8d28\u5ba1\u6838->\u73b0\u573a\u8003\u6838 (1,2,3,4)", paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Process", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findCompanyByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyQualificationVO>> findCompanyByPage(@RequestParam String accessProcess, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        Assert.isNotBlank((String)accessProcess, (String)"\u4f20\u5165\u7684\u51c6\u5165\u6d41\u7a0b\u4e0d\u80fd\u4e3a\u7a7a");
        CompanyExample companyExample = new CompanyExample();
        companyExample.setPageView(new PageView(pageNo, pageSize));
        companyExample.setOrderByClause("CREATE_TIME DESC");
        CompanyExample.Criteria criteria = companyExample.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)companyExample, (QueryParamWapper)wapper);
        }
        String roleEnum = SupplierStatusEnum.ADMITTING.code();
        String purCompanyId = CompanyUtils.currentCompanyId();
        PageView companyPageView = this.companyService.querySupplerCompanies(purCompanyId, companyExample, roleEnum);
        List companyList = companyPageView.getQueryResult();
        PageView companyVoPage = new PageView(pageNo, pageSize);
        if (CollectionUtils.isEmpty((Collection)companyList)) {
            return ResponseResult.success((Object)companyVoPage);
        }
        int rowCount = 0;
        ArrayList<CompanyQualificationVO> voList = new ArrayList<CompanyQualificationVO>();
        for (Company company : companyList) {
            List fileList;
            QualificationsSMFlieExample fileExample;
            QualificationsSM qualificationSM;
            ProcessManagement manage;
            CompanyProcessVO companyProcessVO = new CompanyProcessVO();
            BeanUtils.copyProperties((Object)company, (Object)((Object)companyProcessVO));
            this.setSupplierCertification(companyProcessVO);
            Process process = this.processService.queryObjByCompanyId(company.getId());
            if (null == process) continue;
            companyProcessVO.setProcess(process);
            CompanyQualificationVO vo = new CompanyQualificationVO();
            if ("2".equals(accessProcess)) {
                if (!AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(process.getAccessProcess()) && !AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(process.getAccessProcess()) || !StringUtils.isBlank((String)process.getQualificationAudit()) && !ReviewResultEnum.TERMINATION.getCode().equals(process.getQualificationAudit())) continue;
                manage = (ProcessManagement)this.processManagementService.queryObjById(process.getProcessId());
                qualificationSM = (QualificationsSM)this.qualificationsSMService.queryObjById(manage.getQualificationAuditTemplateId());
                fileExample = new QualificationsSMFlieExample();
                fileExample.createCriteria().andTemplatIdEqualTo(manage.getQualificationAuditTemplateId()).andIsEnableEqualTo(Constant.YES_INT);
                fileList = this.qualificationsSMFlieService.queryAllObjByExample((IExample)fileExample);
                qualificationSM.setQualificationsSMFlielist(fileList);
                BeanUtils.copyProperties((Object)company, (Object)((Object)vo));
                vo.setCompanyProcessVO(companyProcessVO);
                vo.setQualifications(qualificationSM);
                voList.add(vo);
                ++rowCount;
                continue;
            }
            if (!"3".equals(accessProcess) || !AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(process.getAccessProcess()) && (!AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(process.getAccessProcess()) || !ReviewResultEnum.ADOPT.getCode().equals(process.getQualificationAudit())) || !StringUtils.isBlank((String)process.getSceneInvestigate()) && !ReviewResultEnum.TERMINATION.getCode().equals(process.getSceneInvestigate())) continue;
            manage = (ProcessManagement)this.processManagementService.queryObjById(process.getProcessId());
            qualificationSM = (QualificationsSM)this.qualificationsSMService.queryObjById(manage.getSiteInspectionTemplateId());
            fileExample = new QualificationsSMFlieExample();
            fileExample.createCriteria().andTemplatIdEqualTo(manage.getSiteInspectionTemplateId()).andIsEnableEqualTo(Constant.YES_INT);
            fileList = this.qualificationsSMFlieService.queryAllObjByExample((IExample)fileExample);
            qualificationSM.setQualificationsSMFlielist(fileList);
            BeanUtils.copyProperties((Object)company, (Object)((Object)vo));
            vo.setCompanyProcessVO(companyProcessVO);
            vo.setQualifications(qualificationSM);
            voList.add(vo);
            ++rowCount;
        }
        companyVoPage.setQueryResult(voList);
        companyVoPage.setRowCount(rowCount);
        return ResponseResult.success((Object)companyVoPage);
    }

    @ApiOperation(httpMethod="POST", value="\u51c6\u5165\u62a5\u8868-\u51c6\u5165\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Process", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/formFindByPage"})
    @ResponseBody
    public ResponseResult<PageView<ReportFormVO>> formFindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.setPageView(new PageView(pageNo, pageSize));
        companyExample.setOrderByClause("CREATE_TIME DESC");
        companyExample.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)companyExample, (QueryParamWapper)wapper);
        }
        PageView companyPage = this.companyService.queryObjByPage((IExample)companyExample);
        List companyList = companyPage.getQueryResult();
        List<ReportFormVO> list = this.getReportForm(companyList);
        PageView formPage = new PageView(pageNo, pageSize);
        formPage.setQueryResult(list);
        return ResponseResult.success((Object)formPage);
    }

    private List<ReportFormVO> getReportForm(List<Company> companyList) {
        ArrayList<ReportFormVO> list = new ArrayList<ReportFormVO>();
        for (Company company : companyList) {
            ReportFormVO vo = new ReportFormVO();
            Process process = this.processService.queryObjByCompanyId(company.getId());
            if (null == process) continue;
            vo.setSupCompanyName(company.getCompanyFullName());
            vo.setSupCompanySrmCode(company.getCompanyCode());
            vo.setStartTime(company.getCreateTime());
            vo.setSupplierLevelCode(process.getSupplierLevelCode());
            vo.setSupClassificationName(process.getSupClassificationName());
            vo.setAccessProcess(process.getAccessProcess());
            if (AccessProcessEnum.QUALIFICATION_REVIEW.getCode().equals(process.getAccessProcess())) {
                vo.setStatus(process.getQualificationAudit());
                if (!ReviewResultEnum.AUDIT.getCode().equals(process.getQualificationAudit())) {
                    vo.setEndTime(process.getUpdateTime());
                }
            }
            if (AccessProcessEnum.SCENE_ASSESSMENT.getCode().equals(process.getAccessProcess())) {
                vo.setStatus(process.getSceneInvestigate());
                if (!ReviewResultEnum.AUDIT.getCode().equals(process.getSceneInvestigate())) {
                    vo.setEndTime(process.getUpdateTime());
                }
            }
            if (AccessProcessEnum.QUALIFICATION_AND_SCENE_REVIEW.getCode().equals(process.getAccessProcess())) {
                vo.setStatus(ReviewResultEnum.AUDIT.getCode());
                if (ReviewResultEnum.TERMINATION.getCode().equals(process.getQualificationAudit())) {
                    vo.setStatus(process.getQualificationAudit());
                    vo.setEndTime(process.getUpdateTime());
                }
                if (!ReviewResultEnum.AUDIT.getCode().equals(process.getSceneInvestigate())) {
                    vo.setStatus(process.getSceneInvestigate());
                    vo.setEndTime(process.getUpdateTime());
                }
            }
            list.add(vo);
        }
        return list;
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0e\u51c6\u5165\u6d41\u7a0b\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Process", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAllCompanyByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyProcessVO>> findAllCompanyByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyExample companyExample = new CompanyExample();
        companyExample.setPageView(new PageView(pageNo, pageSize));
        companyExample.setOrderByClause("CREATE_TIME DESC");
        CompanyExample.Criteria criteria = companyExample.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)companyExample, (QueryParamWapper)wapper);
        }
        String purCompanyId = CompanyUtils.currentCompanyId();
        PageView companyPageView = this.companyService.querySupplerCompanies(purCompanyId, companyExample, SupplierStatusEnum.ADMITTING.code());
        List companyList = companyPageView.getQueryResult();
        PageView companyProcessPage = new PageView(pageNo, pageSize);
        companyProcessPage.setRowCount(companyPageView.getRowCount());
        if (CollectionUtils.isEmpty((Collection)companyList)) {
            return ResponseResult.success((Object)companyProcessPage);
        }
        List<CompanyProcessVO> list = this.getSuppliers(companyList);
        companyProcessPage.setQueryResult(list);
        return ResponseResult.success((Object)companyProcessPage);
    }

    private List<CompanyProcessVO> getSuppliers(List<Company> companyList) {
        ArrayList<CompanyProcessVO> list = new ArrayList<CompanyProcessVO>();
        companyList.forEach(company -> {
            CompanyProcessVO vo = new CompanyProcessVO();
            BeanUtils.copyProperties((Object)company, (Object)((Object)vo));
            this.setSecondCompanyType((Company)company, vo);
            this.setSupplierCertification(vo);
            ProcessExample processExample = new ProcessExample();
            processExample.createCriteria().andCompanyIdEqualTo(company.getId());
            List processList = this.processService.queryAllObjByExample((IExample)processExample);
            if (CollectionUtils.isNotEmpty((Collection)processList)) {
                vo.setProcess((Process)processList.get(0));
            }
            list.add(vo);
        });
        return list;
    }

    private void setSupplierCertification(CompanyProcessVO vo) {
        CompanyAuthExample companyAuthExample = new CompanyAuthExample();
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IATF16949.getCode());
        List<CompanyAuth> companyAuthList = this.companyAuthService.selectByExampleAll(companyAuthExample);
        if (CollectionUtils.isNotEmpty(companyAuthList)) {
            JSONArray json;
            CompanyAuth companyAuth1 = companyAuthList.get(0);
            String str = "";
            if (StringUtils.isNotEmpty((String)companyAuth1.getCertificateFile()) && (json = JSONArray.fromObject((Object)companyAuth1.getCertificateFile())).size() > 0) {
                JSONObject job = json.getJSONObject(0);
                str = (String)job.get("name");
            }
            vo.setIATF16949FileName(str);
            vo.setIATF16949Name(companyAuth1.getCertificateFile());
            vo.setIATF16949EndTime(companyAuth1.getEndTime());
        }
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS9001.getCode());
        List<CompanyAuth> companyAuthList2 = this.companyAuthService.selectByExampleAll(companyAuthExample);
        if (CollectionUtils.isNotEmpty(companyAuthList2)) {
            JSONArray json;
            CompanyAuth companyAuth2 = companyAuthList2.get(0);
            String str = "";
            if (StringUtils.isNotEmpty((String)companyAuth2.getCertificateFile()) && (json = JSONArray.fromObject((Object)companyAuth2.getCertificateFile())).size() > 0) {
                JSONObject job = json.getJSONObject(0);
                str = (String)job.get("name");
            }
            vo.setISO9001FileName(str);
            vo.setISO9001Name(companyAuth2.getCertificateFile());
            vo.setISO9001EndTime(companyAuth2.getEndTime());
        }
        companyAuthExample.clear();
        companyAuthExample.createCriteria().andSupCompanyIdEqualTo(vo.getId()).andIsEnableEqualTo(Constant.YES_INT).andCertificateTypeCodeEqualTo(CertificateTypeCodeEnum.IOS14000.getCode());
        List<CompanyAuth> companyAuthList3 = this.companyAuthService.selectByExampleAll(companyAuthExample);
        if (CollectionUtils.isNotEmpty(companyAuthList3)) {
            JSONArray json;
            CompanyAuth companyAuth3 = companyAuthList3.get(0);
            String str = "";
            if (StringUtils.isNotEmpty((String)companyAuth3.getCertificateFile()) && (json = JSONArray.fromObject((Object)companyAuth3.getCertificateFile())).size() > 0) {
                JSONObject job = json.getJSONObject(0);
                str = (String)job.get("name");
            }
            vo.setISO14000FileName(str);
            vo.setISO14000Name(companyAuth3.getCertificateFile());
            vo.setISO14000EndTime(companyAuth3.getEndTime());
        }
    }

    private void setSecondCompanyType(Company company, CompanyProcessVO vo) {
        Object[] secondCompanyTypeStr;
        String secondCompanyType = company.getSecondCompanyType();
        if (StringUtils.isNotBlank((String)secondCompanyType) && ArrayUtils.isNotEmpty((Object[])(secondCompanyTypeStr = secondCompanyType.split(",")))) {
            if (secondCompanyTypeStr.length > 5) {
                vo.setSecondCompanyType1((String)secondCompanyTypeStr[0]);
                DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[0]);
                if (dicItem1 != null) {
                    vo.setSecondCompanyTypeDesc1(dicItem1.getName());
                } else {
                    vo.setSecondCompanyTypeDesc1("");
                }
                vo.setSecondCompanyType2((String)secondCompanyTypeStr[1]);
                DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[1]);
                if (dicItem2 != null) {
                    vo.setSecondCompanyTypeDesc2(dicItem2.getName());
                } else {
                    vo.setSecondCompanyTypeDesc2("");
                }
                vo.setSecondCompanyType3((String)secondCompanyTypeStr[2]);
                DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[2]);
                if (dicItem3 != null) {
                    vo.setSecondCompanyTypeDesc3(dicItem3.getName());
                } else {
                    vo.setSecondCompanyTypeDesc3("");
                }
                vo.setSecondCompanyType4((String)secondCompanyTypeStr[3]);
                DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[3]);
                if (dicItem4 != null) {
                    vo.setSecondCompanyTypeDesc4(dicItem4.getName());
                } else {
                    vo.setSecondCompanyTypeDesc4("");
                }
                vo.setSecondCompanyType5((String)secondCompanyTypeStr[4]);
                DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[4]);
                if (dicItem5 != null) {
                    vo.setSecondCompanyTypeDesc5(dicItem5.getName());
                } else {
                    vo.setSecondCompanyTypeDesc5("");
                }
            } else {
                for (int i = 1; i <= secondCompanyTypeStr.length; ++i) {
                    if (i == 1) {
                        vo.setSecondCompanyType1((String)secondCompanyTypeStr[0]);
                        DicGroupItem dicItem1 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[0]);
                        if (dicItem1 != null) {
                            vo.setSecondCompanyTypeDesc1(dicItem1.getName());
                            continue;
                        }
                        vo.setSecondCompanyTypeDesc1("");
                        continue;
                    }
                    if (i == 2) {
                        vo.setSecondCompanyType2((String)secondCompanyTypeStr[1]);
                        DicGroupItem dicItem2 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[1]);
                        if (dicItem2 != null) {
                            vo.setSecondCompanyTypeDesc2(dicItem2.getName());
                            continue;
                        }
                        vo.setSecondCompanyTypeDesc2("");
                        continue;
                    }
                    if (i == 3) {
                        vo.setSecondCompanyType3((String)secondCompanyTypeStr[2]);
                        DicGroupItem dicItem3 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[2]);
                        if (dicItem3 != null) {
                            vo.setSecondCompanyTypeDesc3(dicItem3.getName());
                            continue;
                        }
                        vo.setSecondCompanyTypeDesc3("");
                        continue;
                    }
                    if (i == 4) {
                        vo.setSecondCompanyType4((String)secondCompanyTypeStr[3]);
                        DicGroupItem dicItem4 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[3]);
                        if (dicItem4 != null) {
                            vo.setSecondCompanyTypeDesc4(dicItem4.getName());
                            continue;
                        }
                        vo.setSecondCompanyTypeDesc4("");
                        continue;
                    }
                    if (i != 5) continue;
                    vo.setSecondCompanyType5((String)secondCompanyTypeStr[4]);
                    DicGroupItem dicItem5 = this.dicGroupItemService.queryItems("zr_gongsizhuyingerlei", (String)secondCompanyTypeStr[4]);
                    if (dicItem5 != null) {
                        vo.setSecondCompanyTypeDesc5(dicItem5.getName());
                        continue;
                    }
                    vo.setSecondCompanyTypeDesc5("");
                }
            }
        }
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0e\u51c6\u5165\u6d41\u7a0b\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="map", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Process", paramType="body", dataType="Map")})
    @RequestMapping(value={"service/findAllCompanyByPages"})
    @ResponseBody
    public ResponseResult<PageView<CompanyProcessVO>> findAllCompanyByPages(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        String purCompanyId = CompanyUtils.currentCompanyId();
        CompanyExample companyExample = (CompanyExample)this.extractExample(wapper, CompanyExample.class);
        ProcessExample processExample = (ProcessExample)this.extractExample(wapper, ProcessExample.class);
        companyExample.setPageView(new PageView(pageNo, pageSize));
        PageView<Company> companyPageView = this.processService.queryCompanyByPage(companyExample, processExample, purCompanyId, SupplierStatusEnum.ADMITTING.code());
        int count = companyPageView.getRowCount();
        this.log.info(purCompanyId, (Object)companyPageView.getQueryResult());
        List companyList = companyPageView.getQueryResult();
        PageView companyProcessPage = new PageView(pageNo, pageSize);
        if (CollectionUtils.isEmpty((Collection)companyList)) {
            return ResponseResult.success((Object)companyProcessPage);
        }
        List<CompanyProcessVO> list = this.getSuppliers(companyList);
        companyProcessPage.setQueryResult(list);
        companyProcessPage.setRowCount(count);
        return ResponseResult.success((Object)companyProcessPage);
    }

    private AbstractExample<?> extractExample(QueryParamWapper wapper, Class<? extends AbstractExample<?>> exampleType) {
        AbstractExample<?> example = this.createEmptyExample(exampleType);
        if (wapper == null || CollectionUtils.isEmpty((Collection)wapper.getQueryParams()) && CollectionUtils.isEmpty((Collection)wapper.getOrderByParams())) {
            return example;
        }
        ParameterizedType genericSuperclass = (ParameterizedType)exampleType.getGenericSuperclass();
        String typeName = genericSuperclass.getActualTypeArguments()[0].getTypeName();
        Class<?> clazz = null;
        try {
            clazz = Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            this.log.warn("\u83b7\u53d6\u7c7b{}\u5931\u8d25", (Object)typeName);
            return example;
        }
        Field[] fields = clazz.getDeclaredFields();
        if (fields == null || fields.length == 0) {
            return example;
        }
        List queryParamList = null;
        if (CollectionUtils.isNotEmpty((Collection)wapper.getQueryParams())) {
            queryParamList = wapper.getQueryParams().stream().filter(param -> {
                for (Field field : fields) {
                    if (!field.getName().equals(param.getProperty())) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }
        List orderByParamList = null;
        if (CollectionUtils.isNotEmpty((Collection)wapper.getOrderByParams())) {
            orderByParamList = wapper.getOrderByParams().stream().filter(param -> {
                for (Field field : fields) {
                    if (!field.getName().equals(param.getProp())) continue;
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
        }
        QueryParamWapper newWapper = new QueryParamWapper();
        newWapper.setQueryParams(queryParamList);
        newWapper.setOrderByParams(orderByParamList);
        CriteriaUtils.addExample(example, (QueryParamWapper)newWapper);
        return example;
    }

    private AbstractExample<?> createEmptyExample(Class<? extends AbstractExample<?>> exampleType) {
        AbstractExample<?> result = null;
        if (exampleType != null) {
            try {
                result = exampleType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.log.warn("\u65e0\u6cd5\u5b9e\u4f8b\u5316\u7c7b{}", exampleType);
            }
        }
        return result;
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u4e0e\u51c6\u5165\u6d41\u7a0b\u4fe1\u606f")
    @RequestMapping(value={"service/findCompanyInFo"})
    @ResponseBody
    public ResponseResult<CompanyProcessVO> findCompanyInFo(@RequestParam(required=true) String companyId) {
        Assert.isNotBlank((String)companyId, (String)"\u4f9b\u5e94\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
        Company company = (Company)this.companyService.queryObjById((Object)companyId);
        ArrayList<Company> companyList = new ArrayList<Company>();
        companyList.add(company);
        List<CompanyProcessVO> list = this.getSuppliers(companyList);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return ResponseResult.success((Object)((Object)list.get(0)));
    }

    @ApiOperation(value="\u5f85\u51c6\u5165\u4f9b\u5e94\u5546\u51c6\u5165", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="companyCode", required=true, value="\u4f9b\u5e94\u5546\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="processId", required=true, value="\u51c6\u5165\u6d41\u7a0bID", paramType="query", dataType="String")})
    @RequestMapping(value={"service/admit"})
    @ResponseBody
    public ResponseResult<String> admit(@RequestParam String companyCode, @RequestParam String processId) {
        this.validatePermission("CGJBR");
        Company supCompany = this.companyService.queryCompanyByCode(companyCode);
        if (supCompany == null) {
            throw new CommonException("\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a" + companyCode + "\u7684\u4f9b\u5e94\u5546");
        }
        if (!SupplierStatusEnum.WAIT_FOR_ADMITTANCE.code().equals(supCompany.getSupplierStatusCode())) {
            throw new CommonException("\u53ea\u6709\u5f85\u51c6\u5165\u7684\u4f9b\u5e94\u5546\u624d\u80fd\u51c6\u5165");
        }
        ProcessManagement manage = (ProcessManagement)this.processManagementService.queryObjById(processId);
        if (manage == null || !Integer.valueOf(1).equals(manage.getIsEnable())) {
            throw new CommonException("\u4e0d\u5b58\u5728id\u4e3a" + processId + "\u7684\u51c6\u5165\u6d41\u7a0b");
        }
        Process process = new Process();
        process.setCompanyId(supCompany.getId());
        process.setCompanySrmCode(companyCode);
        process.setProcessId(manage.getId());
        process.setProcessName(manage.getProcessName());
        process.setAccessProcess(manage.getAccessProcess());
        process.setQualificationAudittemplateId(manage.getQualificationAuditTemplateId());
        process.setSiteInspectionTemplateId(manage.getSiteInspectionTemplateId());
        process.setSupplierLevelCode(manage.getSupplierLevelCode());
        process.setSupClassificationName(manage.getSupClassificationName());
        process.setIsEnable(1);
        this.processService.admit(process);
        return ResponseResult.success();
    }

    private void validatePermission(String roleCode) {
        String currentUserId = SpringSecurityUtils.getLoginUserId();
        List ownRoles = this.roleService.queryUserOwnRoles(currentUserId);
        if (CollectionUtils.isEmpty((Collection)ownRoles) || ownRoles.stream().noneMatch(role -> role.getRoleCode().equals(roleCode))) {
            throw new CommonException("\u60a8\u6ca1\u6709\u64cd\u4f5c\u6743\u9650");
        }
    }
}

