/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.qualificationssm.service.impl;

import com.els.base.certification.management.entity.ProcessManagementExample;
import com.els.base.certification.management.service.ProcessManagementService;
import com.els.base.certification.qualificationssm.dao.QualificationsSMMapper;
import com.els.base.certification.qualificationssm.entity.QualificationsSM;
import com.els.base.certification.qualificationssm.entity.QualificationsSMExample;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlie;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlieExample;
import com.els.base.certification.qualificationssm.service.QualificationsSMFlieService;
import com.els.base.certification.qualificationssm.service.QualificationsSMService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultQualificationsSMService")
public class QualificationsSMServiceImpl
implements QualificationsSMService {
    @Resource
    protected QualificationsSMMapper qualificationsSMMapper;
    @Resource
    protected QualificationsSMFlieService qualificationsSMFlieService;
    @Resource
    protected ProcessManagementService processManagementService;

    @Transactional
    @CacheEvict(value={"qualificationsSM"}, allEntries=true)
    public void addObj(QualificationsSM t) {
        Assert.isNotNull((Object)t, (String)"\u65b0\u589e\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        QualificationsSMExample example = new QualificationsSMExample();
        example.createCriteria().andTemplatCodeEqualTo(t.getTemplatCode()).andIsEnableEqualTo(Constant.YES_INT).andTemplateCategoryEqualTo(t.getTemplateCategory());
        if (this.qualificationsSMMapper.countByExample(example) > 0) {
            throw new CommonException("\u6a21\u7248\u7f16\u53f7" + t.getTemplatCode() + "\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u5728\u4f7f\u7528\u6b64\u7f16\u53f7");
        }
        t.setCreateTime(new Date());
        t.setUpdateTime(new Date());
        t.setIsEnable(Constant.YES_INT);
        this.qualificationsSMMapper.insertSelective(t);
        if (CollectionUtils.isNotEmpty(t.getQualificationsSMFlielist())) {
            for (QualificationsSMFlie qualificationsSMFlie : t.getQualificationsSMFlielist()) {
                qualificationsSMFlie.setCreateTime(new Date());
                qualificationsSMFlie.setUpdateTime(new Date());
                qualificationsSMFlie.setIsEnable(Constant.YES_INT);
                qualificationsSMFlie.setTemplatId(t.getId());
            }
            this.qualificationsSMFlieService.addAll(t.getQualificationsSMFlielist());
        }
    }

    @Transactional
    @CacheEvict(value={"qualificationsSM"}, allEntries=true)
    public void deleteObjById(String id) {
        QualificationsSM qualificationsSM = this.qualificationsSMMapper.selectByPrimaryKey(id);
        this.qualificationsSMFlieService.Softdeletions(qualificationsSM.getId());
        this.qualificationsSMMapper.deleteByPrimaryKey(id);
    }

    @Override
    @Transactional
    @CacheEvict(value={"qualificationsSM"}, allEntries=true)
    public void deleteObjByIds(String id) {
        ProcessManagementExample processExample = new ProcessManagementExample();
        ProcessManagementExample.Criteria criteria = processExample.createCriteria();
        criteria.andQualificationAuditTemplateIdEqualTo(id).andIsEnableEqualTo(Constant.YES_INT);
        ProcessManagementExample.Criteria or = processExample.or();
        or.andSiteInspectionTemplateIdEqualTo(id).andIsEnableEqualTo(Constant.YES_INT);
        if (this.processManagementService.countByExample(processExample) > 0) {
            throw new CommonException("\u6240\u9009\u6a21\u7248\u5df2\u5728\u6d41\u7a0b\u7ba1\u7406\u4e2d\u4f7f\u7528\uff0c\u5220\u9664\u5931\u8d25");
        }
        QualificationsSM qualificationsSM = new QualificationsSM();
        qualificationsSM.setId(id);
        qualificationsSM.setIsEnable(Constant.NO_INT);
        this.qualificationsSMMapper.updateByPrimaryKeySelective(qualificationsSM);
        QualificationsSMFlieExample fileExample = new QualificationsSMFlieExample();
        fileExample.createCriteria().andTemplatIdEqualTo(id).andIsEnableEqualTo(Constant.YES_INT);
        List list = this.qualificationsSMFlieService.queryAllObjByExample((IExample)fileExample);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (QualificationsSMFlie qualificationsSMFlie : list) {
            qualificationsSMFlie.setIsEnable(Constant.NO_INT);
            this.qualificationsSMFlieService.modifyObj(qualificationsSMFlie);
        }
    }

    @Transactional
    @CacheEvict(value={"qualificationsSM"}, allEntries=true)
    public void modifyObj(QualificationsSM t) {
        Assert.isNotBlank((String)t.getId(), (String)"ID\u4e3a\u7a7a\uff0c\u7f16\u8f91\u5931\u8d25");
        QualificationsSM sm = this.qualificationsSMMapper.selectByPrimaryKey(t.getId());
        if (!sm.getTemplatCode().equals(t.getTemplatCode())) {
            QualificationsSMExample example = new QualificationsSMExample();
            example.createCriteria().andTemplatCodeEqualTo(t.getTemplatCode()).andIsEnableEqualTo(Constant.YES_INT).andTemplateCategoryEqualTo(t.getTemplateCategory());
            if (this.qualificationsSMMapper.countByExample(example) > 0) {
                throw new CommonException("\u6a21\u7248\u7f16\u53f7" + t.getTemplatCode() + "\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u518d\u4f7f\u7528");
            }
        }
        t.setUpdateTime(new Date());
        this.qualificationsSMMapper.updateByPrimaryKeySelective(t);
        if (CollectionUtils.isNotEmpty(t.getQualificationsSMFlielist())) {
            QualificationsSMFlieExample fileExample = new QualificationsSMFlieExample();
            fileExample.createCriteria().andTemplatIdEqualTo(t.getId()).andIsEnableEqualTo(Constant.YES_INT);
            List fileList = this.qualificationsSMFlieService.queryAllObjByExample((IExample)fileExample);
            if (CollectionUtils.isEmpty((Collection)fileList)) {
                return;
            }
            fileList.forEach(file -> this.qualificationsSMFlieService.deleteObjById(file.getId()));
            for (QualificationsSMFlie qualificationsSMFlie : t.getQualificationsSMFlielist()) {
                qualificationsSMFlie.setId(null);
                qualificationsSMFlie.setCreateTime(new Date());
                qualificationsSMFlie.setUpdateTime(new Date());
                qualificationsSMFlie.setIsEnable(Constant.YES_INT);
                qualificationsSMFlie.setTemplatId(t.getId());
            }
            this.qualificationsSMFlieService.addAll(t.getQualificationsSMFlielist());
        }
    }

    @Cacheable(value={"qualificationsSM"}, keyGenerator="redisKeyGenerator")
    public QualificationsSM queryObjById(String id) {
        return this.qualificationsSMMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"qualificationsSM"}, keyGenerator="redisKeyGenerator")
    public List<QualificationsSM> queryAllObjByExample(QualificationsSMExample example) {
        return this.qualificationsSMMapper.selectByExample(example);
    }

    @Cacheable(value={"qualificationsSM"}, keyGenerator="redisKeyGenerator")
    public PageView<QualificationsSM> queryObjByPage(QualificationsSMExample example) {
        PageView<QualificationsSM> pageView = example.getPageView();
        pageView.setQueryResult(this.qualificationsSMMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"qualificationsSM"}, keyGenerator="redisKeyGenerator")
    public QualificationsSM selectListAll(String id) {
        QualificationsSM qualificationsSM = this.qualificationsSMMapper.selectByPrimaryKey(id);
        qualificationsSM.setQualificationsSMFlielist(this.qualificationsSMFlieService.selectTemplatId(qualificationsSM.getId()));
        return qualificationsSM;
    }

    @CacheEvict(value={"qualificationsSM"}, allEntries=true)
    public void deleteByExample(QualificationsSMExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.qualificationsSMMapper.deleteByExample(example);
    }

    @CacheEvict(value={"qualificationsSM"}, allEntries=true)
    @Transactional
    public void addAll(List<QualificationsSM> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.qualificationsSMMapper.insertSelective((QualificationsSM)record));
    }
}

