/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.result.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.process.vo.CompanyProcessVO;
import com.els.base.certification.result.entity.CompanyResultNotice;
import com.els.base.certification.result.entity.CompanyResultNoticeExample;
import com.els.base.certification.result.service.CompanyResultNoticeService;
import com.els.base.certification.result.util.ResultNoticeEnum;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355"})
@Controller
@RequestMapping(value={"companyResultNotice"})
public class CompanyResultNoticeController {
    @Resource
    private CompanyResultNoticeService companyResultNoticeService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyResultNotice companyResultNotice) {
        Assert.isNotBlank((String)companyResultNotice.getSupCompanySrmCode(), (String)"\u4f9b\u5e94\u5546SRM\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.companyResultNoticeService.insert(CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), companyResultNotice);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165-\u6279\u91cf\u5220\u9664\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyResultNoticeService.deleteObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165-\u4f9b\u5e94\u5546\u6279\u91cf\u786e\u8ba4\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355")
    @RequestMapping(value={"service/confirmByIds"})
    @ResponseBody
    public ResponseResult<String> confirmByIds(@RequestBody(required=true) CompanyResultNotice data) {
        if (null == data) {
            throw new CommonException("\u786e\u8ba4\u5931\u8d25,\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyResultNoticeService.supConfirmBill(data);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u6279\u91cf\u901a\u8fc7\u5ba1\u6838\u73b0\u573a\u8003\u5bdf\u7ed3\u679c\u901a\u77e5\u5355\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/throughAudit"})
    @ResponseBody
    public ResponseResult<String> throughAudit(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyResultNoticeService.adopt(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u6279\u91cf\u6574\u6539\u73b0\u573a\u8003\u5bdf\u7ed3\u679c\u901a\u77e5\u5355\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/rectificationByIds"})
    @ResponseBody
    public ResponseResult<String> rectificationByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyResultNoticeService.rectification(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u51c6\u5165--\u6279\u91cf\u7ec8\u6b62\u5ba1\u6838\u73b0\u573a\u8003\u5bdf\u7ed3\u679c\u901a\u77e5\u5355\u7ed9\u4f9b\u5e94\u5546")
    @RequestMapping(value={"service/terminationAudit"})
    @ResponseBody
    public ResponseResult<String> terminationAudit(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u64cd\u4f5c\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyResultNoticeService.termination(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355(\u91c7\u8d2d\u65b9)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyResultNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyResultNotice>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyResultNoticeExample example = new CompanyResultNoticeExample();
        example.setPageView((PageView<CompanyResultNotice>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        CompanyResultNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyResultNoticeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u5ba1\u6838\u7ed3\u679c\u901a\u77e5\u5355(\u4f9b\u5e94\u5546)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyResultNotice", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<CompanyResultNotice>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyResultNoticeExample example = new CompanyResultNoticeExample();
        example.setPageView((PageView<CompanyResultNotice>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" CREATE_TIME DESC ");
        ArrayList<String> list = new ArrayList<String>();
        list.add(ResultNoticeEnum.RECTIFICATION.getCode());
        list.add(ResultNoticeEnum.TERMINATE_AUDIT.getCode());
        list.add(ResultNoticeEnum.THROUGH_AUDIT.getCode());
        CompanyResultNoticeExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andConfirmStatusIn(list).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyResultNoticeService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u4f9b\u5e94\u5546\u5ba1\u6838")
    @RequestMapping(value={"service/sendApproval"})
    @ResponseBody
    public ResponseResult<String> sendApproval(@RequestBody List<CompanyProcessVO> list) {
        Assert.isNotEmpty(list, (String)"\u53d1\u9001\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        this.companyResultNoticeService.sendToApprove(list);
        return ResponseResult.success();
    }
}

