/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.file.web.controller;

import com.els.base.certification.common.CompanyFinishFlag;
import com.els.base.certification.file.entity.CompanyFile;
import com.els.base.certification.file.entity.CompanyFileExample;
import com.els.base.certification.file.service.CompanyFileService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u4f9b\u5e94\u5546\u51c6\u5165-\u4f9b\u5e94\u5546\u9644\u4ef6\u4fe1\u606f")
@Controller
@RequestMapping(value={"companyFile"})
public class CompanyFileController {
    @Resource
    private CompanyFileService companyFileService;
    @Resource
    private CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u63d2\u5165\u4f9b\u5e94\u5546\u9644\u4ef6")
    @RequestMapping(value={"service/batchInsert"})
    @ResponseBody
    public ResponseResult<CompanyFinishFlag> batchInsert(@RequestBody List<CompanyFile> companyFileList, String companyId) {
        Company supCompany = null;
        supCompany = StringUtils.isNotBlank((String)companyId) ? (Company)this.companyService.queryObjById((Object)companyId) : CompanyUtils.currentCompany();
        Assert.isNotNull((Object)supCompany, (String)"\u4f9b\u5e94\u5546\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a");
        Integer fileStats = this.companyFileService.batchInsert(ProjectUtils.getProjectId(), supCompany, companyFileList);
        CompanyFinishFlag companyFinishFlag = new CompanyFinishFlag();
        companyFinishFlag.setEnclosureList(fileStats);
        return ResponseResult.success((Object)companyFinishFlag);
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u4f9b\u5e94\u5546\u9644\u4ef6\u4fe1\u606f")
    @RequestMapping(value={"service/deleteObjByIds"})
    @ResponseBody
    public ResponseResult<String> deleteObjByIds(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.companyFileService.deleteObjByIds(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u9644\u4ef6\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyFile", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyFile>> findByPage(@RequestParam(required=false) String supCompanySrmCode, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        CompanyFileExample example = new CompanyFileExample();
        example.setPageView((PageView<CompanyFile>)new PageView(pageNo, pageSize));
        CompanyFileExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            Company company = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (company == null) {
                throw new CommonException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyFileService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5168\u90e8\u4f9b\u5e94\u5546\u9644\u4ef6\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyFile", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<CompanyFile>> findAll(@RequestParam(required=false) String supCompanySrmCode, @RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        CompanyFileExample example = new CompanyFileExample();
        CompanyFileExample.Criteria criteria = example.createCriteria();
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            Company company = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (company == null) {
                throw new CommonException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        List companyFileList = this.companyFileService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)companyFileList);
    }
}

