/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.process.service.impl;

import com.els.base.certification.process.dao.ProcessMapper;
import com.els.base.certification.process.entity.Process;
import com.els.base.certification.process.entity.ProcessExample;
import com.els.base.certification.process.service.ProcessService;
import com.els.base.certification.process.util.AccessProcessEnum;
import com.els.base.certification.process.util.AuthenticationEnum;
import com.els.base.company.dao.CompanyPartnerMapper;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.SupplierStatusEnum;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.web.interceptor.ProjectInitInterceptor;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultProcessService")
public class ProcessServiceImpl
implements ProcessService {
    private Logger log = LoggerFactory.getLogger(ProjectInitInterceptor.class);
    @Resource
    protected ProcessMapper processMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    private CompanyPartnerMapper companyPartnerMapper;

    @CacheEvict(value={"process"}, allEntries=true)
    @Transactional
    public void addObj(Process t) {
        Assert.isNotBlank((String)t.getProcessId(), (String)"\u51c6\u5165\u6d41\u7a0bID\u4e0d\u80fd\u4e3a\u7a7a");
        t.setIsEnable(Constant.YES_INT);
        t.setIsSend(AuthenticationEnum.UNCERTIFIED.getCode());
        t.setCreateTime(new Date());
        t.setUpdateTime(new Date());
        Process process = this.queryObjByCompanyId(t.getCompanyId());
        if (null == process) {
            this.processMapper.insertSelective(t);
        } else {
            if (StringUtils.isNotBlank((String)process.getQualificationAudit()) || StringUtils.isNotBlank((String)process.getSceneInvestigate())) {
                throw new CommonException("\u8d44\u8d28\u5ba1\u6838\u6216\u73b0\u573a\u8003\u5bdf\u5df2\u5728\u8fdb\u884c\u4e2d\uff0c\u4e0d\u80fd\u518d\u4fee\u6539\u6d41\u7a0b");
            }
            if (AccessProcessEnum.NOT_REVIEW.getCode().equals(process.getAccessProcess()) && AuthenticationEnum.UNCERTIFIED.getCode() != process.getIsSend()) {
                throw new CommonException("\u4f9b\u5e94\u5546\u5df2\u5728\u8ba4\u8bc1\u4e2d\uff0c\u4e0d\u80fd\u4fee\u6539\u6d41\u7a0b");
            }
            this.deleteObjById(process.getId());
            this.processMapper.insertSelective(t);
        }
    }

    @CacheEvict(value={"process"}, allEntries=true)
    public void deleteObjById(String id) {
        this.processMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"process"}, allEntries=true)
    public void modifyObj(Process t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.processMapper.updateByPrimaryKeySelective(t);
    }

    @Override
    @CacheEvict(value={"process"}, allEntries=true)
    public void updateById(Process process) {
        if (StringUtils.isBlank((String)process.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.processMapper.updateByPrimaryKey(process);
    }

    @Cacheable(value={"process"}, keyGenerator="redisKeyGenerator")
    public Process queryObjById(String id) {
        return this.processMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"process"}, keyGenerator="redisKeyGenerator")
    public List<Process> queryAllObjByExample(ProcessExample example) {
        return this.processMapper.selectByExample(example);
    }

    @Cacheable(value={"process"}, keyGenerator="redisKeyGenerator")
    public PageView<Process> queryObjByPage(ProcessExample example) {
        PageView<Process> pageView = example.getPageView();
        pageView.setQueryResult(this.processMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"process"}, keyGenerator="redisKeyGenerator")
    public Process queryObjByCompanyId(String companyId) {
        Assert.isNotBlank((String)companyId, (String)"\u4f9b\u5e94\u5546\u7684ID\u4e0d\u80fd\u4e3a\u7a7a");
        ProcessExample example = new ProcessExample();
        example.createCriteria().andCompanyIdEqualTo(companyId);
        List<Process> list = this.processMapper.selectByExample(example);
        return CollectionUtils.isNotEmpty(list) ? list.get(0) : null;
    }

    @Override
    @Cacheable(value={"process"}, keyGenerator="redisKeyGenerator")
    public PageView<Company> queryAllCompnayByPage(CompanyExample example, String purCompanyId, String roleEnum, Map<String, Object> queryMap) {
        List<Company> list = this.processMapper.selectCompanyAndProcessInfoByPage(example, purCompanyId, roleEnum, queryMap);
        int count = this.processMapper.selectCompanyAndProcessInfoCount(purCompanyId, roleEnum, queryMap);
        PageView pageView = example.getPageView();
        pageView.setQueryResult(list);
        pageView.setRowCount(count);
        this.log.info(purCompanyId, (Object)list.toString());
        System.out.println(count);
        return pageView;
    }

    @Override
    public PageView<Company> queryCompanyByPage(CompanyExample companyExample, ProcessExample processExample, String purCompanyId, String partnerRoleCode) {
        PageView pageView = companyExample.getPageView();
        pageView.setQueryResult(this.processMapper.queryCompanyByPage(companyExample, processExample, purCompanyId, partnerRoleCode));
        return pageView;
    }

    @Override
    @CacheEvict(value={"process"}, allEntries=true)
    public int countByExample(ProcessExample example) {
        return this.processMapper.countByExample(example);
    }

    @CacheEvict(value={"process"}, allEntries=true)
    public void deleteByExample(ProcessExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.processMapper.deleteByExample(example);
    }

    @CacheEvict(value={"process"}, allEntries=true)
    @Transactional
    public void addAll(List<Process> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.processMapper.insertSelective((Process)record));
    }

    @Override
    @CacheEvict(value={"process"}, allEntries=true)
    @Transactional
    public void admit(Process process) {
        this.addObj(process);
        Company supCompany = (Company)this.companyService.queryObjById((Object)process.getCompanyId());
        this.companyService.updateSupplierStatus(supCompany, SupplierStatusEnum.ADMITTING);
    }
}

