/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.qualificationssm.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.certification.qualificationssm.entity.QualificationsSM;
import com.els.base.certification.qualificationssm.entity.QualificationsSMExample;
import com.els.base.certification.qualificationssm.entity.QualificationsSMFlieExample;
import com.els.base.certification.qualificationssm.service.QualificationsSMFlieService;
import com.els.base.certification.qualificationssm.service.QualificationsSMService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u8d44\u8d28\u5ba1\u6838\u4e0e\u73b0\u573a\u8003\u5bdf\u6a21\u7248\u8868"})
@Controller
@RequestMapping(value={"qualificationsSM"})
public class QualificationsSMController {
    @Resource
    protected QualificationsSMService qualificationsSMService;
    @Resource
    protected QualificationsSMFlieService qualificationsSMFlieService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8d44\u8d28\u5ba1\u6838\u4e0e\u73b0\u573a\u8003\u5bdf\u6a21\u7248\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody QualificationsSM qualificationsSM) {
        Assert.isNotNull((Object)qualificationsSM, (String)"\u4fdd\u5b58\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)qualificationsSM.getTemplatCode(), (String)"\u6a21\u7248\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)qualificationsSM.getSupplierLevel(), (String)"\u4f9b\u5e94\u5546\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(qualificationsSM.getQualificationsSMFlielist(), (String)"\u6a21\u7248\u9644\u4ef6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        qualificationsSM.getQualificationsSMFlielist().forEach(qualificationsSMFlie -> {
            if (StringUtils.isBlank((String)qualificationsSMFlie.getDocumentText()) || "[]".equals(qualificationsSMFlie.getDocumentText())) {
                throw new CommonException("\u6a21\u7248\u9644\u4ef6\u4fe1\u606f\u4e2d\u6709\u9644\u4ef6\u672a\u4e0a\u4f20\uff0c\u8bf7\u4e0a\u4f20\u540e\u518d\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\uff0c\u8c22\u8c22\uff01");
            }
        });
        User user = SpringSecurityUtils.getLoginUser();
        qualificationsSM.setEstablishName(user.getNickName());
        this.qualificationsSMService.addObj(qualificationsSM);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8d44\u8d28\u5ba1\u6838\u4e0e\u73b0\u573a\u8003\u5bdf\u6a21\u7248\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody QualificationsSM qualificationsSM) {
        Assert.isNotBlank((String)qualificationsSM.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        Assert.isNotBlank((String)qualificationsSM.getTemplatCode(), (String)"\u6a21\u7248\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)qualificationsSM.getSupplierLevel(), (String)"\u4f9b\u5e94\u5546\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(qualificationsSM.getQualificationsSMFlielist(), (String)"\u6a21\u7248\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        qualificationsSM.getQualificationsSMFlielist().forEach(qualificationsSMFlie -> {
            if (StringUtils.isBlank((String)qualificationsSMFlie.getDocumentText()) || "[]".equals(qualificationsSMFlie.getDocumentText())) {
                throw new CommonException("\u6a21\u7248\u9644\u4ef6\u4fe1\u606f\u4e2d\u6709\u9644\u4ef6\u672a\u4e0a\u4f20\uff0c\u8bf7\u4e0a\u4f20\u540e\u518d\u6267\u884c\u4fdd\u5b58\u64cd\u4f5c\uff0c\u8c22\u8c22\uff01");
            }
        });
        qualificationsSM.setUpdateTime(new Date());
        this.qualificationsSMService.modifyObj(qualificationsSM);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u5220\u9664\u8d44\u8d28\u5ba1\u6838\u4e0e\u73b0\u573a\u8003\u5bdf\u6a21\u7248\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25\uff0cID\u4e0d\u80fd\u4e3a\u7a7a");
        this.qualificationsSMService.deleteObjByIds(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8d44\u8d28\u5ba1\u6838\u4e0e\u73b0\u573a\u8003\u5bdf\u6a21\u7248\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 QualificationsSM", paramType="body", dataType="QueryParamWapper"), @ApiImplicitParam(name="templateCategory", value="\u8bc6\u522b\u6a21\u7248\u7c7b\u578b", paramType="query", dataType="String")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<QualificationsSM>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper, @RequestParam(value="templateCategory") String templateCategory) {
        PageView pageData;
        Assert.isNotBlank((String)templateCategory, (String)"\u6a21\u7248\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        QualificationsSMExample example = new QualificationsSMExample();
        example.setPageView((PageView<QualificationsSM>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        QualificationsSMExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(1);
        criteria.andTemplateCategoryEqualTo(templateCategory);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isNotEmpty((Collection)(pageData = this.qualificationsSMService.queryObjByPage((IExample)example)).getQueryResult())) {
            for (QualificationsSM qualificationsSM : pageData.getQueryResult()) {
                QualificationsSMFlieExample fileExample = new QualificationsSMFlieExample();
                fileExample.createCriteria().andTemplatIdEqualTo(qualificationsSM.getId()).andIsEnableEqualTo(Constant.YES_INT);
                List list = this.qualificationsSMFlieService.queryAllObjByExample((IExample)fileExample);
                qualificationsSM.setQualificationsSMFlielist(list);
            }
        }
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u5355\u6761\u6a21\u7248\u6570\u636e\u5bf9\u5e94\u7684\u9644\u4ef6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6a21\u7248\u6570\u636eid", paramType="query", dataType="String")})
    @RequestMapping(value={"service/selectListAll"})
    @ResponseBody
    public ResponseResult<QualificationsSM> selectListAll(String id) {
        Assert.isNotBlank((String)id, (String)"\u6a21\u7248\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        QualificationsSM data = this.qualificationsSMService.selectListAll(id);
        return ResponseResult.success((Object)data);
    }
}

