/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.business.web.controller;

import com.els.base.certification.business.entity.CompanyBusiness;
import com.els.base.certification.business.entity.CompanyBusinessExample;
import com.els.base.certification.business.service.CompanyBusinessService;
import com.els.base.certification.common.CompanyFinishFlag;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u4f9b\u5e94\u5546\u51c6\u5165-\u4e1a\u52a1\u60c5\u51b5"})
@Controller
@RequestMapping(value={"companyBusiness"})
public class CompanyBusinessController {
    @Resource
    protected CompanyBusinessService companyBusinessService;
    @Resource
    private CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u4e1a\u52a1\u60c5\u51b5")
    @RequestMapping(value={"service/batchInsert"})
    @ResponseBody
    public ResponseResult<Map<String, Integer>> batchInsert(@RequestBody List<CompanyBusiness> companyBusinessList) {
        CompanyFinishFlag companyFinishFlag = new CompanyFinishFlag();
        if (CollectionUtils.isEmpty(companyBusinessList)) {
            throw new CommonException("\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", "base_canot_be_null", new Object[]{"\u64cd\u4f5c\u5931\u8d25\uff0c\u6570\u636e"});
        }
        Integer businessstatus = this.companyBusinessService.batchInsert(ProjectUtils.getProjectId(), CompanyUtils.currentCompany(), companyBusinessList);
        companyFinishFlag.setBusiness(businessstatus);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("businessauth", businessstatus);
        return ResponseResult.success(map);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u51c6\u5165-\u4e1a\u52a1\u60c5\u51b5")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody CompanyBusiness companyBusiness) {
        this.companyBusinessService.addObj(companyBusiness);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u51c6\u5165-\u4e1a\u52a1\u60c5\u51b5")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody CompanyBusiness companyBusiness) {
        Assert.isNotBlank((String)companyBusiness.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.companyBusinessService.modifyObj(companyBusiness);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u51c6\u5165-\u4e1a\u52a1\u60c5\u51b5")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        CompanyBusinessExample example = new CompanyBusinessExample();
        example.createCriteria().andIdIn((List)ids);
        this.companyBusinessService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u4e1a\u52a1\u60c5\u51b5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyBusiness", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<CompanyBusiness>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CompanyBusinessExample example = new CompanyBusinessExample();
        example.setPageView((PageView<CompanyBusiness>)new PageView(pageNo, pageSize));
        CompanyBusinessExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.companyBusinessService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u51c6\u5165-\u4e1a\u52a1\u60c5\u51b5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyPatents", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findAll"})
    @ResponseBody
    public ResponseResult<List<CompanyBusiness>> findAll(@RequestParam(required=false) String supCompanySrmCode, @RequestBody(required=false) QueryParamWapper wapper) throws IOException {
        CompanyBusinessExample example = new CompanyBusinessExample();
        example.setOrderByClause("CREATE_TIME DESC");
        CompanyBusinessExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            Company company = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (company == null) {
                throw new CommonException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        }
        List companyBusinessList = this.companyBusinessService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)companyBusinessList);
    }
}

