/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.certificate.service.impl;

import com.els.base.certification.certificate.dao.CertificateExpiryMapper;
import com.els.base.certification.certificate.entity.CertificateExpiry;
import com.els.base.certification.certificate.entity.CertificateExpiryExample;
import com.els.base.certification.certificate.service.CertificateExpiryService;
import com.els.base.certification.common.CertificateTypeCodeEnum;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultCertificateExpiryService")
public class CertificateExpiryServiceImpl
implements CertificateExpiryService {
    @Resource
    protected CertificateExpiryMapper certificateExpiryMapper;

    @Override
    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    public void insert(Company purCompany, User loginUser, CertificateExpiry certificateExpiry) {
        Assert.isNotBlank((String)certificateExpiry.getClassificationCode(), (String)"\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)certificateExpiry.getClassificationName(), (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (Constant.YES_INT == certificateExpiry.getIsEnableReminders()) {
            Assert.isNotNull((Object)certificateExpiry.getAdvanceReminderDays(), (String)"\u63d0\u524d\u63d0\u9192\u5929\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CertificateExpiryExample example = new CertificateExpiryExample();
        example.createCriteria().andClassificationNameEqualTo(certificateExpiry.getClassificationName()).andIsEnableEqualTo(Constant.YES_INT);
        if (this.certificateExpiryMapper.countByExample(example) > 0) {
            throw new CommonException("\u5206\u7c7b\u540d\u79f0" + CertificateTypeCodeEnum.getDesc(certificateExpiry.getClassificationName()) + "\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u518d\u521b\u5efa");
        }
        example.clear();
        example.createCriteria().andClassificationCodeEqualTo(certificateExpiry.getClassificationCode()).andIsEnableEqualTo(Constant.YES_INT);
        if (this.certificateExpiryMapper.countByExample(example) > 0) {
            throw new CommonException("\u5206\u7c7b\u7f16\u7801" + certificateExpiry.getClassificationCode() + "\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u518d\u521b\u5efa");
        }
        this.setPurCompanyInfo(purCompany, loginUser, certificateExpiry);
        certificateExpiry.setCreateTime(new Date());
        this.certificateExpiryMapper.insertSelective(certificateExpiry);
    }

    private void setPurCompanyInfo(Company purCompany, User loginUser, CertificateExpiry certificateExpiry) {
        certificateExpiry.setPurCompanyId(purCompany.getId());
        certificateExpiry.setPurCompanyName(purCompany.getCompanyName());
        certificateExpiry.setPurCompanySrmCode(purCompany.getCompanyCode());
        certificateExpiry.setPurUserId(loginUser.getId());
        certificateExpiry.setFounder(loginUser.getNickName());
        certificateExpiry.setIsEnable(Constant.YES_INT);
    }

    @Override
    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    public void updateObj(Company purCompany, User loginUser, CertificateExpiry certificateExpiry) {
        CertificateExpiry certificate = this.queryObjById(certificateExpiry.getId());
        CertificateExpiryExample example = new CertificateExpiryExample();
        if (!certificate.getClassificationName().equals(certificateExpiry.getClassificationName())) {
            example.createCriteria().andClassificationNameEqualTo(certificateExpiry.getClassificationName()).andIsEnableEqualTo(Constant.YES_INT);
            if (this.certificateExpiryMapper.countByExample(example) > 0) {
                throw new CommonException("\u6b64\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u6539\u6210\uff1a" + certificateExpiry.getClassificationName());
            }
        }
        example.clear();
        if (!certificate.getClassificationCode().equals(certificateExpiry.getClassificationCode())) {
            example.createCriteria().andClassificationCodeEqualTo(certificateExpiry.getClassificationCode()).andIsEnableEqualTo(Constant.YES_INT);
            if (this.certificateExpiryMapper.countByExample(example) > 0) {
                throw new CommonException("\u5206\u7c7b\u7f16\u7801\uff1a" + certificateExpiry.getClassificationCode() + "\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u518d\u4f7f\u7528\u6b64\u7f16\u7801\u521b\u5efa\u5355\u636e");
            }
        }
        this.setPurCompanyInfo(purCompany, loginUser, certificateExpiry);
        certificateExpiry.setUpdateTime(new Date());
        this.certificateExpiryMapper.updateByPrimaryKeySelective(certificateExpiry);
    }

    @Override
    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    public void deleteObjByIds(List<String> ids) {
        CertificateExpiryExample example = new CertificateExpiryExample();
        example.createCriteria().andIdIn((List)ids).andIsEnableEqualTo(Constant.YES_INT);
        CertificateExpiry certificateExpiry = new CertificateExpiry();
        certificateExpiry.setIsEnable(Constant.NO_INT);
        this.certificateExpiryMapper.updateByExampleSelective(certificateExpiry, example);
    }

    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    public void addObj(CertificateExpiry t) {
        this.certificateExpiryMapper.insertSelective(t);
    }

    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    public void deleteObjById(String id) {
        this.certificateExpiryMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    public void modifyObj(CertificateExpiry t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.certificateExpiryMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"certificateExpiry"}, keyGenerator="redisKeyGenerator")
    public CertificateExpiry queryObjById(String id) {
        return this.certificateExpiryMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"certificateExpiry"}, keyGenerator="redisKeyGenerator")
    public List<CertificateExpiry> queryAllObjByExample(CertificateExpiryExample example) {
        return this.certificateExpiryMapper.selectByExample(example);
    }

    @Cacheable(value={"certificateExpiry"}, keyGenerator="redisKeyGenerator")
    public PageView<CertificateExpiry> queryObjByPage(CertificateExpiryExample example) {
        PageView<CertificateExpiry> pageView = example.getPageView();
        pageView.setQueryResult(this.certificateExpiryMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    public void deleteByExample(CertificateExpiryExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.certificateExpiryMapper.deleteByExample(example);
    }

    @CacheEvict(value={"certificateExpiry"}, allEntries=true)
    @Transactional
    public void addAll(List<CertificateExpiry> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.certificateExpiryMapper.insertSelective((CertificateExpiry)record));
    }
}

