/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.contacts.web.controller;

import com.els.base.certification.common.CompanyFinishFlag;
import com.els.base.certification.contacts.entity.Contacts;
import com.els.base.certification.contacts.entity.ContactsExample;
import com.els.base.certification.contacts.service.ContactsService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u8054\u7cfb\u4eba\u4fe1\u606f"})
@Controller
@RequestMapping(value={"contacts"})
public class ContactsController {
    @Resource
    protected ContactsService contactsService;
    @Resource
    private CompanyService companyService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u8054\u7cfb\u4eba\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<CompanyFinishFlag> create(@RequestParam(required=false) String supCompanySrmCode, @RequestBody List<Contacts> contacts) {
        Company supCompany = null;
        supCompany = StringUtils.isNotBlank((String)supCompanySrmCode) ? this.companyService.queryCompanyByCode(supCompanySrmCode) : CompanyUtils.currentCompany();
        Assert.isNotNull((Object)supCompany, (String)"\u4f9b\u5e94\u5546\u8d44\u6599\u4e0d\u80fd\u4e3a\u7a7a");
        CompanyFinishFlag companyFinishFlag = new CompanyFinishFlag();
        Integer contact = this.contactsService.addContacts(ProjectUtils.getProjectId(), supCompany.getId(), contacts);
        companyFinishFlag.setContactInfo(contact);
        return ResponseResult.success((Object)companyFinishFlag);
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u8054\u7cfb\u4eba\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<Contacts> contacts) {
        for (Contacts t : contacts) {
            if (StringUtils.isBlank((String)t.getId())) {
                throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fee\u6539\u5931\u8d25");
            }
            this.contactsService.modifyObj(t);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u8054\u7cfb\u4eba\u4fe1\u606f")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody(required=true) List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.contactsService.deleteObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u8054\u7cfb\u4eba\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Contacts", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Contacts>> findByPage(@RequestParam(required=false) String supCompanySrmCode, @RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ContactsExample example = new ContactsExample();
        example.setPageView((PageView<Contacts>)new PageView(pageNo, pageSize));
        example.setOrderByClause(" SORT_NO ASC ");
        ContactsExample contactsExample = new ContactsExample();
        ContactsExample.Criteria criteria = contactsExample.createCriteria();
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            Company company = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (company == null) {
                throw new CommonException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.contactsService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="supCompanySrmCode", required=false, value="\u4f9b\u5e94\u5546SRM\u7f16\u7801", paramType="query", dataType="String"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 CompanyPatents", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findContacts"})
    @ResponseBody
    public ResponseResult<List<Contacts>> findContacts(@RequestParam(required=false) String supCompanySrmCode, @RequestBody(required=false) QueryParamWapper wapper) {
        ContactsExample contactsExample = new ContactsExample();
        ContactsExample.Criteria criteria = contactsExample.createCriteria();
        contactsExample.setOrderByClause(" SORT_NO ASC ");
        if (StringUtils.isBlank((String)supCompanySrmCode)) {
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsEnableEqualTo(Constant.YES_INT);
        } else {
            Company company = this.companyService.queryCompanyByCode(supCompanySrmCode);
            if (company == null) {
                throw new CommonException("\u516c\u53f8\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5");
            }
            criteria.andProjectIdEqualTo(ProjectUtils.getProjectId()).andSupCompanyIdEqualTo(company.getId()).andIsEnableEqualTo(Constant.YES_INT);
        }
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        List contacts = this.contactsService.queryAllObjByExample((IExample)contactsExample);
        return ResponseResult.success((Object)contacts);
    }
}

