/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.qualification.service.impl;

import com.els.base.certification.qualification.dao.QualificationItemMapper;
import com.els.base.certification.qualification.entity.QualificationItem;
import com.els.base.certification.qualification.entity.QualificationItemExample;
import com.els.base.certification.qualification.service.QualificationItemService;
import com.els.base.core.entity.PageView;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultQualificationItemService")
public class QualificationItemServiceImpl
implements QualificationItemService {
    @Resource
    protected QualificationItemMapper qualificationItemMapper;

    @CacheEvict(value={"qualificationItem"}, allEntries=true)
    public void addObj(QualificationItem t) {
        this.qualificationItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"qualificationItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.qualificationItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"qualificationItem"}, allEntries=true)
    public void modifyObj(QualificationItem t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.qualificationItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"qualificationItem"}, keyGenerator="redisKeyGenerator")
    public QualificationItem queryObjById(String id) {
        return this.qualificationItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"qualificationItem"}, keyGenerator="redisKeyGenerator")
    public List<QualificationItem> queryAllObjByExample(QualificationItemExample example) {
        return this.qualificationItemMapper.selectByExample(example);
    }

    @Cacheable(value={"qualificationItem"}, keyGenerator="redisKeyGenerator")
    public PageView<QualificationItem> queryObjByPage(QualificationItemExample example) {
        PageView<QualificationItem> pageView = example.getPageView();
        pageView.setQueryResult(this.qualificationItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"qualificationItem"}, allEntries=true)
    public void deleteByExample(QualificationItemExample qualificationItemExample) {
        this.qualificationItemMapper.deleteByExample(qualificationItemExample);
    }

    @CacheEvict(value={"qualificationItem"}, allEntries=true)
    @Transactional
    public void addAll(List<QualificationItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.qualificationItemMapper.insertSelective((QualificationItem)record));
    }
}

