/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.certification.supplierchangesheet.web.controller;

import com.els.base.certification.supplierchangesheet.dao.SupplierChangeSheetMapper;
import com.els.base.certification.supplierchangesheet.entity.SupAuthentication;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheet;
import com.els.base.certification.supplierchangesheet.entity.SupplierChangeSheetExample;
import com.els.base.certification.supplierchangesheet.service.SupAuthenticationService;
import com.els.base.certification.supplierchangesheet.service.SupplierChangeSheetDETAILEService;
import com.els.base.certification.supplierchangesheet.service.SupplierChangeSheetService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599\u53d8\u66f4\u5355"})
@Controller
@RequestMapping(value={"supplierChangeSheet"})
public class SupplierChangeSheetController {
    @Resource
    protected SupplierChangeSheetService supplierChangeSheetService;
    @Resource
    protected SupplierChangeSheetMapper supplierChangeSheetMapper;
    @Resource
    protected SupplierChangeSheetDETAILEService SupplierChangeSheetDetaleService;
    @Resource
    protected SupAuthenticationService supAuthenticationService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u57fa\u7840\u8d44\u6599\u53d8\u66f4\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody SupplierChangeSheet supplierChangeSheet) {
        this.supplierChangeSheetService.addObj(supplierChangeSheet);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u8d44\u8d28\u8ba4\u8bc1\u53d8\u66f4\u5355")
    @RequestMapping(value={"service/addCertifications"})
    @ResponseBody
    public ResponseResult<String> addCertifications(@RequestBody List<SupAuthentication> list) {
        for (SupAuthentication item : list) {
            Assert.isNotBlank((String)item.getCertificateName(), (String)"\u8bc1\u4e66\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getCertificateBody(), (String)"\u8ba4\u8bc1\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getApplyScope(), (String)"\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)item.getEffectiveDate(), (String)"\u6709\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)item.getSignDate(), (String)"\u7b7e\u53d1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getCertificateBody(), (String)"\u8ba4\u8bc1\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.supplierChangeSheetService.addCertifications(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u4f9b\u5e94\u5546\u8d44\u8d28\u8ba4\u8bc1\u53d8\u66f4\u5355")
    @RequestMapping(value={"service/addCertification"})
    @ResponseBody
    public ResponseResult<String> addCertification(@RequestBody SupplierChangeSheet supplierChangeSheet) {
        List<SupAuthentication> list = supplierChangeSheet.getSupAuthenticationList();
        for (SupAuthentication item : list) {
            Assert.isNotBlank((String)item.getCertificateName(), (String)"\u8bc1\u4e66\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getCertificateBody(), (String)"\u8ba4\u8bc1\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getApplyScope(), (String)"\u9002\u7528\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)item.getEffectiveDate(), (String)"\u6709\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)item.getSignDate(), (String)"\u7b7e\u53d1\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)item.getCertificateBody(), (String)"\u8ba4\u8bc1\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.supplierChangeSheetService.addCertification(supplierChangeSheet);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u4f9b\u5e94\u5546\u53d8\u66f4\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody SupplierChangeSheet supplierChangeSheet) {
        Assert.isNotBlank((String)supplierChangeSheet.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.supplierChangeSheetService.modifyObj(supplierChangeSheet);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4f9b\u5e94\u5546\u53d8\u66f4\u5355")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank((String)id, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.supplierChangeSheetService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4f9b\u5e94\u5546\u53d8\u66f4\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupplierChangeSheet", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupplierChangeSheet>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SupplierChangeSheetExample example = new SupplierChangeSheetExample();
        example.setPageView((PageView<SupplierChangeSheet>)new PageView(pageNo, pageSize));
        SupplierChangeSheetExample.Criteria criteria = example.createCriteria();
        example.setOrderByClause("UPDATE_TIME DESC");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.supplierChangeSheetService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u81ea\u5df1\u53d8\u66f4\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupplierChangeSheet", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/queryByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupplierChangeSheet>> queryByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SupplierChangeSheetExample example = new SupplierChangeSheetExample();
        example.setPageView((PageView<SupplierChangeSheet>)new PageView(pageNo, pageSize));
        SupplierChangeSheetExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.supplierChangeSheetService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5355\u6311\u53d8\u66f4\u5355\u8be6\u7ec6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", required=false, value="id", paramType="query", dataType="String")})
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<SupplierChangeSheet> selectListAll(@RequestParam String id) {
        Assert.isNotBlank((String)id, (String)"\u6a21\u7248\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        SupplierChangeSheet supplierChangeSheet = (SupplierChangeSheet)this.supplierChangeSheetService.queryObjById(id);
        return ResponseResult.success((Object)supplierChangeSheet);
    }

    @ApiOperation(httpMethod="POST", value="\u9001\u5ba1")
    @RequestMapping(value={"service/approve"})
    @ResponseBody
    public ResponseResult<String> approve(@RequestParam String id) {
        Assert.isNotBlank((String)id, (String)"\u6a21\u7248\u6570\u636eid\u4e0d\u80fd\u4e3a\u7a7a");
        this.supplierChangeSheetService.approve(id);
        return ResponseResult.success();
    }
}

