/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.quartz.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.modules.quartz.entity.QuartzJob;
import com.els.modules.quartz.mapper.QuartzJobMapper;
import com.els.modules.quartz.service.IQuartzJobService;
import java.io.Serializable;
import java.util.List;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QuartzJobServiceImpl
extends ServiceImpl<QuartzJobMapper, QuartzJob>
implements IQuartzJobService {
    private static final Logger log = LoggerFactory.getLogger(QuartzJobServiceImpl.class);
    @Autowired
    private QuartzJobMapper quartzJobMapper;
    @Autowired
    private Scheduler scheduler;

    @Override
    public List<QuartzJob> findByJobClassName(String jobClassName) {
        return this.quartzJobMapper.findByJobClassName(jobClassName);
    }

    @Override
    public List<QuartzJob> findByJobNameKey(String jobNameKey) {
        return this.quartzJobMapper.findByJobNameKey(jobNameKey);
    }

    @Override
    public boolean saveAndScheduleJob(QuartzJob quartzJob) {
        if (CommonConstant.STATUS_NORMAL.equals(quartzJob.getStatus())) {
            this.schedulerAdd(quartzJob.getJobClassName().trim(), quartzJob.getJobNameKey().trim(), quartzJob.getCronExpression().trim(), quartzJob.getParameter());
        }
        quartzJob.setDeleted(CommonConstant.DEL_FLAG_0);
        return this.save(quartzJob);
    }

    @Override
    public boolean resumeJob(QuartzJob quartzJob) {
        this.schedulerDelete(quartzJob.getJobNameKey().trim());
        this.schedulerAdd(quartzJob.getJobClassName().trim(), quartzJob.getJobNameKey().trim(), quartzJob.getCronExpression().trim(), quartzJob.getParameter());
        quartzJob.setStatus(CommonConstant.STATUS_NORMAL);
        return this.updateById(quartzJob);
    }

    @Override
    public boolean editAndScheduleJob(QuartzJob quartzJob) throws SchedulerException {
        if (CommonConstant.STATUS_NORMAL.equals(quartzJob.getStatus())) {
            this.schedulerDelete(quartzJob.getJobNameKey().trim());
            this.schedulerAdd(quartzJob.getJobClassName().trim(), quartzJob.getJobNameKey().trim(), quartzJob.getCronExpression().trim(), quartzJob.getParameter());
        } else {
            this.scheduler.pauseJob(JobKey.jobKey((String)quartzJob.getJobNameKey().trim()));
        }
        return this.updateById(quartzJob);
    }

    @Override
    public boolean deleteAndStopJob(QuartzJob job) {
        if (StrUtil.isNotBlank((CharSequence)job.getJobNameKey())) {
            this.schedulerDelete(job.getJobNameKey().trim());
        }
        boolean ok = this.removeById((Serializable)((Object)job.getId()));
        return ok;
    }

    private void schedulerAdd(String jobClassName, String jobNameKey, String cronExpression, String parameter) {
        try {
            this.scheduler.start();
            JobDetail jobDetail = JobBuilder.newJob(QuartzJobServiceImpl.getClass(jobClassName).getClass()).withIdentity(jobNameKey).usingJobData("parameter", parameter).build();
            CronScheduleBuilder scheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpression);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(jobNameKey).withSchedule((ScheduleBuilder)scheduleBuilder).build();
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            throw new ELSBootException("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Throwable)e, new String[0]);
        }
        catch (RuntimeException e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        catch (Exception e) {
            throw new ELSBootException("\u540e\u53f0\u627e\u4e0d\u5230\u8be5\u7c7b\u540d\uff1a" + jobClassName, (Throwable)e, new String[0]);
        }
    }

    private void schedulerDelete(String jobNameKey) {
        try {
            this.scheduler.pauseTrigger(TriggerKey.triggerKey((String)jobNameKey));
            this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)jobNameKey));
            this.scheduler.deleteJob(JobKey.jobKey((String)jobNameKey));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ELSBootException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    private static Job getClass(String classname) throws Exception {
        Class<?> class1 = Class.forName(classname);
        return (Job)class1.newInstance();
    }
}

