/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.shiro.authc;

import com.alibaba.fastjson.JSONObject;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.shiro.authc.JwtToken;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.util.AdminFlagUtil;
import com.els.modules.system.util.PermissionDataUtil;
import com.els.modules.system.util.PermissionFlagUtil;
import java.util.Set;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ShiroRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(ShiroRealm.class);
    @Autowired
    @Lazy
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    @Lazy
    private PermissionService permissionService;
    @Autowired
    @Lazy
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    @Lazy
    private RedisUtil redisUtil;

    public boolean supports(AuthenticationToken token) {
        return token instanceof JwtToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String flag;
        JSONObject companySet;
        log.info("===============Shiro\u6743\u9650\u8ba4\u8bc1\u5f00\u59cb============ [ roles\u3001permissions]==========");
        String elsAccount = null;
        String subAccount = null;
        if (principals != null) {
            LoginUser sysUser = (LoginUser)principals.getPrimaryPrincipal();
            elsAccount = sysUser.getElsAccount();
            subAccount = sysUser.getSubAccount();
        }
        SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
        Set<String> roleSet = this.elsSubAccountService.getUserRolesSet(elsAccount, subAccount);
        info.setRoles(roleSet);
        boolean optFlag = false;
        LoginUser user = SysUtil.getLoginUser();
        if (user != null && (companySet = user.getCompanySet()) != null && "1".equals(flag = companySet.getString("permissionOpt"))) {
            optFlag = true;
        }
        Set<String> permissionSet = null;
        String adminFlag = AdminFlagUtil.getAdminFlag();
        permissionSet = optFlag && !"1".equals(adminFlag) ? this.elsSubAccountService.getUserPermissionsSet(elsAccount + "_" + subAccount) : this.permissionService.getAllOptPermission();
        info.addStringPermissions(permissionSet);
        log.info("===============Shiro\u6743\u9650\u8ba4\u8bc1\u6210\u529f==============");
        return info;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken auth) throws AuthenticationException {
        String token = (String)auth.getCredentials();
        if (token == null) {
            log.info("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u8eab\u4efd\u8ba4\u8bc1\u5931\u8d25\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014IP\u5730\u5740:  " + ConvertUtils.getIpAddrByRequest(SpringContextUtils.getHttpServletRequest()));
            throw new AuthenticationException("token\u4e3a\u7a7a!");
        }
        LoginUser loginUser = this.checkUserTokenIsEffect(token);
        return new SimpleAuthenticationInfo((Object)loginUser, (Object)token, this.getName());
    }

    public LoginUser checkUserTokenIsEffect(String token) throws AuthenticationException {
        String account = JwtUtil.getAccount(token);
        if (account == null) {
            throw new AuthenticationException("token\u975e\u6cd5\u65e0\u6548!");
        }
        log.info("\u2014\u2014\u2014\u6821\u9a8ctoken\u662f\u5426\u6709\u6548\u2014\u2014\u2014\u2014checkUserTokenIsEffect\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + token);
        LoginUser loginUser = this.sysBaseAPI.getUserByAccount(account);
        if (loginUser == null) {
            throw new AuthenticationException("\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        if (loginUser.getStatus() != 1) {
            throw new AuthenticationException("\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        if (!this.jwtTokenRefresh(token, account, loginUser.getPassword())) {
            log.info("\u2014\u2014\u2014Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + token);
            throw new AuthenticationException("Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!");
        }
        String adminFlag = (String)this.redisUtil.get("sys:token:role:" + token);
        AdminFlagUtil.setAdminFlag(adminFlag);
        PermissionFlagUtil.clear();
        PermissionDataUtil.clear();
        return loginUser;
    }

    public boolean jwtTokenRefresh(String token, String account, String passWord) {
        String cacheToken = String.valueOf(this.redisUtil.get("sys:token:" + token));
        if (ConvertUtils.isNotEmpty(cacheToken)) {
            if (!JwtUtil.verify(cacheToken, account, passWord)) {
                String newAuthorization = JwtUtil.sign(account, passWord);
                this.redisUtil.set("sys:token:" + token, newAuthorization);
                this.redisUtil.expire("sys:token:" + token, 3600L);
                log.info("\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u7528\u6237\u5728\u7ebf\u64cd\u4f5c\uff0c\u66f4\u65b0token\u4fdd\u8bc1\u4e0d\u6389\u7ebf\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014jwtTokenRefresh\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + token);
            }
            String elsAccount = account.split("_")[0];
            TenantContext.setTenant(elsAccount);
            return true;
        }
        if (JwtUtil.verify(token, account, passWord)) {
            String elsAccount = account.split("_")[0];
            TenantContext.setTenant(elsAccount);
            return true;
        }
        return false;
    }

    public void clearCache(PrincipalCollection principals) {
        super.clearCache(principals);
    }
}

