/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.service.ElsMsgConfigItemService;
import com.els.modules.message.service.MsgService;
import com.els.modules.message.vo.MsgParamsVO;
import com.els.modules.system.entity.ElsAlertConfig;
import com.els.modules.system.entity.ElsAlertRecord;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.UserRole;
import com.els.modules.system.enums.AlertFrequencyEnum;
import com.els.modules.system.service.AlertService;
import com.els.modules.system.service.ElsAlertRecordService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.UserRoleService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public abstract class AbstractAlertServiceImpl
implements AlertService {
    @Autowired
    private MsgService msgService;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private ElsAlertRecordService elsAlertRecordService;
    @Autowired
    private ElsMsgConfigItemService elsMsgConfigItemService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void runAlert(ElsAlertConfig alertConfig) {
        List alertList = this.getAlertList(alertConfig);
        for (Object obj : alertList) {
            boolean exeFlag = this.getExeFlag(alertConfig, obj);
            if (!exeFlag) continue;
            this.addAlertRecord(alertConfig, obj);
            List<ElsMsgConfigItem> itemList = this.elsMsgConfigItemService.selectByMainId(alertConfig.getId());
            if (itemList.isEmpty()) continue;
            MsgParamsVO paramsVO = new MsgParamsVO();
            List<ElsSubAccount> accountList = this.getReceiverAccountList(alertConfig, obj);
            Map<String, List<ElsSubAccount>> map = accountList.stream().collect(Collectors.groupingBy(BaseEntity::getElsAccount));
            paramsVO.setReceiverMap(map);
            paramsVO.setParams(obj);
            this.msgService.sendMsg(itemList, "alert", "notice", paramsVO);
        }
    }

    private void addAlertRecord(ElsAlertConfig alertConfig, Object obj) {
        ElsAlertRecord record = new ElsAlertRecord();
        record.setElsAccount(alertConfig.getElsAccount());
        record.setAlertCofigId(alertConfig.getId());
        record.setBusinessId((String)BeanUtil.getProperty((Object)obj, (String)"id"));
        record.setAlertTime(new Date());
        this.elsAlertRecordService.save(record);
    }

    private boolean getExeFlag(ElsAlertConfig alertConfig, Object obj) {
        String id = (String)BeanUtil.getProperty((Object)obj, (String)"id");
        List recordList = this.elsAlertRecordService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)alertConfig.getElsAccount())).eq((Object)"alert_cofig_id", (Object)alertConfig.getId())).eq((Object)"business_id", (Object)id)).orderByDesc((Object)"alert_time"));
        if (recordList.isEmpty()) {
            return true;
        }
        String alertFrequency = alertConfig.getAlertFrequency();
        if (AlertFrequencyEnum.ONCE.getCode().equals(alertFrequency)) {
            return false;
        }
        if (AlertFrequencyEnum.DAY.getCode().equals(alertFrequency)) {
            return true;
        }
        if (AlertFrequencyEnum.WEEK.getCode().equals(alertFrequency)) {
            return this.compare((ElsAlertRecord)recordList.get(0), 7);
        }
        if (AlertFrequencyEnum.MONTH.getCode().equals(alertFrequency)) {
            return this.compare((ElsAlertRecord)recordList.get(0), 30);
        }
        return false;
    }

    private boolean compare(ElsAlertRecord record, int days) {
        String date2;
        Date alertTime = record.getAlertTime();
        DateTime checkDate = DateUtil.offsetDay((Date)alertTime, (int)days);
        String date1 = DateUtil.formatDate((Date)checkDate);
        return date1.compareTo(date2 = DateUtil.formatDate((Date)new Date())) <= 0;
    }

    protected List<ElsSubAccount> getReceiverAccountList(ElsAlertConfig alertConfig, Object obj) {
        ArrayList<ElsSubAccount> list = new ArrayList<ElsSubAccount>();
        if (StrUtil.isNotBlank((CharSequence)alertConfig.getNoticeUser())) {
            String[] userIds;
            for (String userId : userIds = alertConfig.getNoticeUser().split(",")) {
                this.addSubAccount(list, userId);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)alertConfig.getNoticeRole())) {
            String[] roles;
            for (String roleId : roles = alertConfig.getNoticeRole().split(",")) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"role_id", (Object)roleId);
                List roleList = this.userRoleService.list((Wrapper)queryWrapper);
                for (UserRole role : roleList) {
                    this.addSubAccount(list, role.getUserId());
                }
            }
        }
        list.addAll(this.getPrincipalList(obj, alertConfig));
        List distinctList = list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ElsSubAccount>(Comparator.comparing(BaseEntity::getId))), ArrayList::new));
        return distinctList;
    }

    private void addSubAccount(List<ElsSubAccount> list, String userId) {
        ElsSubAccount account = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)userId));
        if (account != null) {
            list.add(account);
        }
    }

    protected abstract List<ElsSubAccount> getPrincipalList(Object var1, ElsAlertConfig var2);

    protected abstract List getAlertList(ElsAlertConfig var1);
}

