/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.vo.ComboModel;
import com.els.common.system.vo.DictModel;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.IPUtils;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.Log;
import com.els.modules.system.entity.Role;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.mapper.LogMapper;
import com.els.modules.system.mapper.RoleMapper;
import com.els.modules.system.mapper.UserRoleMapper;
import com.els.modules.system.service.DictService;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.vo.ElsCompanySetVO;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BaseApiImpl
implements ISysBaseAPI {
    private static final Logger log = LoggerFactory.getLogger(BaseApiImpl.class);
    private static String DB_TYPE = "";
    @Resource
    private LogMapper sysLogMapper;
    @Resource
    private ElsSubAccountMapper userMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Autowired
    private DictService dictService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private RoleMapper roleMapper;
    @Autowired
    private ElsCompanySetService elsCompanySetService;

    @Override
    public void addLog(String LogContent, Integer logType, Integer operatetype) {
        Log sysLog = new Log();
        sysLog.setLogContent(LogContent);
        sysLog.setLogType(logType);
        sysLog.setOperateType(operatetype);
        try {
            HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
            sysLog.setIp(IPUtils.getIpAddr(request));
        }
        catch (Exception e) {
            sysLog.setIp("127.0.0.1");
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (sysUser != null) {
            sysLog.setUserid(sysUser.getSubAccount());
            sysLog.setUsername(sysUser.getRealname());
        }
        sysLog.setCreateTime(new Date());
        sysLog.setElsAccount(TenantContext.getTenant());
        this.sysLogMapper.insert(sysLog);
    }

    @Override
    public LoginUser getUserByAccount(String account) {
        if (ConvertUtils.isEmpty(account)) {
            return null;
        }
        String redisKey = String.format("%s::%s", "sys:cache:user", account);
        LoginUser user = (LoginUser)this.redisUtil.get(redisKey);
        if (user != null) {
            return user;
        }
        LoginUser loginUser = new LoginUser();
        ElsSubAccount sysUser = this.userMapper.getUserByAccount(account);
        if (sysUser == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)sysUser, (Object)loginUser);
        try {
            Map<String, String> map = this.userMapper.getLogoSetByElsAccount(account.split("_")[0]);
            loginUser.setAliasName(map.get("alias"));
            loginUser.setEnterpriseName(map.get("name"));
            loginUser.setEnterpriseLogo(map.get("default_value") != null && "1".equals(map.get("default_value")) && map.get("enterprise_logo") != null ? map.get("enterprise_logo") : "");
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        try {
            List<ElsCompanySetVO> companySetList = this.elsCompanySetService.findList(account.split("_")[0]);
            JSONObject result = new JSONObject();
            for (ElsCompanySetVO vo : companySetList) {
                result.put(vo.getItemCode(), (Object)vo.getDefaultValue());
            }
            loginUser.setCompanySet(result);
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        this.redisUtil.set(redisKey, loginUser, 1800L);
        return loginUser;
    }

    @Override
    public LoginUser getUserById(String id) {
        if (ConvertUtils.isEmpty(id)) {
            return null;
        }
        LoginUser loginUser = new LoginUser();
        ElsSubAccount sysUser = (ElsSubAccount)this.userMapper.selectById((Serializable)((Object)id));
        if (sysUser == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)sysUser, (Object)loginUser);
        return loginUser;
    }

    @Override
    public List<String> getRolesByUsername(String elsAccount, String subAccount) {
        return this.userRoleMapper.getRoleByUserName(elsAccount, subAccount);
    }

    @Override
    public String getDatabaseType() {
        DataSource dataSource = (DataSource)SpringContextUtils.getApplicationContext().getBean(DataSource.class);
        return this.getDatabaseTypeByDataSource(dataSource);
    }

    @Override
    public List<DictModel> queryDictItemsByCode(String code) {
        return this.dictService.queryDictItemsByCode(code, TenantContext.getTenant());
    }

    @Override
    public List<DictModel> queryTableDictItemsByCode(String table, String text, String code) throws Exception {
        return this.dictService.queryTableDictItemsByCode(table, text, code);
    }

    @Override
    public List<DictModel> queryAllDepartBackDictModel() {
        return this.dictService.queryAllDepartBackDictModel();
    }

    private String getDatabaseTypeByDataSource(DataSource dataSource) {
        block19: {
            if ("".equals(DB_TYPE)) {
                try (Connection connection = dataSource.getConnection();){
                    DatabaseMetaData md = connection.getMetaData();
                    String dbType = md.getDatabaseProductName().toLowerCase();
                    if (dbType.contains("mysql")) {
                        DB_TYPE = "MYSQL";
                        break block19;
                    }
                    if (dbType.contains("oracle")) {
                        DB_TYPE = "ORACLE";
                        break block19;
                    }
                    if (dbType.contains("sqlserver") || dbType.contains("sql server")) {
                        DB_TYPE = "SQLSERVER";
                        break block19;
                    }
                    if (dbType.contains("postgresql")) {
                        DB_TYPE = "POSTGRESQL";
                        break block19;
                    }
                    throw new ELSBootException("\u6570\u636e\u5e93\u7c7b\u578b:[" + dbType + "]\u4e0d\u8bc6\u522b!");
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return DB_TYPE;
    }

    @Override
    public List<DictModel> queryAllDict() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"create_time");
        List dicts = this.dictService.list((Wrapper)queryWrapper);
        ArrayList<DictModel> list = new ArrayList<DictModel>();
        for (Dict dict : dicts) {
            list.add(new DictModel(dict.getDictCode(), dict.getDictName()));
        }
        return list;
    }

    @Override
    public List<DictModel> queryFilterTableDictInfo(String table, String text, String code, String filterSql) {
        return this.dictService.queryTableDictItemsByCodeAndFilter(table, text, code, filterSql, TenantContext.getTenant());
    }

    @Override
    public List<ComboModel> queryAllUser() {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List userList = this.userMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)"1")).eq((Object)"is_deleted", (Object)"0"));
        for (ElsSubAccount user : userList) {
            ComboModel model = new ComboModel();
            model.setTitle(user.getRealname());
            model.setId(user.getId());
            list.add(model);
        }
        return list;
    }

    @Override
    public List<ComboModel> queryAllUser(String[] userIds) {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List userList = this.userMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)"1")).eq((Object)"is_deleted", (Object)"0"));
        for (ElsSubAccount user : userList) {
            ComboModel model = new ComboModel();
            model.setUsername(user.getSubAccount());
            model.setTitle(user.getRealname());
            model.setId(user.getId());
            if (ConvertUtils.isNotEmpty(userIds)) {
                for (String userId : userIds) {
                    if (!userId.equals(user.getId())) continue;
                    model.setChecked(true);
                }
            }
            list.add(model);
        }
        return list;
    }

    @Override
    public List<ComboModel> queryAllRole() {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List roleList = this.roleMapper.selectList((Wrapper)new QueryWrapper());
        for (Role role : roleList) {
            ComboModel model = new ComboModel();
            model.setTitle(role.getRoleName());
            model.setId(role.getId());
            list.add(model);
        }
        return list;
    }

    @Override
    public List<ComboModel> queryAllRole(String[] roleIds) {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List roleList = this.roleMapper.selectList((Wrapper)new QueryWrapper());
        for (Role role : roleList) {
            ComboModel model = new ComboModel();
            model.setTitle(role.getRoleName());
            model.setId(role.getId());
            if (ConvertUtils.isNotEmpty(roleIds)) {
                for (String roleId : roleIds) {
                    if (!roleId.equals(role.getId())) continue;
                    model.setChecked(true);
                }
            }
            list.add(model);
        }
        return list;
    }

    @Override
    public List<String> getRoleIdsByUsername(String elsAccount, String subAccount) {
        return this.userRoleMapper.getRoleIdByUserName(elsAccount, subAccount);
    }
}

