/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.poi.util;

import com.els.framework.poi.excel.entity.params.MergeEntity;
import com.els.framework.poi.exception.excel.ExcelExportException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public final class PoiMergeCellUtil {
    public static void mergeCells(Sheet sheet, int startRow, Integer[] columns) {
        if (columns == null) {
            throw new ExcelExportException("\u81f3\u5c11\u9700\u8981\u5904\u74061\u5217");
        }
        HashMap<Integer, int[]> mergeMap = new HashMap<Integer, int[]>();
        for (int i = 0; i < columns.length; ++i) {
            mergeMap.put(columns[i], null);
        }
        PoiMergeCellUtil.mergeCells(sheet, mergeMap, startRow, sheet.getLastRowNum());
    }

    public static void mergeCells(Sheet sheet, Map<Integer, int[]> mergeMap, int startRow) {
        PoiMergeCellUtil.mergeCells(sheet, mergeMap, startRow, sheet.getLastRowNum());
    }

    public static void mergeCells(Sheet sheet, Map<Integer, int[]> mergeMap, int startRow, int endRow) {
        HashMap<Integer, MergeEntity> mergeDataMap = new HashMap<Integer, MergeEntity>();
        if (mergeMap.size() == 0) {
            return;
        }
        Set<Integer> sets = mergeMap.keySet();
        for (int i = startRow; i <= endRow; ++i) {
            Row row = sheet.getRow(i);
            for (Integer index : sets) {
                if (row == null || row.getCell(index.intValue()) == null) {
                    if (mergeDataMap.get(index) == null || ((MergeEntity)mergeDataMap.get(index)).getEndRow() != 0) continue;
                    ((MergeEntity)mergeDataMap.get(index)).setEndRow(i - 1);
                    continue;
                }
                String text = row.getCell(index.intValue()).getStringCellValue();
                if (StringUtils.isNotEmpty((String)text)) {
                    PoiMergeCellUtil.hanlderMergeCells(index, i, text, mergeDataMap, sheet, row.getCell(index.intValue()), mergeMap.get(index));
                    continue;
                }
                PoiMergeCellUtil.mergeCellOrContinue(index, mergeDataMap, sheet);
            }
        }
        if (mergeDataMap.size() > 0) {
            for (Integer index : mergeDataMap.keySet()) {
                sheet.addMergedRegion(new CellRangeAddress(((MergeEntity)mergeDataMap.get(index)).getStartRow(), ((MergeEntity)mergeDataMap.get(index)).getEndRow(), index.intValue(), index.intValue()));
            }
        }
    }

    private static void hanlderMergeCells(Integer index, int rowNum, String text, Map<Integer, MergeEntity> mergeDataMap, Sheet sheet, Cell cell, int[] delys) {
        if (mergeDataMap.containsKey(index)) {
            if (PoiMergeCellUtil.checkIsEqualByCellContents(mergeDataMap.get(index), text, cell, delys, rowNum)) {
                mergeDataMap.get(index).setEndRow(rowNum);
            } else {
                sheet.addMergedRegion(new CellRangeAddress(mergeDataMap.get(index).getStartRow(), mergeDataMap.get(index).getEndRow(), index.intValue(), index.intValue()));
                mergeDataMap.put(index, PoiMergeCellUtil.createMergeEntity(text, rowNum, cell, delys));
            }
        } else {
            mergeDataMap.put(index, PoiMergeCellUtil.createMergeEntity(text, rowNum, cell, delys));
        }
    }

    private static void mergeCellOrContinue(Integer index, Map<Integer, MergeEntity> mergeDataMap, Sheet sheet) {
        if (mergeDataMap.containsKey(index) && mergeDataMap.get(index).getEndRow() != mergeDataMap.get(index).getStartRow()) {
            sheet.addMergedRegion(new CellRangeAddress(mergeDataMap.get(index).getStartRow(), mergeDataMap.get(index).getEndRow(), index.intValue(), index.intValue()));
            mergeDataMap.remove(index);
        }
    }

    private static MergeEntity createMergeEntity(String text, int rowNum, Cell cell, int[] delys) {
        MergeEntity mergeEntity = new MergeEntity(text, rowNum, rowNum);
        if (delys != null && delys.length != 0) {
            ArrayList<String> list = new ArrayList<String>(delys.length);
            mergeEntity.setRelyList(list);
            for (int i = 0; i < delys.length; ++i) {
                list.add(PoiMergeCellUtil.getCellNotNullText(cell, delys[i], rowNum));
            }
        }
        return mergeEntity;
    }

    private static boolean checkIsEqualByCellContents(MergeEntity mergeEntity, String text, Cell cell, int[] delys, int rowNum) {
        if (delys == null || delys.length == 0) {
            return mergeEntity.getText().equals(text);
        }
        if (mergeEntity.getText().equals(text)) {
            for (int i = 0; i < delys.length; ++i) {
                if (PoiMergeCellUtil.getCellNotNullText(cell, delys[i], rowNum).equals(mergeEntity.getRelyList().get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getCellNotNullText(Cell cell, int index, int rowNum) {
        String temp = cell.getRow().getCell(index).getStringCellValue();
        while (StringUtils.isEmpty((String)temp)) {
            temp = cell.getRow().getSheet().getRow(--rowNum).getCell(index).getStringCellValue();
        }
        return temp;
    }
}

