/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.api.impl;

import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integration.service.OpenApiService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SsoTokenServiceImpl
implements OpenApiService {
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    @Transactional(rollbackOn={RuntimeException.class})
    public JSONObject invoke(JSONObject param) {
        String subAccount;
        String elsAccount = TenantContext.getTenant();
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount = param.getString("subAccount"));
        if (elsSubAccount == null) {
            throw new ELSBootException("subAccount \u4e0d\u5b58\u5728\uff01");
        }
        JSONObject result = new JSONObject();
        result.put("token", (Object)this.saveToken(elsSubAccount));
        return result;
    }

    private String saveToken(ElsSubAccount account) {
        String token = JwtUtil.sign(account.getElsAccount() + "_" + account.getSubAccount(), account.getPassword());
        this.redisUtil.set("sys:token:" + token, token);
        this.redisUtil.expire("sys:token:" + token, 1800L);
        return token;
    }
}

