/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.exceptions.ClientException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.exception.ELSBootException;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.DySmsEnum;
import com.els.common.util.DySmsHelper;
import com.els.common.util.MD5Util;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.encryption.EncryptedString;
import com.els.config.SmsConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.shiro.authc.JwtToken;
import com.els.modules.shiro.contants.DefContants;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.model.LoginModel;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.LogService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.vo.ElsCompanySetVO;
import com.els.modules.system.vo.ElsSubAccountVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u7528\u6237\u767b\u5f55"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private ISysBaseAPI sysBaseAPI;
    @Autowired
    private LogService logService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ElsTenantService elsTenantService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Autowired
    private ElsCompanySetService elsCompanySetService;
    @Autowired(required=false)
    private SmsConfig smsConfig;
    private static final String BASE_CHECK_CODES = "azxctyuipqwergfdsvbnlkjhmTQURGZXHFDSAWEPMLKCVBJYN1234567890";

    @ApiOperation(value="\u767b\u5f55\u63a5\u53e3")
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public Result<JSONObject> login(@RequestBody LoginModel sysLoginModel) {
        Result<JSONObject> result = new Result();
        sysLoginModel.setElsAccount(sysLoginModel.getElsAccount().trim());
        TenantContext.setTenant(sysLoginModel.getElsAccount());
        result = this.checkUser(sysLoginModel);
        this.sysBaseAPI.addLog("\u8d26\u53f7: " + sysLoginModel.getElsAccount() + "_" + sysLoginModel.getSubAccount() + ",\u767b\u5f55\u6210\u529f\uff01", 1, null);
        return result;
    }

    @AutoLog(value="\u901a\u8fc7token\u767b\u5f55", logType=1)
    @RequestMapping(value={"/loginByToken"}, method={RequestMethod.GET})
    public Result<?> loginByToken(@RequestParam(name="token", required=true) String token) {
        String account = JwtUtil.getAccount(token);
        if (StrUtil.isBlank((CharSequence)account)) {
            throw new ELSBootException("token \u683c\u5f0f\u9519\u8bef\uff01");
        }
        TenantContext.setTenant(account.split("_")[0]);
        ElsSubAccount subAccount = this.elsSubAccountService.getUserByAccount(account);
        if (!JwtUtil.verify(token, account, subAccount.getPassword())) {
            throw new ELSBootException("token \u5df2\u5931\u6548\uff01");
        }
        Result<JSONObject> result = new Result<JSONObject>();
        if (!"100000".equals(subAccount.getElsAccount()) && !(result = this.elsTenantService.checkTenantIsEffective(subAccount.getElsAccount())).isSuccess()) {
            return result;
        }
        this.userInfo(subAccount, result);
        return result;
    }

    @ApiOperation(value="\u79fb\u52a8\u7aef\u767b\u5f55\u63a5\u53e3")
    @RequestMapping(value={"/loginForMobile"}, method={RequestMethod.POST})
    public Result<JSONObject> loginForMobile(@RequestBody LoginModel sysLoginModel) {
        Result<JSONObject> result = this.checkUser(sysLoginModel);
        this.sysBaseAPI.addLog("\u7528\u6237\u540d: " + sysLoginModel.getSubAccount() + ",\u79fb\u52a8\u7aef\u767b\u5f55\u6210\u529f\uff01", 1, null);
        return result;
    }

    private Result<JSONObject> checkUser(LoginModel sysLoginModel) {
        Result<Object> result = new Result();
        String elsAccount = sysLoginModel.getElsAccount();
        String subAccount = sysLoginModel.getSubAccount();
        String password = sysLoginModel.getPassword();
        if (!"100000".equals(elsAccount) && !(result = this.elsTenantService.checkTenantIsEffective(elsAccount)).isSuccess()) {
            throw new ELSBootException(result.getMessage());
        }
        ElsSubAccount sysUser = this.elsSubAccountService.getUserBySubAccount(subAccount);
        result = this.elsSubAccountService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            throw new ELSBootException(result.getMessage());
        }
        String userpassword = PasswordUtil.encrypt(elsAccount + "_" + subAccount, password, sysUser.getSalt());
        String syspassword = sysUser.getPassword();
        if (!syspassword.equals(userpassword)) {
            throw new ELSBootException("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        if (null != sysUser.getAccountValidityDate()) {
            Date accountValidityDate = sysUser.getAccountValidityDate();
            Date timeDate = new Date();
            if (timeDate.getTime() > accountValidityDate.getTime()) {
                throw new ELSBootException("\u60a8\u7684\u8d26\u6237\u5df2\u8fc7\u6709\u6548\u671f\u9650\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
        }
        this.userInfo(sysUser, result);
        if (StrUtil.isNotBlank((CharSequence)sysLoginModel.getThirdUserUuid())) {
            this.bindUserId(sysUser.getId(), elsAccount, sysLoginModel.getThirdUserUuid());
        }
        return result;
    }

    private void bindUserId(String userId, String elsAccount, String thirdUserUuid) {
        List thirdAccountList = this.thirdAccountService.list((Wrapper)new QueryWrapper().eq((Object)"third_user_uuid", (Object)thirdUserUuid));
        if (!thirdAccountList.isEmpty()) {
            ThirdAccount thirdAccount = (ThirdAccount)thirdAccountList.get(0);
            thirdAccount.setUserId(userId);
            thirdAccount.setElsAccount(elsAccount);
            this.thirdAccountService.updateById(thirdAccount);
        }
    }

    @RequestMapping(value={"/logout"}, method={RequestMethod.POST})
    public Result<Object> logout(HttpServletRequest request, HttpServletResponse response) {
        String token = request.getHeader(DefContants.X_ACCESS_TOKEN);
        if (ConvertUtils.isEmpty(token)) {
            return Result.ok("\u9000\u51fa\u767b\u5f55\u6210\u529f\uff01");
        }
        String account = JwtUtil.getAccount(token);
        LoginUser sysUser = this.sysBaseAPI.getUserByAccount(account);
        if (sysUser != null) {
            this.sysBaseAPI.addLog("\u8d26\u53f7: " + account + ",\u9000\u51fa\u6210\u529f\uff01", 4, null);
            log.info(" \u8d26\u53f7:  " + account + ",\u9000\u51fa\u6210\u529f\uff01 ");
            this.redisUtil.del("sys:token:" + token);
            this.redisUtil.del("shiro:cache:com.els.modules.shiro.authc.ShiroRealm.authorizationCache:" + sysUser.getId());
            this.redisUtil.del(String.format("%s::%s", "sys:cache:user", account));
            this.redisUtil.del("sys:token:role:" + token);
            SecurityUtils.getSubject().logout();
        }
        return Result.ok("\u9000\u51fa\u767b\u5f55\u6210\u529f\uff01");
    }

    @AutoLog(value="\u83b7\u53d6\u7cfb\u7edf\u8bbf\u95ee\u91cf", logType=2, operateType=1)
    @GetMapping(value={"loginfo"})
    public Result<JSONObject> loginfo() {
        Result<JSONObject> result = new Result<JSONObject>();
        JSONObject obj = new JSONObject();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date dayStart = calendar.getTime();
        ((Calendar)calendar).add(5, 1);
        Date dayEnd = calendar.getTime();
        Long totalVisitCount = this.logService.findTotalVisitCount();
        obj.put("totalVisitCount", (Object)totalVisitCount);
        Long todayVisitCount = this.logService.findTodayVisitCount(dayStart, dayEnd);
        obj.put("todayVisitCount", (Object)todayVisitCount);
        Long todayIp = this.logService.findTodayIp(dayStart, dayEnd);
        obj.put("todayIp", (Object)todayIp);
        result.setResult(obj);
        result.success("\u767b\u5f55\u6210\u529f");
        return result;
    }

    @GetMapping(value={"visitInfo"})
    public Result<List<Map<String, Object>>> visitInfo() {
        Result<List<Map<String, Object>>> result = new Result<List<Map<String, Object>>>();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ((Calendar)calendar).add(5, 1);
        Date dayEnd = calendar.getTime();
        ((Calendar)calendar).add(5, -7);
        Date dayStart = calendar.getTime();
        List<Map<String, Object>> list = this.logService.findVisitCount(dayStart, dayEnd);
        result.setResult(ConvertUtils.toLowerCasePageList(list));
        return result;
    }

    @AutoLog(value="\u77ed\u4fe1\u767b\u5f55\u63a5\u53e3", logType=1)
    @PostMapping(value={"/sms"})
    public Result<String> sms(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        String mobile = jsonObject.get((Object)"mobile").toString();
        String smsmode = jsonObject.get((Object)"smsmode").toString();
        Object object = this.redisUtil.get(mobile);
        if (object != null) {
            result.setMessage("\u9a8c\u8bc1\u780110\u5206\u949f\u5185\uff0c\u4ecd\u7136\u6709\u6548\uff01");
            result.setSuccess(false);
            return result;
        }
        String captcha = RandomUtil.randomNumbers((int)6);
        JSONObject obj = new JSONObject();
        obj.put("code", (Object)captcha);
        try {
            boolean b = false;
            if ("1".equals(smsmode)) {
                b = DySmsHelper.sendTemplateSms(mobile, obj, this.smsConfig.getSignName(), this.smsConfig.getVerificationTemplateCode());
            } else {
                ElsSubAccount sysUser = this.elsSubAccountService.getUserByPhone(mobile);
                result = this.elsSubAccountService.checkUserIsEffective(sysUser);
                if (!result.isSuccess()) {
                    return result;
                }
                if ("0".equals(smsmode)) {
                    b = DySmsHelper.sendSms(mobile, obj, DySmsEnum.LOGIN_TEMPLATE_CODE);
                } else if ("2".equals(smsmode)) {
                    b = DySmsHelper.sendSms(mobile, obj, DySmsEnum.FORGET_PASSWORD_TEMPLATE_CODE);
                }
            }
            if (!b) {
                result.setMessage("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                result.setSuccess(false);
                return result;
            }
            this.redisUtil.set(mobile, captcha, 600L);
            result.setSuccess(true);
        }
        catch (ClientException e) {
            e.printStackTrace();
            result.error500(" \u77ed\u4fe1\u63a5\u53e3\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return result;
        }
        return result;
    }

    @AutoLog(value="\u624b\u673a\u53f7\u767b\u5f55\u63a5\u53e3", logType=1)
    @ApiOperation(value="\u624b\u673a\u53f7\u767b\u5f55\u63a5\u53e3")
    @PostMapping(value={"/phoneLogin"})
    public Result<JSONObject> phoneLogin(@RequestBody JSONObject jsonObject) {
        Object code;
        Result result = new Result();
        String phone = jsonObject.getString("mobile");
        ElsSubAccount sysUser = this.elsSubAccountService.getUserByPhone(phone);
        result = this.elsSubAccountService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            return result;
        }
        String smscode = jsonObject.getString("captcha");
        if (!smscode.equals(code = this.redisUtil.get(phone))) {
            result.setMessage("\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
            return result;
        }
        this.userInfo(sysUser, result);
        this.sysBaseAPI.addLog("\u7528\u6237\u540d: " + sysUser.getSubAccount() + ",\u767b\u5f55\u6210\u529f\uff01", 1, null);
        return result;
    }

    private Result<JSONObject> userInfo(ElsSubAccount sysUser, Result<JSONObject> result) {
        String syspassword = sysUser.getPassword();
        String elsAccount = sysUser.getElsAccount();
        String subAccount = sysUser.getSubAccount();
        String token = JwtUtil.sign(elsAccount + "_" + subAccount, syspassword);
        this.redisUtil.set("sys:token:" + token, token);
        this.redisUtil.expire("sys:token:" + token, 3600L);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, adminFlag);
        List<ElsCompanySetVO> list = this.elsCompanySetService.findList(elsAccount);
        ElsSubAccountVO elsSubAccountVO = new ElsSubAccountVO();
        BeanUtils.copyProperties((Object)sysUser, (Object)elsSubAccountVO);
        Map<String, String> map = this.elsSubAccountService.getLogoSetByElsAccount(elsAccount);
        if (map != null) {
            elsSubAccountVO.setAliasName(map.get("alias"));
            elsSubAccountVO.setEnterpriseName(map.get("name"));
            elsSubAccountVO.setEnterpriseLogo(map.get("default_value") != null && "1".equals(map.get("default_value")) && map.get("enterprise_logo") != null ? map.get("enterprise_logo") : "");
        }
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)elsSubAccountVO);
        obj.put("companySet", (Object)this.getObjBySet(list));
        result.setResult(obj);
        result.success("\u767b\u5f55\u6210\u529f");
        JwtToken jwtToken = new JwtToken(token);
        SecurityUtils.getSubject().login((AuthenticationToken)jwtToken);
        return result;
    }

    private JSONObject getObjBySet(List<ElsCompanySetVO> list) {
        JSONObject result = new JSONObject();
        for (ElsCompanySetVO set : list) {
            result.put(set.getItemCode(), (Object)set.getDefaultValue());
        }
        return result;
    }

    @AutoLog(value="\u83b7\u53d6\u52a0\u5bc6\u5b57\u7b26\u4e32", logType=2, operateType=1)
    @GetMapping(value={"/getEncryptedString"})
    public Result<Map<String, String>> getEncryptedString() {
        Result<Map<String, String>> result = new Result<Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", EncryptedString.key);
        map.put("iv", EncryptedString.iv);
        result.setResult(map);
        return result;
    }

    @AutoLog(value="\u83b7\u53d6\u9a8c\u8bc1\u7801", logType=2, operateType=1)
    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/getCheckCode"})
    public Result<Map<String, String>> getCheckCode() {
        Result<Map<String, String>> result = new Result<Map<String, String>>();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String code = RandomUtil.randomString((String)BASE_CHECK_CODES, (int)4);
            String key = MD5Util.md5Encode(code + System.currentTimeMillis(), "utf-8");
            this.redisUtil.set(key, code, 180L);
            map.put("key", key);
            map.put("code", code);
            result.setResult(map);
            result.setSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setSuccess(false);
        }
        return result;
    }
}

