/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.api.vo.Result;
import com.els.common.system.api.ISysBaseAPI;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.enums.AccountStatusEnum;
import com.els.modules.system.mapper.ElsTenantMapper;
import com.els.modules.system.service.ElsTenantService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElsTenantServiceImpl
extends ServiceImpl<ElsTenantMapper, ElsTenant>
implements ElsTenantService {
    @Autowired
    private ISysBaseAPI sysBaseAPI;

    @Override
    public void saveElsTenant(ElsTenant elsTenant) {
        ((ElsTenantMapper)this.baseMapper).insert(elsTenant);
    }

    @Override
    public void updateElsTenant(ElsTenant elsTenant) {
        ((ElsTenantMapper)this.baseMapper).updateById(elsTenant);
    }

    @Override
    public void delElsTenant(String id) {
        ((ElsTenantMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchElsTenant(List<String> idList) {
        ((ElsTenantMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public Result<JSONObject> checkTenantIsEffective(String elsAccount) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)elsAccount);
        ElsTenant tenant = (ElsTenant)((ElsTenantMapper)this.baseMapper).selectOne((Wrapper)wrapper);
        Result<JSONObject> result = new Result<JSONObject>();
        if (tenant == null) {
            result.error500("\u8be5ELS\u8d26\u53f7\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            this.sysBaseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0cELS\u8d26\u53f7\u4e0d\u5b58\u5728\uff01", 1, null);
            return result;
        }
        if (AccountStatusEnum.FROZEN.getCode().equals(tenant.getAccountStatus())) {
            this.sysBaseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0cELS\u8d26\u53f7:" + elsAccount + "\u5df2\u51bb\u7ed3\uff01", 1, null);
            result.error500("\u8be5ELS\u8d26\u53f7\u5df2\u51bb\u7ed3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return result;
        }
        if (new Date().after(tenant.getExpiryDate())) {
            this.sysBaseAPI.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0cELS\u8d26\u53f7:" + elsAccount + "\u5df2\u5931\u6548\uff01", 1, null);
            result.error500("\u8be5ELS\u8d26\u53f7\u5df2\u8fc7\u6709\u6548\u65e5\u671f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return result;
        }
        return result;
    }
}

