/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.I18n;
import com.els.modules.system.mapper.I18nMapper;
import com.els.modules.system.service.I18nService;
import com.els.modules.system.util.I18nUtil;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class I18nServiceImpl
extends ServiceImpl<I18nMapper, I18n>
implements I18nService {
    @Autowired
    private RedisUtil redisUtil;
    private static final String I18N_KEY = "sys:i18n:";
    private static final String COLON = ":";

    @Override
    public IPage<I18n> finPagelist(I18n i18n) {
        List<I18n> list = ((I18nMapper)this.baseMapper).findPageList(i18n);
        int count = ((I18nMapper)this.baseMapper).findPageListCount(i18n);
        Page page = new Page((long)i18n.getFromIndex().intValue(), (long)i18n.getPageSize().intValue());
        page.setRecords(list);
        page.setSize((long)count);
        page.setTotal((long)count);
        return page;
    }

    @Override
    public JSONObject findAllList(I18n i18n) {
        StringBuilder redisKey = new StringBuilder(I18N_KEY);
        redisKey.append(i18n.getElsAccount());
        redisKey.append(COLON);
        redisKey.append(i18n.getLanguage());
        JSONObject i18nJson = (JSONObject)this.redisUtil.get(redisKey.toString());
        if (i18nJson != null) {
            return i18nJson;
        }
        i18n.setFromIndex(0);
        i18n.setPageSize(Integer.MAX_VALUE);
        List<I18n> list = ((I18nMapper)this.baseMapper).findPageList(i18n);
        i18nJson = new JSONObject();
        for (I18n o : list) {
            i18nJson.put(i18n.getElsAccount() + "#" + o.getI18nKey(), (Object)o.getI18nValue());
        }
        this.redisUtil.set(redisKey.toString(), i18nJson, 3600L);
        return i18nJson;
    }

    @Override
    public String getI18nValue(String i18nKey, String defaultValue) {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh_CN";
        }
        I18n i18n = new I18n();
        i18n.setElsAccount(TenantContext.getTenant());
        i18n.setLanguage(language);
        JSONObject i18nJson = this.findAllList(i18n);
        if (i18nJson == null) {
            return defaultValue;
        }
        String value = i18nJson.getString(TenantContext.getTenant() + "#" + i18nKey);
        if (StrUtil.isNotBlank((CharSequence)value)) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public void delRedisData() {
        this.redisUtil.dels(I18N_KEY);
    }
}

