/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.system.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SpringContextUtils;
import com.els.modules.system.util.I18nUtil;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class JwtUtil {
    public static final long EXPIRE_TIME = 1800000L;
    public static final long OUT_EXPIRE_TIME = 172800000L;

    public static boolean verify(String token, String account, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("account", account).build();
            verifier.verify(token);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getAccount(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("account").asString();
        }
        catch (JWTDecodeException e) {
            return null;
        }
    }

    public static String sign(String account, String secret) {
        Date date = new Date(System.currentTimeMillis() + 1800000L);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("account", account).withExpiresAt(date).sign(algorithm);
    }

    public static String getOutToken(String account, String secret) {
        Date date = new Date(System.currentTimeMillis() + 172800000L);
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim("account", account).withExpiresAt(date).sign(algorithm);
    }

    public static String getUserNameByToken(HttpServletRequest request) throws ELSBootException {
        String accessToken = request.getHeader("X-Access-Token");
        String account = JwtUtil.getAccount(accessToken);
        if (ConvertUtils.isEmpty(account)) {
            throw new ELSBootException(I18nUtil.translate("", "\u672a\u83b7\u53d6\u5230\u7528\u6237"));
        }
        return account;
    }

    public static String getSessionData(String key) {
        String moshi = "";
        if (key.indexOf("}") != -1) {
            moshi = key.substring(key.indexOf("}") + 1);
        }
        String returnValue = null;
        if (key.contains("#{")) {
            key = key.substring(2, key.indexOf("}"));
        }
        if (ConvertUtils.isNotEmpty(key)) {
            HttpSession session = SpringContextUtils.getHttpServletRequest().getSession();
            returnValue = (String)session.getAttribute(key);
        }
        if (returnValue != null) {
            returnValue = returnValue + moshi;
        }
        return returnValue;
    }

    public static void main(String[] args) {
        String token = "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJleHAiOjE1NjUzMzY1MTMsInVzZXJuYW1lIjoiYWRtaW4ifQ.xjhud_tWCNYBOg_aRlMgOdlZoWFFKB_givNElHNw3X0";
        System.out.println(JwtUtil.getAccount(token));
    }
}

