/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util;

import com.els.common.exception.ELSBootException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class Assert {
    public static void isNotEmpty(Collection list, String defaultMsg) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new ELSBootException(defaultMsg);
        }
    }

    public static void isNotEmpty(List list, String defaultMsg, String i18n) {
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new ELSBootException(defaultMsg, i18n);
        }
    }

    public static void isNotBlank(String value, String defaultMsg) {
        if (StringUtils.isBlank((String)value)) {
            throw new ELSBootException(defaultMsg);
        }
    }

    public static void isNotBlank(String value, String defaultMsg, String i18n) {
        if (StringUtils.isBlank((String)value)) {
            throw new ELSBootException(defaultMsg, i18n);
        }
    }

    public static void isNotNull(Object type, String mss) {
        if (type == null) {
            throw new ELSBootException(mss);
        }
    }

    public static void isNotNull(Object type) {
        if (type == null) {
            throw new ELSBootException(type + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static <T> void isExists(List<T> list, T value, String msg) {
        if (!list.contains(value)) {
            throw new ELSBootException(StringUtils.defaultIfBlank((String)msg, (String)"\u8be5\u503c\u4e0d\u5b58\u5728"));
        }
    }

    public static <T> void doNotExists(List<T> list, T value, String msg) {
        if (list.contains(value)) {
            throw new ELSBootException(StringUtils.defaultIfBlank((String)msg, (String)"\u8be5\u503c\u5df2\u7ecf\u5b58\u5728"));
        }
    }

    public static void msgThrow(String msg) {
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ELSBootException(msg);
        }
    }
}

