/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util;

import com.els.modules.system.util.I18nUtil;
import java.beans.PropertyEditorSupport;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.springframework.util.StringUtils;

public class DateUtils
extends PropertyEditorSupport {
    public static ThreadLocal<SimpleDateFormat> date_sdf = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    public static ThreadLocal<SimpleDateFormat> yyyyMMdd = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd");
        }
    };
    public static ThreadLocal<SimpleDateFormat> date_sdf_wz = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        }
    };
    public static ThreadLocal<SimpleDateFormat> time_sdf = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm");
        }
    };
    public static ThreadLocal<SimpleDateFormat> yyyymmddhhmmss = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMddHHmmss");
        }
    };
    public static ThreadLocal<SimpleDateFormat> short_time_sdf = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm");
        }
    };
    public static ThreadLocal<SimpleDateFormat> datetimeFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final long HOUR_IN_MILLIS = 3600000L;
    private static final long MINUTE_IN_MILLIS = 60000L;
    private static final long SECOND_IN_MILLIS = 1000L;

    private static SimpleDateFormat getSDFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar getCalendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(millis));
        return cal;
    }

    public static Date getDate() {
        return new Date();
    }

    public static Date getDate(long millis) {
        return new Date(millis);
    }

    public static Timestamp str2Timestamp(String str) {
        SimpleDateFormat dateSdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = DateUtils.str2Date(str, dateSdf);
        return new Timestamp(date.getTime());
    }

    public static Date parseDateNew(String d, String format) {
        try {
            return new SimpleDateFormat(format).parse(d);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date parseDate(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof java.sql.Date) {
            return (Date)o;
        }
        if (o instanceof String) {
            String d = (String)o;
            StringBuilder format = new StringBuilder("yyyy");
            if (d.charAt(4) == '-') {
                format.append("-MM-dd");
            } else if (d.charAt(4) == '/') {
                format.append("/MM/dd");
            } else if (d.charAt(4) == '_') {
                format.append("_MM_dd");
            } else {
                format.append("MMdd");
            }
            if (d.length() < format.length()) {
                return null;
            }
            if (d.length() == format.length()) {
                return DateUtils.parseDateNew(d, format.toString());
            }
            if (d.charAt(format.length()) == ' ') {
                format.append(' ');
            }
            if (d.charAt(format.length() + 2) == ':') {
                format.append("HH:mm:ss");
            } else if (d.charAt(format.length() + 2) == '/') {
                format.append("HH/mm/ss");
            } else {
                format.append("HHmmss");
            }
            if (d.length() < format.length()) {
                return null;
            }
            if (d.length() == format.length()) {
                return DateUtils.parseDateNew(d, format.toString());
            }
            if (d.charAt(format.length()) == '.' && d.length() == format.length() + 4) {
                format.append(".SSS");
            } else if (d.length() == format.length() + 3) {
                format.append("SSS");
            } else {
                d = d.substring(0, format.length());
            }
            return DateUtils.parseDateNew(d, format.toString());
        }
        if (o instanceof Long) {
            long l = (Long)o;
            if (l < 10000000000L) {
                return new Date(l * 1000L);
            }
            return new Date(l);
        }
        if (o instanceof Integer) {
            long l = Long.valueOf((Integer)o + "000");
            return new Date(l);
        }
        return null;
    }

    public static Date str2Date(String str, SimpleDateFormat sdf) {
        if (null == str || "".equals(str)) {
            return null;
        }
        Date date = null;
        try {
            date = sdf.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String dateformat(String date, String format) {
        SimpleDateFormat sformat = new SimpleDateFormat(format);
        Date newDate = null;
        try {
            newDate = sformat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sformat.format(newDate);
    }

    public static String date2Str(Date date, SimpleDateFormat dateSdf) {
        if (null == date) {
            return null;
        }
        return dateSdf.format(date);
    }

    public static String getDate(String format) {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Timestamp getTimestamp(long millis) {
        return new Timestamp(millis);
    }

    public static Timestamp getTimestamp(String time) {
        return new Timestamp(Long.parseLong(time));
    }

    public static Timestamp getTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String now() {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateTimeFormat.format(DateUtils.getCalendar().getTime());
    }

    public static Timestamp getTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    public static Timestamp getCalendarTimestamp(Calendar cal) {
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp gettimestamp() {
        Date dt = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowTime = df.format(dt);
        Timestamp buydate = Timestamp.valueOf(nowTime);
        return buydate;
    }

    public static long getMillis() {
        return System.currentTimeMillis();
    }

    public static long getMillis(Calendar cal) {
        return cal.getTime().getTime();
    }

    public static long getMillis(Date date) {
        return date.getTime();
    }

    public static long getMillis(Timestamp ts) {
        return ts.getTime();
    }

    public static String formatDate() {
        SimpleDateFormat dateSdf = new SimpleDateFormat("yyyy-MM-dd");
        return dateSdf.format(DateUtils.getCalendar().getTime());
    }

    public static String formatDateTime() {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateTimeFormat.format(DateUtils.getCalendar().getTime());
    }

    public static String getDataString(SimpleDateFormat formatstr) {
        return formatstr.format(DateUtils.getCalendar().getTime());
    }

    public static String formatDate(Calendar cal) {
        SimpleDateFormat dateSdf = new SimpleDateFormat("yyyy-MM-dd");
        return dateSdf.format(cal.getTime());
    }

    public static String formatDate(Date date) {
        SimpleDateFormat dateSdf = new SimpleDateFormat("yyyy-MM-dd");
        return dateSdf.format(date);
    }

    public static String formatDate(long millis) {
        SimpleDateFormat dateSdf = new SimpleDateFormat("yyyy-MM-dd");
        return dateSdf.format(new Date(millis));
    }

    public static String formatDate(String pattern) {
        return DateUtils.getSDFormat(pattern).format(DateUtils.getCalendar().getTime());
    }

    public static String formatDate(Calendar cal, String pattern) {
        return DateUtils.getSDFormat(pattern).format(cal.getTime());
    }

    public static String formatDate(Date date, String pattern) {
        return DateUtils.getSDFormat(pattern).format(date);
    }

    public static String formatTime() {
        SimpleDateFormat timeSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return timeSdf.format(DateUtils.getCalendar().getTime());
    }

    public static String formatTime(long millis) {
        SimpleDateFormat timeSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return timeSdf.format(new Date(millis));
    }

    public static String formatTime(Calendar cal) {
        SimpleDateFormat timeSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return timeSdf.format(cal.getTime());
    }

    public static String formatTime(Date date) {
        SimpleDateFormat timeSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        return timeSdf.format(date);
    }

    public static String formatShortTime() {
        SimpleDateFormat shortTimeSdf = new SimpleDateFormat("HH:mm");
        return shortTimeSdf.format(DateUtils.getCalendar().getTime());
    }

    public static String formatShortTime(long millis) {
        SimpleDateFormat shortTimeSdf = new SimpleDateFormat("HH:mm");
        return shortTimeSdf.format(new Date(millis));
    }

    public static String formatShortTime(Calendar cal) {
        SimpleDateFormat shortTimeSdf = new SimpleDateFormat("HH:mm");
        return shortTimeSdf.format(cal.getTime());
    }

    public static String formatShortTime(Date date) {
        SimpleDateFormat shortTimeSdf = new SimpleDateFormat("HH:mm");
        return shortTimeSdf.format(date);
    }

    public static Date parseDate(String src, String pattern) throws ParseException {
        return DateUtils.getSDFormat(pattern).parse(src);
    }

    public static Calendar parseCalendar(String src, String pattern) throws ParseException {
        Date date = DateUtils.parseDate(src, pattern);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String formatAddDate(String src, String pattern, int amount) throws ParseException {
        Calendar cal = DateUtils.parseCalendar(src, pattern);
        cal.add(5, amount);
        return DateUtils.formatDate(cal);
    }

    public static Timestamp parseTimestamp(String src, String pattern) throws ParseException {
        Date date = DateUtils.parseDate(src, pattern);
        return new Timestamp(date.getTime());
    }

    public static int dateDiff(char flag, Calendar calSrc, Calendar calDes) {
        long millisDiff = DateUtils.getMillis(calSrc) - DateUtils.getMillis(calDes);
        if (flag == 'y') {
            return calSrc.get(1) - calDes.get(1);
        }
        if (flag == 'd') {
            return (int)(millisDiff / 86400000L);
        }
        if (flag == 'h') {
            return (int)(millisDiff / 3600000L);
        }
        if (flag == 'm') {
            return (int)(millisDiff / 60000L);
        }
        if (flag == 's') {
            return (int)(millisDiff / 1000L);
        }
        return 0;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText((String)text)) {
            try {
                if (text.indexOf(":") == -1 && text.length() == 10) {
                    SimpleDateFormat dateSdf = new SimpleDateFormat("yyyy-MM-dd");
                    this.setValue(dateSdf.parse(text));
                }
                if (text.indexOf(":") > 0 && text.length() == 19) {
                    SimpleDateFormat dateTimeFormate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    this.setValue(dateTimeFormate.parse(text));
                }
                throw new IllegalArgumentException(I18nUtil.translate("", "Could not parse date, date format is error "));
            }
            catch (ParseException ex) {
                IllegalArgumentException iae = new IllegalArgumentException(I18nUtil.translate("", "Could not parse date: " + ex.getMessage()));
                iae.initCause(ex);
                throw iae;
            }
        } else {
            this.setValue(null);
        }
    }

    public static int getYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(DateUtils.getDate());
        return calendar.get(1);
    }
}

