/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util;

import com.els.modules.system.util.I18nUtil;
import java.net.URL;
import java.net.URLDecoder;

public class MyClassLoader
extends ClassLoader {
    public static Class getClassByScn(String className) {
        Class<?> myclass = null;
        try {
            myclass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new RuntimeException(I18nUtil.translate("", className + " not found!"));
        }
        return myclass;
    }

    public static String getPackPath(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(I18nUtil.translate("", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        String clsName = object.getClass().getName();
        return clsName;
    }

    public static String getAppPath(Class cls) {
        URL url;
        String realPath;
        int pos;
        if (cls == null) {
            throw new IllegalArgumentException(I18nUtil.translate("", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        ClassLoader loader = cls.getClassLoader();
        String clsName = cls.getName() + ".class";
        Package pack = cls.getPackage();
        String path = "";
        if (pack != null) {
            String packName = pack.getName();
            if (packName.startsWith("java.") || packName.startsWith("javax.")) {
                throw new IllegalArgumentException(I18nUtil.translate("", "\u4e0d\u8981\u4f20\u9001\u7cfb\u7edf\u7c7b\uff01"));
            }
            clsName = clsName.substring(packName.length() + 1);
            if (packName.indexOf(".") < 0) {
                path = packName + "/";
            } else {
                int start = 0;
                int end = 0;
                end = packName.indexOf(".");
                while (end != -1) {
                    path = path + packName.substring(start, end) + "/";
                    start = end + 1;
                    end = packName.indexOf(".", start);
                }
                path = path + packName.substring(start) + "/";
            }
        }
        if ((pos = (realPath = (url = loader.getResource(path + clsName)).getPath()).indexOf("file:")) > -1) {
            realPath = realPath.substring(pos + 5);
        }
        if ((realPath = realPath.substring(0, (pos = realPath.indexOf(path + clsName)) - 1)).endsWith("!")) {
            realPath = realPath.substring(0, realPath.lastIndexOf("/"));
        }
        try {
            realPath = URLDecoder.decode(realPath, "utf-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return realPath;
    }
}

