/*
 * Decompiled with CFR 0.152.
 */
package com.els.config;

import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.els.config.ElsTenantHandler;
import com.els.config.mybatis.ElsTenantParser;
import com.els.framework.mybatis.MybatisInjector;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@MapperScan(value={"com.els.modules.**.mapper*"})
public class MybatisPlusConfig {
    private static final List<String> KEYWORD = new ArrayList<String>();

    @Bean
    public PaginationInterceptor paginationInterceptor() {
        PaginationInterceptor paginationInterceptor = new PaginationInterceptor();
        paginationInterceptor.setLimit(-1L);
        this.tenantConfig(paginationInterceptor);
        return paginationInterceptor;
    }

    private void tenantConfig(PaginationInterceptor paginationInterceptor) {
        ArrayList<ElsTenantParser> sqlParserList = new ArrayList<ElsTenantParser>();
        ElsTenantParser tenantSqlParser = new ElsTenantParser();
        tenantSqlParser.setTenantHandler(new ElsTenantHandler());
        sqlParserList.add(tenantSqlParser);
        paginationInterceptor.setSqlParserList(sqlParserList);
        paginationInterceptor.setSqlParserFilter(metaObject -> {
            String method = (String)metaObject.getValue("delegate.mappedStatement.id");
            if (method.endsWith("selectById") || method.endsWith("selectTenantTemplate") || method.endsWith("selectByMainId")) {
                return true;
            }
            String sql = (String)metaObject.getValue("delegate.boundSql.sql");
            String sql_lowercase = sql.toLowerCase();
            for (String key : KEYWORD) {
                if (!sql_lowercase.contains(key)) continue;
                return true;
            }
            return false;
        });
    }

    @Bean
    public MybatisInjector sqlInjector() {
        return new MybatisInjector();
    }

    static {
        KEYWORD.add("insert ");
        KEYWORD.add("update ");
        KEYWORD.add("delete ");
    }
}

