/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.shiro.authc.aop;

import com.alibaba.fastjson.JSON;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.exception.ELSBootExceptionHandler;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.shiro.authc.JwtToken;
import com.els.modules.shiro.contants.DefContants;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.impl.ElsSubAccountServiceImpl;
import com.els.modules.system.util.I18nUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;

public class OpenApiFilter
extends BasicHttpAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(OpenApiFilter.class);

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        try {
            return this.executeLogin(request, response);
        }
        catch (Exception e) {
            throw new AuthenticationException("API \u9274\u6743\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String elsAccount = httpServletRequest.getHeader(DefContants.API_ELS_ACCOUNT);
        String subAccount = httpServletRequest.getHeader(DefContants.API_SUB_ACCOUNT);
        String pwd = httpServletRequest.getHeader(DefContants.API_PWD);
        try {
            if (StringUtils.isBlank((CharSequence)elsAccount) || StringUtils.isBlank((CharSequence)subAccount) || StringUtils.isBlank((CharSequence)pwd) || !subAccount.contains("App_")) {
                throw new ELSBootException(I18nUtil.translate("", "\u8d26\u53f7\u5bc6\u7801\u683c\u5f0f\u4e0d\u6b63\u786e"));
            }
            TenantContext.setTenant(elsAccount);
            ElsSubAccountService userService = SpringContextUtils.getBean(ElsSubAccountServiceImpl.class);
            ElsSubAccount account = userService.getUserBySubAccount(subAccount);
            if (account == null) {
                throw new ELSBootException(I18nUtil.translate("", "\u8d26\u53f7\u5bc6\u7801\u4e0d\u6b63\u786e"));
            }
            String password = PasswordUtil.encrypt(elsAccount + "_" + subAccount, pwd, account.getSalt());
            if (!password.equals(account.getPassword())) {
                throw new ELSBootException(I18nUtil.translate("", "\u8d26\u53f7\u5bc6\u7801\u4e0d\u6b63\u786e"));
            }
            Result result = userService.checkUserIsEffective(account);
            if (!result.isSuccess()) {
                throw new ELSBootException(I18nUtil.translate("", "\u8d26\u53f7\u4e0d\u53ef\u7528"));
            }
            String tokenStr = JwtUtil.sign(elsAccount + "_" + subAccount, pwd);
            RedisUtil redisUtil = SpringContextUtils.getBean(RedisUtil.class);
            redisUtil.set("sys:token:" + tokenStr, tokenStr);
            redisUtil.expire("sys:token:" + tokenStr, 3600L);
            JwtToken token = new JwtToken(tokenStr);
            SecurityUtils.getSubject().login((AuthenticationToken)token);
            TenantContext.setTenant(elsAccount);
        }
        catch (ELSBootException e) {
            ELSBootExceptionHandler handler = new ELSBootExceptionHandler();
            this.returnJson(response, JSON.toJSONString(handler.handleRRException(e)));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnJson(ServletResponse response, String json) {
        PrintWriter writer = null;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        try {
            writer = response.getWriter();
            writer.print(json);
        }
        catch (IOException e) {
            log.error("response error", (Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setHeader("Access-control-Allow-Origin", httpServletRequest.getHeader("Origin"));
        httpServletResponse.setHeader("Access-Control-Allow-Methods", "GET,POST,OPTIONS,PUT,DELETE");
        httpServletResponse.setHeader("Access-Control-Allow-Headers", httpServletRequest.getHeader("Access-Control-Request-Headers"));
        if (httpServletRequest.getMethod().equals(RequestMethod.OPTIONS.name())) {
            httpServletResponse.setStatus(HttpStatus.OK.value());
            return false;
        }
        return super.preHandle(request, response);
    }
}

