/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.CompanyI18n;
import com.els.modules.system.entity.I18n;
import com.els.modules.system.service.CheckService;
import com.els.modules.system.service.CompanyI18nService;
import com.els.modules.system.service.I18nService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u56fd\u9645\u5316"})
@RestController
@RequestMapping(value={"/i18n"})
public class I18nController
extends BaseController<I18n, I18nService> {
    @Autowired
    private I18nService i18nService;
    @Autowired
    private CompanyI18nService companyI18nService;
    @Autowired
    private CheckService checkService;

    @ApiOperation(value="\u56fd\u9645\u5316-\u524d\u7aef\u83b7\u53d6\u7cfb\u7edf\u7ea7\u6570\u636e", notes="\u56fd\u9645\u5316-\u524d\u7aef\u83b7\u53d6\u7cfb\u7edf\u7ea7\u6570\u636e")
    @GetMapping(value={"/getSysList/{language}"})
    public String getI18nJson(@PathVariable(value="language") String language) {
        I18n param = new I18n();
        param.setLanguage(language);
        param.setElsAccount("100000");
        JSONObject json = this.i18nService.findAllList(param);
        return json.toString();
    }

    @ApiOperation(value="\u56fd\u9645\u5316-\u524d\u7aef\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4f01\u4e1a\u7ea7\u6570\u636e", notes="\u56fd\u9645\u5316-\u524d\u7aef\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4f01\u4e1a\u7ea7\u6570\u636e")
    @GetMapping(value={"/getCompanyList/{language}"})
    public String getI18nJsonByCompany(@PathVariable(value="language") String language) {
        I18n param = new I18n();
        param.setLanguage(language);
        param.setElsAccount(TenantContext.getTenant());
        JSONObject json = this.i18nService.findAllList(param);
        return json.toString();
    }

    @ApiOperation(value="\u56fd\u9645\u5316-\u524d\u7aef\u83b7\u53d6\u6307\u5b9a\u4f01\u4e1a\u7ea7\u6570\u636e", notes="\u56fd\u9645\u5316-\u524d\u7aef\u83b7\u53d6\u4f01\u4e1a\u7ea7js")
    @GetMapping(value={"/getI18nByBusAccount/{language}/{busAccount}"})
    public String getI18nByBusAccount(@PathVariable(value="language") String language, @PathVariable(value="busAccount") String busAccount) {
        I18n param = new I18n();
        param.setLanguage(language);
        param.setElsAccount(busAccount);
        JSONObject json = this.i18nService.findAllList(param);
        return json.toString();
    }

    @ApiOperation(value="\u56fd\u9645\u5316-\u6e05\u9664\u7f13\u5b58", notes="\u56fd\u9645\u5316-\u6e05\u9664\u7f13\u5b58")
    @GetMapping(value={"/delRedisData"})
    public Result<?> delRedisData() {
        this.i18nService.delRedisData();
        return Result.ok("\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u56fd\u9645\u5316-\u7cfb\u7edf\u7ea7\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u56fd\u9645\u5316-\u7cfb\u7edf\u7ea7\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/syslist"})
    public Result<?> querySysPageList(I18n i18n, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<I18n> queryWrapper = QueryGenerator.initQueryWrapper(i18n, req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        IPage pageList = this.i18nService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(I18n i18n, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        i18n.setFromIndex(pageNo - 1 >= 0 ? (pageNo - 1) * pageSize : 0);
        i18n.setPageSize(pageSize);
        i18n.setElsAccount(TenantContext.getTenant());
        IPage<I18n> pageList = this.i18nService.finPagelist(i18n);
        return Result.ok(pageList);
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u6dfb\u52a0", logType=2, operateType=2)
    @ApiOperation(value="\u56fd\u9645\u5316-\u6dfb\u52a0", notes="\u56fd\u9645\u5316-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody I18n i18n) {
        String msg = this.checkExist(i18n.getId(), i18n.getLanguage() + "-" + i18n.getI18nKey());
        if (!"success".equals(msg)) {
            return Result.error(msg);
        }
        this.i18nService.save(i18n);
        return Result.ok("\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u7f16\u8f91", logType=2, operateType=3)
    @ApiOperation(value="\u56fd\u9645\u5316-\u7f16\u8f91", notes="\u56fd\u9645\u5316-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody I18n i18n) {
        String msg = this.checkExist(i18n.getId(), i18n.getLanguage() + "-" + i18n.getI18nKey());
        if (!"success".equals(msg)) {
            return Result.error(msg);
        }
        String elsAccount = TenantContext.getTenant();
        if (!elsAccount.equals(i18n.getElsAccount())) {
            String i18nId = i18n.getI18nId();
            CompanyI18n companyI18n = new CompanyI18n();
            companyI18n.setElsAccount(elsAccount);
            companyI18n.setI18nValue(i18n.getI18nValue());
            companyI18n.setI18nId(i18n.getId());
            if (StrUtil.isBlank((CharSequence)i18nId)) {
                this.companyI18nService.save(companyI18n);
            } else {
                companyI18n.setId(i18n.getI18nId());
                this.companyI18nService.updateById(companyI18n);
            }
        } else {
            this.i18nService.updateById(i18n);
        }
        return Result.ok("\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u7ffb\u8bd1", logType=2, operateType=3)
    @ApiOperation(value="\u56fd\u9645\u5316-\u7ffb\u8bd1", notes="\u56fd\u9645\u5316-\u7ffb\u8bd1")
    @PostMapping(value={"/translate"})
    public Result<?> translate(@RequestBody I18n i18n) {
        String elsAccount = TenantContext.getTenant();
        if (!elsAccount.equals(i18n.getElsAccount())) {
            String i18nId = i18n.getI18nId();
            CompanyI18n companyI18n = new CompanyI18n();
            companyI18n.setElsAccount(elsAccount);
            companyI18n.setI18nValue(i18n.getI18nValue());
            companyI18n.setI18nId(i18n.getId());
            if (StrUtil.isBlank((CharSequence)i18nId)) {
                this.companyI18nService.save(companyI18n);
            } else {
                companyI18n.setId(i18n.getI18nId());
                this.companyI18nService.updateById(companyI18n);
            }
        } else {
            this.i18nService.updateById(i18n);
        }
        return Result.ok("\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u901a\u8fc7id\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u56fd\u9645\u5316-\u901a\u8fc7id\u5220\u9664", notes="\u56fd\u9645\u5316-\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.i18nService.removeById((Serializable)((Object)id));
        return Result.ok("\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u6279\u91cf\u5220\u9664", logType=2, operateType=4)
    @ApiOperation(value="\u56fd\u9645\u5316-\u6279\u91cf\u5220\u9664", notes="\u56fd\u9645\u5316-\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.i18nService.removeByIds(idList);
        return Result.ok("\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u901a\u8fc7id\u67e5\u8be2", logType=2, operateType=1)
    @ApiOperation(value="\u56fd\u9645\u5316-\u901a\u8fc7id\u67e5\u8be2", notes="\u56fd\u9645\u5316-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        I18n i18n = (I18n)this.i18nService.getById((Serializable)((Object)id));
        return Result.ok(i18n);
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u5bfc\u51faExcel", logType=2, operateType=6)
    @RequestMapping(value={"/exportXls"}, method={RequestMethod.GET})
    public ModelAndView exportXls(HttpServletRequest request, I18n i18n) {
        i18n.setFromIndex(0);
        i18n.setPageSize(Integer.MAX_VALUE);
        i18n.setElsAccount(TenantContext.getTenant());
        IPage<I18n> pageList = this.i18nService.finPagelist(i18n);
        return super.exportXls(request, pageList.getRecords(), I18n.class, "\u56fd\u9645\u5316");
    }

    @AutoLog(value="\u56fd\u9645\u5316-\u5bfc\u5165Excel", logType=2, operateType=5)
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    @CacheEvict(value={"i18nJson"}, allEntries=true)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, I18n.class);
    }

    private String checkExist(String dataId, String value) {
        return this.checkService.checkExist(dataId, "els_i18n", "concat(language,'-',i18n_key)", value);
    }
}

