/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.ConvertUtils;
import com.els.common.util.PasswordUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.shiro.authc.JwtToken;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.model.SsoModel;
import com.els.modules.system.model.ThirdLoginModel;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ThirdAccountService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.vo.ElsCompanySetVO;
import com.xkcoding.justauth.AuthRequestFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.request.AuthRequest;
import me.zhyd.oauth.utils.AuthStateUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/thirdLogin"})
@Api(tags={"\u7b2c\u4e09\u65b9\u767b\u5f55"})
public class ThirdLoginController {
    private static final Logger log = LoggerFactory.getLogger(ThirdLoginController.class);
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private ThirdAccountService thirdAccountService;
    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private AuthRequestFactory factory;
    @Autowired
    private ElsCompanySetService elsCompanySetService;
    private static final String STATE_KEY = "sys:thirdLogin:state:";

    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165render")
    @GetMapping(value={"/render/{source}"})
    public void render(@PathVariable(value="source") String source, @RequestParam(name="routeUri", required=false) String routeUri, HttpServletResponse response) throws IOException {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165render\uff1a" + source);
        AuthRequest authRequest = this.factory.get(source);
        String state = AuthStateUtils.createState();
        String authorizeUrl = authRequest.authorize(state);
        JSONObject object = new JSONObject();
        if (StrUtil.isNotBlank((CharSequence)routeUri)) {
            object.put("routeUri", (Object)routeUri);
            this.redisUtil.set(STATE_KEY + state, object);
        }
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8ba4\u8bc1\u5730\u5740\uff1a" + authorizeUrl);
        response.sendRedirect(authorizeUrl);
    }

    @AutoLog(value="\u7b2c\u4e09\u65b9\u767b\u5f55-\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback")
    @GetMapping(value={"/{source}/callback"})
    public Result<?> loginThird(@PathVariable(value="source") String source, AuthCallback callback) {
        log.info("\u7b2c\u4e09\u65b9\u767b\u5f55\u8fdb\u5165callback\uff1a" + source + " params\uff1a" + JSONObject.toJSONString((Object)callback));
        AuthRequest authRequest = this.factory.get(source);
        AuthResponse response = authRequest.login(callback);
        log.info(JSONObject.toJSONString((Object)response));
        Result<JSONObject> result = new Result<JSONObject>();
        if (response.getCode() == 2000) {
            JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()));
            String username = data.getString("username");
            String avatar = data.getString("avatar");
            String uuid = data.getString("uuid");
            ThirdLoginModel tlm = new ThirdLoginModel(source, uuid, username, avatar);
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(ThirdAccount::getThirdUserUuid, (Object)uuid);
            query.eq(ThirdAccount::getThirdType, (Object)source);
            List thridList = this.thirdAccountService.list((Wrapper)query);
            ThirdAccount user = null;
            user = thridList == null || thridList.size() == 0 ? this.saveThirdUser(tlm) : (ThirdAccount)thridList.get(0);
            if (ConvertUtils.isNotEmpty(user.getUserId())) {
                String userId = user.getUserId();
                ElsSubAccount account = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)userId));
                JSONObject busObj = (JSONObject)this.redisUtil.get(STATE_KEY + callback.getState());
                this.userInfo(account, result, busObj);
            } else {
                JSONObject obj = new JSONObject();
                obj.put("thirdUserUuid", (Object)user.getThirdUserUuid());
                result.setResult(obj);
                result.success("\u64cd\u4f5c\u6210\u529f\u4f46\u6ca1\u6709\u7ed1\u5b9a\u8d26\u53f7\uff01");
            }
        } else {
            result.setSuccess(false);
            result.setMessage("\u7b2c\u4e09\u65b9\u767b\u5f55\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return result;
    }

    private Result<JSONObject> userInfo(ElsSubAccount sysUser, Result<JSONObject> result, JSONObject busObj) {
        String syspassword = sysUser.getPassword();
        String elsAccount = sysUser.getElsAccount();
        String subAccount = sysUser.getSubAccount();
        String token = JwtUtil.sign(elsAccount + "_" + subAccount, syspassword);
        this.redisUtil.set("sys:token:" + token, token);
        this.redisUtil.expire("sys:token:" + token, 3600L);
        TenantContext.setTenant(elsAccount);
        String adminFlag = this.userRoleService.getAdminFlag(elsAccount, subAccount);
        this.redisUtil.set("sys:token:role:" + token, adminFlag);
        List<ElsCompanySetVO> list = this.elsCompanySetService.findList(elsAccount);
        JSONObject obj = new JSONObject();
        obj.put("token", (Object)token);
        obj.put("userInfo", (Object)sysUser);
        obj.put("companySet", (Object)this.getObjBySet(list));
        if (busObj != null) {
            obj.put("busObj", (Object)busObj);
        }
        result.setResult(obj);
        result.success("\u767b\u5f55\u6210\u529f");
        JwtToken jwtToken = new JwtToken(token);
        SecurityUtils.getSubject().login((AuthenticationToken)jwtToken);
        return result;
    }

    private JSONObject getObjBySet(List<ElsCompanySetVO> list) {
        JSONObject result = new JSONObject();
        for (ElsCompanySetVO set : list) {
            result.put(set.getItemCode(), (Object)set.getDefaultValue());
        }
        return result;
    }

    @AutoLog(busModule="\u7b2c\u4e09\u65b9\u767b\u5f55", value="\u83b7\u53d6ssoToken")
    @ApiOperation(value="\u83b7\u53d6ssoToken", notes="\u83b7\u53d6ssoToken")
    @PostMapping(value={"/ssoToken"})
    public Result<?> ssoToken(@RequestBody SsoModel ssoModel) {
        String clientId = ssoModel.getClientId();
        if (StrUtil.isBlank((CharSequence)clientId)) {
            throw new ELSBootException(I18nUtil.translate("", "clientId \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        String[] clientArray = clientId.split("_");
        if (clientArray.length == 1 || !clientId.contains("App_")) {
            throw new ELSBootException(I18nUtil.translate("", "clientId \u683c\u5f0f\u4e0d\u6b63\u786e\uff01\uff0c\u6b63\u786e\u683c\u5f0f\uff1axxx_App_xxx"));
        }
        String secret = ssoModel.getSecret();
        if (StrUtil.isBlank((CharSequence)secret)) {
            throw new ELSBootException(I18nUtil.translate("", "secret \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        String subAccount = ssoModel.getSubAccount();
        if (StrUtil.isBlank((CharSequence)subAccount)) {
            throw new ELSBootException(I18nUtil.translate("", "subAccount \u4e0d\u80fd\u4e3a\u7a7a\uff01"));
        }
        String elsAccount = clientArray[0];
        ElsSubAccount account = this.elsSubAccountService.getUserByAccount(clientId);
        if (account == null) {
            throw new ELSBootException(I18nUtil.translate("", "clientId \u4e0d\u5b58\u5728\uff01"));
        }
        String userpassword = PasswordUtil.encrypt(clientId, secret, account.getSalt());
        String syspassword = account.getPassword();
        if (!syspassword.equals(userpassword)) {
            throw new ELSBootException(I18nUtil.translate("", "clientId \u8ba4\u8bc1\u5931\u8d25\uff01"));
        }
        ElsSubAccount elsSubAccount = this.elsSubAccountService.getByAccount(elsAccount, subAccount);
        if (elsSubAccount == null) {
            throw new ELSBootException(I18nUtil.translate("", "subAccount \u4e0d\u5b58\u5728\uff01"));
        }
        JSONObject result = new JSONObject();
        result.put("token", (Object)this.saveToken(elsSubAccount));
        return Result.ok(result);
    }

    private ThirdAccount saveThirdUser(ThirdLoginModel tlm) {
        ThirdAccount user = new ThirdAccount();
        user.setId(IdWorker.getIdStr());
        user.setDeleted(CommonConstant.DEL_FLAG_0);
        user.setStatus(1);
        user.setThirdType(tlm.getSource());
        user.setAvatar(tlm.getAvatar());
        user.setRealname(tlm.getUsername());
        user.setThirdUserUuid(tlm.getUuid());
        this.thirdAccountService.save(user);
        return user;
    }

    private String saveToken(ElsSubAccount account) {
        String token = JwtUtil.sign(account.getElsAccount() + "_" + account.getSubAccount(), account.getPassword());
        this.redisUtil.set("sys:token:" + token, token);
        this.redisUtil.expire("sys:token:" + token, 1800L);
        return token;
    }
}

