/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.util.Assert;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.I18n;
import com.els.modules.system.mapper.I18nMapper;
import com.els.modules.system.service.I18nService;
import com.els.modules.system.util.I18nUtil;
import com.hankcs.hanlp.HanLP;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class I18nServiceImpl
extends ServiceImpl<I18nMapper, I18n>
implements I18nService {
    @Value(value="${translate.clearI18nCache_elsAccounts}")
    private String clearI18nCache_elsAccounts;
    @Value(value="${translate.i18nInit}")
    private String i18nInit;
    @Value(value="${translate.i18nIgnore}")
    private String i18nIgnore;
    private static final String createUser = "tangtaotao";
    private static final String chinessSimpleQQT = "zh";
    private static final String chinessComplexQQT = "cht";
    private Map<String, Map<String, String>> mutiLanguageCacheMap = new ConcurrentHashMap<String, Map<String, String>>();
    private Map<String, Map<String, String>> elsCacheMap = new ConcurrentHashMap<String, Map<String, String>>();
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private I18nMapper i18nMapper;
    private static final String I18N_KEY = "sys:i18n:";
    private static final String COLON = ":";

    @Override
    public IPage<I18n> finPagelist(I18n i18n) {
        List<I18n> list = ((I18nMapper)this.baseMapper).findPageList(i18n);
        int count = ((I18nMapper)this.baseMapper).findPageListCount(i18n);
        Page page = new Page((long)i18n.getFromIndex().intValue(), (long)i18n.getPageSize().intValue());
        page.setRecords(list);
        page.setSize((long)count);
        page.setTotal((long)count);
        return page;
    }

    @Override
    public JSONObject findAllList(I18n i18n) {
        StringBuilder redisKey = new StringBuilder(I18N_KEY);
        redisKey.append(i18n.getElsAccount());
        redisKey.append(COLON);
        redisKey.append(i18n.getLanguage());
        JSONObject i18nJson = (JSONObject)this.redisUtil.get(redisKey.toString());
        if (i18nJson != null) {
            return i18nJson;
        }
        i18n.setFromIndex(0);
        i18n.setPageSize(Integer.MAX_VALUE);
        List<I18n> list = ((I18nMapper)this.baseMapper).findPageList(i18n);
        i18nJson = new JSONObject();
        for (I18n o : list) {
            i18nJson.put(i18n.getElsAccount() + "#" + o.getI18nKey(), (Object)o.getI18nValue());
        }
        this.redisUtil.set(redisKey.toString(), i18nJson, 3600L);
        return i18nJson;
    }

    @Override
    public String getI18nValue(String i18nKey, String defaultValue) {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = chinessSimpleQQT;
        }
        I18n i18n = new I18n();
        i18n.setElsAccount(TenantContext.getTenant());
        i18n.setLanguage(language);
        JSONObject i18nJson = this.findAllList(i18n);
        if (i18nJson == null) {
            return defaultValue;
        }
        if (i18nJson.containsKey((Object)(TenantContext.getTenant() + "#" + i18nKey))) {
            return i18nJson.getString(TenantContext.getTenant() + "#" + i18nKey);
        }
        return defaultValue;
    }

    @Override
    public void delRedisData() {
        this.redisUtil.dels(I18N_KEY);
    }

    @Override
    public void i18nTranslate() {
        if (this.i18nInitCheck()) {
            String elsAccount = TenantContext.getTenant();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        I18nServiceImpl.this.elsAppNameInit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        I18nServiceImpl.this.tableColumnKeyInit();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        I18nServiceImpl.this.i18nTranslateValueIsEmpty();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        I18nServiceImpl.this.translateMutiThread();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    I18nServiceImpl.this.clearI18nRedis();
                }
            }).start();
        }
    }

    private synchronized void putMutiLanguageCacheMap(List<I18n> i18nVOS, String language) {
        if (i18nVOS == null || i18nVOS.size() < 1) {
            return;
        }
        Map<String, String> cacheMap = this.mutiLanguageCacheMap.get(language);
        if (cacheMap == null) {
            cacheMap = new HashMap<String, String>();
        } else {
            cacheMap.clear();
        }
        Object cachekey = null;
        for (I18n i18nVO1 : i18nVOS) {
            cacheMap.put((String)cachekey, "");
        }
        this.mutiLanguageCacheMap.put(language, cacheMap);
    }

    @Override
    public void clearI18nRedis() {
        String[] enableClearElsAccounts = this.clearI18nCache_elsAccounts.split(",");
        boolean enableTag = false;
        String elsaccount = TenantContext.getTenant();
        for (String enableElsAccount : enableClearElsAccounts) {
            if (!enableElsAccount.equals(elsaccount)) continue;
            enableTag = true;
            break;
        }
        if (enableTag = true) {
            String language = "";
            this.elsCacheMap.clear();
            if (this.mutiLanguageCacheMap.get(language) != null) {
                this.mutiLanguageCacheMap.get(language).clear();
            }
            new Thread(new I18nCacheLoad(language)).start();
        } else {
            Assert.msgThrow("");
        }
    }

    private synchronized void i18nTranslateValueIsEmpty() {
    }

    private boolean i18nInitCheck() {
        return "true".equals(this.i18nInit) && !"true".equals(this.i18nIgnore);
    }

    private void elsAppNameInit() {
    }

    private void tableColumnKeyInit() {
    }

    private synchronized void translateMutiThread() {
    }

    @Transactional
    public void translateAndUpdate(String key, String value) {
    }

    private I18n findChinessVo(List<I18n> list) {
        if (list == null && list.size() < 1) {
            return null;
        }
        for (I18n i18nVO : list) {
            if (!chinessSimpleQQT.equals(i18nVO.getLanguage())) continue;
            return i18nVO;
        }
        return null;
    }

    private I18n i18nVOGet(String key, String value, String QQTlanguage, String toLanguage, String createUser) {
        return new I18n();
    }

    private I18n i18nVOGet(String key, String value, String toLanguage, String createUser) {
        I18n i18nVO = new I18n();
        i18nVO.setLanguage(toLanguage);
        return i18nVO;
    }

    private String languageStrFilter(String languageStr) {
        char[] languageStrChars = languageStr.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (char c : languageStrChars) {
            if ('\"' == c) {
                stringBuffer.append("&quot;");
                continue;
            }
            if ('&' == c) {
                stringBuffer.append("&amp;");
                continue;
            }
            if ('<' == c) {
                stringBuffer.append("&lt;");
                continue;
            }
            if ('>' == c) {
                stringBuffer.append("&gt;");
                continue;
            }
            if ('\'' == c) {
                stringBuffer.append("&acute;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    @Override
    public String createI18nKey(String chinessStr) {
        if (StringUtils.isBlank((CharSequence)chinessStr)) {
            return "value \u4e0d\u80fd\u4e3a\u7a7a";
        }
        int keyHashCode = chinessStr.hashCode();
        String key_temp = "i18n_" + HanLP.segment((String)chinessStr) + keyHashCode;
        return key_temp;
    }

    class I18nTranslateThread
    implements Runnable {
        public List<String> list;

        @Override
        public void run() {
            this.translateMutile();
        }

        public I18nTranslateThread() {
        }

        public I18nTranslateThread(List<String> list) {
            this.list = list;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void translateMutile() {
            List<String> list = this.list;
            I18n selectI18n = new I18n();
            List singleKeyAllList = null;
            ArrayList insertList = new ArrayList();
            for (String resourceKey : list) {
                try {
                    singleKeyAllList = ((LambdaQueryChainWrapper)I18nServiceImpl.this.lambdaQuery().eq(I18n::getI18nKey, (Object)resourceKey)).list();
                    I18n chinessI18n = I18nServiceImpl.this.findChinessVo(singleKeyAllList);
                    if (chinessI18n == null) {
                        HashMap<String, String> keyMap = new HashMap<String, String>();
                        keyMap.put("key", resourceKey);
                        I18nServiceImpl.this.i18nMapper.deleteById((Serializable)((Object)""));
                        continue;
                    }
                    boolean languageEqualsTag = false;
                    languageEqualsTag = false;
                    for (I18n i18nVO : singleKeyAllList) {
                        if (!I18nServiceImpl.chinessComplexQQT.equals(i18nVO.getLanguage())) continue;
                        languageEqualsTag = true;
                        break;
                    }
                    if (languageEqualsTag) continue;
                }
                catch (Exception exception) {}
            }
            try {
                if (insertList.size() <= 0) return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class I18nCacheLoad
    implements Runnable {
        private String language;

        public I18nCacheLoad(String language) {
            this.language = language;
        }

        @Override
        public void run() {
            List i18nVOS = ((LambdaQueryChainWrapper)I18nServiceImpl.this.lambdaQuery().eq(I18n::getLanguage, (Object)this.language)).list();
            I18nServiceImpl.this.putMutiLanguageCacheMap(i18nVOS, this.language);
        }
    }
}

