/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import cn.hutool.core.util.StrUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.system.service.I18nService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class I18nUtil {
    private static Pattern pattern = Pattern.compile("\\$\\{([^}]+)}");
    private static ThreadLocal<String> currentLanguage = new ThreadLocal();

    public static String getCurrentLanguage() {
        return currentLanguage.get();
    }

    public static void setCurrentLanguage(String language) {
        currentLanguage.set(language);
    }

    public static void clear() {
        currentLanguage.remove();
    }

    public static String translate(String i18nKey, String defaultValue) {
        if (StrUtil.isBlank((CharSequence)i18nKey)) {
            return defaultValue;
        }
        I18nService i18nService = SpringContextUtils.getBean(I18nService.class);
        return i18nService.getI18nValue(i18nKey, defaultValue);
    }

    public static String translate(String i18nKey, String defaultValue, String ... params) {
        if (params.length == 0) {
            return I18nUtil.translate(i18nKey, defaultValue);
        }
        if (StrUtil.isBlank((CharSequence)i18nKey)) {
            return I18nUtil.replace(defaultValue, params);
        }
        String i18nValue = I18nUtil.translate(i18nKey, defaultValue);
        return I18nUtil.replace(i18nValue, params);
    }

    private static String replace(String replaceString, String ... params) {
        StringBuffer sb = new StringBuffer();
        Matcher matcher = pattern.matcher(replaceString);
        while (matcher.find()) {
            int index = Integer.parseInt(matcher.group(1));
            matcher.appendReplacement(sb, params[index]);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(I18nUtil.translate("", "\u6211\u662f${2},\u6211\u6700${0},${1}\u54c8\u54c8", "\u5e05", "\u6ca1\u9519", "\u9648\u9f99"));
    }
}

