/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.config.StaticConfig;
import com.els.modules.system.entity.ElsSubAccount;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanCopier;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;

public class SysUtil {
    private static final Map<String, BeanCopier> BEAN_COPIER_CACHE = new ConcurrentHashMap<String, BeanCopier>();
    private static final String AUDIT_PASS_URL = "/els/elsUflo/audit/completeByOut";
    private static final String AUDIT_REJECT_URL = "/els/elsUflo/audit/rejectByOut";
    private static IdentifierGenerator identifierGenerator = new DefaultIdentifierGenerator();

    public static void setSysParam(BaseEntity target, BaseEntity source) {
        target.setElsAccount(source.getElsAccount());
        if (StringUtils.isBlank((CharSequence)target.getCreateBy())) {
            target.setCreateBy(source.getCreateBy() == null ? "els" : source.getCreateBy());
        }
        if (target.getCreateTime() == null) {
            target.setCreateTime(source.getCreateTime() == null ? new Date() : source.getCreateTime());
        }
        target.setUpdateBy(source.getUpdateBy() == null ? "els" : source.getUpdateBy());
        target.setUpdateTime(source.getUpdateTime() == null ? new Date() : source.getUpdateTime());
        target.setDeleted(CommonConstant.DEL_FLAG_0);
    }

    public static String getUserRealName() {
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        return loginUser.getSubAccount() + "_" + loginUser.getRealname();
    }

    public static LoginUser getLoginUser() {
        return (LoginUser)SecurityUtils.getSubject().getPrincipal();
    }

    public static void setNullCreate(BaseEntity entity) {
        entity.setCreateBy(null);
        entity.setCreateTime(null);
    }

    public static void copyProperties(Object source, Object target) {
        BeanCopier beanCopier;
        String key = SysUtil.getKey(source.getClass(), target.getClass());
        if (BEAN_COPIER_CACHE.containsKey(key)) {
            beanCopier = BEAN_COPIER_CACHE.get(key);
        } else {
            beanCopier = BeanCopier.create(source.getClass(), target.getClass(), (boolean)false);
            BEAN_COPIER_CACHE.put(key, beanCopier);
        }
        beanCopier.copy(source, target, null);
    }

    private static String getKey(Class<?> srcClass, Class<?> tarClass) {
        return srcClass.getName() + "_" + tarClass.getName();
    }

    public static int minuteToSecond(BigDecimal minute, int scale) {
        if (minute != null) {
            return minute.setScale(scale, 4).multiply(BigDecimal.valueOf(60L)).intValue();
        }
        return 0;
    }

    public static String getUrlParamByJson(JSONObject json) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry entry : json.entrySet()) {
            if (result.length() == 0) {
                result.append((String)entry.getKey()).append("=").append(entry.getValue());
                continue;
            }
            result.append("&").append((String)entry.getKey()).append("=").append(entry.getValue());
        }
        return result.toString();
    }

    public static JSONObject getWxFormatParam(Object object) {
        HashMap paramsMap = new HashMap();
        BeanUtil.copyProperties((Object)object, paramsMap, (String[])new String[0]);
        JSONObject result = new JSONObject();
        for (String key : paramsMap.keySet()) {
            JSONObject item = new JSONObject();
            item.put("color", (Object)"#173177");
            Object obj = paramsMap.get(key);
            if (obj == null) continue;
            if (obj instanceof Date) {
                String value = DateUtil.formatDateTime((Date)((Date)obj));
                if (value.contains("00:00:00")) {
                    value = value.substring(0, 10);
                }
                item.put("value", (Object)value);
            } else {
                item.put("value", obj);
            }
            result.put(key, (Object)item);
        }
        return result;
    }

    public static JSONObject objectToJSON(Object object) {
        HashMap paramsMap = new HashMap();
        BeanUtil.copyProperties((Object)object, paramsMap, (String[])new String[0]);
        JSONObject result = new JSONObject();
        for (String key : paramsMap.keySet()) {
            Object obj = paramsMap.get(key);
            if (obj == null) continue;
            if (obj instanceof Date) {
                String value = DateUtil.formatDateTime((Date)((Date)obj));
                if (value.contains("00:00:00")) {
                    value = value.substring(0, 10);
                }
                result.put(key, (Object)value);
                continue;
            }
            result.put(key, obj);
        }
        return result;
    }

    public static String getOutAuditPassUrl(ElsSubAccount elsSubAccount, String processRootId, String businessType, String businessId) {
        return SysUtil.getAuditUrl(AUDIT_PASS_URL, elsSubAccount, processRootId, businessType, businessId);
    }

    public static String getOutAuditRejectUrl(ElsSubAccount elsSubAccount, String processRootId, String businessType, String businessId) {
        return SysUtil.getAuditUrl(AUDIT_REJECT_URL, elsSubAccount, processRootId, businessType, businessId);
    }

    private static String getAuditUrl(String optUrl, ElsSubAccount elsSubAccount, String processRootId, String businessType, String businessId) {
        String token = JwtUtil.getOutToken(elsSubAccount.getElsAccount() + "_" + elsSubAccount.getSubAccount(), elsSubAccount.getPassword());
        StringBuilder url = new StringBuilder(StaticConfig.staticMap.get("serviceAddress"));
        url.append(optUrl).append("?token=").append(token).append("&rootProcessInstanceId=").append(processRootId).append("&businessId=").append(businessId).append("&businessType=").append(businessType);
        return url.toString();
    }

    public static String getAssignId(Object obj) {
        return identifierGenerator.nextId(obj == null ? new Object() : obj).toString();
    }
}

