/*
 * Decompiled with CFR 0.152.
 */
package com.els.common.util.encryption;

import com.els.common.exception.ELSBootException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtil {
    private static final String DEFAULT_CHARSET = "utf-8";
    private static String ALGORITHM = "AES";
    private static final String CipherMode = "AES/ECB/PKCS5Padding";
    private static final Logger logger = LoggerFactory.getLogger(AESUtil.class);

    private AESUtil() {
    }

    public static String decrypt(String sSrc, String secretKey) {
        if (secretKey == null) {
            logger.error("\u9700\u8981\u52a0\u5bc6\u7684\u79d8\u94a5\u4e3a\u7a7a");
            return null;
        }
        try {
            byte[] raw = secretKey.getBytes(DEFAULT_CHARSET);
            SecretKeySpec secretKeySpec = new SecretKeySpec(raw, ALGORITHM);
            Cipher cipher = Cipher.getInstance(CipherMode);
            cipher.init(2, secretKeySpec);
            byte[] encryptedArr = Base64.getDecoder().decode(sSrc);
            byte[] original = cipher.doFinal(encryptedArr);
            return new String(original, DEFAULT_CHARSET);
        }
        catch (Exception ex) {
            logger.error("AES\u89e3\u5bc6\u5931\u8d25", (Throwable)ex);
            return null;
        }
    }

    public static String encrypt(String sSrc, String sKey) {
        if (sKey == null) {
            logger.error("\u9700\u8981\u52a0\u5bc6\u7684\u79d8\u94a5\u4e3a\u7a7a");
            return null;
        }
        try {
            byte[] raw = sKey.getBytes(DEFAULT_CHARSET);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, ALGORITHM);
            Cipher cipher = Cipher.getInstance(CipherMode);
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(sSrc.getBytes(DEFAULT_CHARSET));
            return Base64.getEncoder().encodeToString(encrypted);
        }
        catch (Exception ex) {
            logger.error("AES\u52a0\u5bc6\u5931\u8d25", (Throwable)ex);
            return null;
        }
    }

    public static byte[] decryptForByte(byte[] content, String password) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.setSeed(password.getBytes("UTF-8"));
            kgen.init(128, random);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, key);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new ELSBootException(e.getMessage());
        }
        catch (NoSuchPaddingException e) {
            throw new ELSBootException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new ELSBootException(e.getMessage());
        }
        catch (IllegalBlockSizeException e) {
            throw new ELSBootException(e.getMessage());
        }
        catch (BadPaddingException e) {
            throw new ELSBootException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new ELSBootException(e.getMessage());
        }
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

