/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.codegenerate.generate.impl;

import com.els.framework.codegenerate.config.ResourceConfig;
import com.els.framework.codegenerate.database.DbReadTableUtil;
import com.els.framework.codegenerate.generate.IGenerate;
import com.els.framework.codegenerate.generate.impl.framework.FrameworkFileUtil;
import com.els.framework.codegenerate.generate.pojo.ColumnVo;
import com.els.framework.codegenerate.generate.pojo.TableVo;
import com.els.framework.codegenerate.generate.template.TemplateFileConfig;
import com.els.framework.codegenerate.generate.util.NonceUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenerateOne
extends FrameworkFileUtil
implements IGenerate {
    private static final Logger logger = LoggerFactory.getLogger(CodeGenerateOne.class);
    private TableVo tableVo;
    private List<ColumnVo> columns;
    private List<ColumnVo> originalColumns;

    public CodeGenerateOne(TableVo tableVo) {
        this.tableVo = tableVo;
    }

    public CodeGenerateOne(TableVo tableVo, List<ColumnVo> columns, List<ColumnVo> originalColumns) {
        this.tableVo = tableVo;
        this.columns = columns;
        this.originalColumns = originalColumns;
    }

    @Override
    public Map<String, Object> configMap() throws Exception {
        HashMap<String, Object> localHashMap = new HashMap<String, Object>();
        localHashMap.put("bussiPackage", ResourceConfig.basePackage);
        localHashMap.put("entityPackage", this.tableVo.getEntityPackage());
        localHashMap.put("entityName", this.tableVo.getEntityName());
        localHashMap.put("tableName", this.tableVo.getTableName());
        localHashMap.put("primaryKeyField", ResourceConfig.dbTableId);
        if (this.tableVo.getFieldRequiredNum() == null) {
            this.tableVo.setFieldRequiredNum(StringUtils.isNotEmpty((String)ResourceConfig.FieldRequiredNum) ? Integer.parseInt(ResourceConfig.FieldRequiredNum) : -1);
        }
        if (this.tableVo.getSearchFieldNum() == null) {
            this.tableVo.setSearchFieldNum(StringUtils.isNotEmpty((String)ResourceConfig.pageSearchFieldNum) ? Integer.parseInt(ResourceConfig.pageSearchFieldNum) : -1);
        }
        if (this.tableVo.getFieldRowNum() == null) {
            this.tableVo.setFieldRowNum(Integer.parseInt(ResourceConfig.FieldRowNum));
        }
        localHashMap.put("tableVo", this.tableVo);
        if (this.columns == null || this.columns.size() == 0) {
            this.columns = DbReadTableUtil.queryTableColumns(this.tableVo.getTableName());
        }
        localHashMap.put("columns", this.columns);
        if (this.originalColumns == null || this.originalColumns.size() == 0) {
            this.originalColumns = DbReadTableUtil.getTableFields(this.tableVo.getTableName());
        }
        localHashMap.put("originalColumns", this.originalColumns);
        for (ColumnVo localColumnVo : this.originalColumns) {
            if (!localColumnVo.getFieldName().toLowerCase().equals(ResourceConfig.dbTableId.toLowerCase())) continue;
            localHashMap.put("primaryKeyPolicy", localColumnVo.getFieldType());
        }
        long l = NonceUtils.randomNextLong() + NonceUtils.currentTime();
        localHashMap.put("serialVersionUID", String.valueOf(l));
        logger.info("code template data: " + localHashMap.toString());
        return localHashMap;
    }

    @Override
    public void generateCodeFile() throws Exception {
        logger.info("----els---Code----Generation----[\u5355\u8868\u6a21\u578b:" + this.tableVo.getTableName() + "]------- \u751f\u6210\u4e2d\u3002\u3002\u3002");
        String str1 = ResourceConfig.projectPath;
        Map<String, Object> localMap = this.configMap();
        String str2 = ResourceConfig.templatePath;
        if (CodeGenerateOne.getPathSuffix(str2, "/").equals("els/code-template")) {
            str2 = "/" + CodeGenerateOne.getPathSuffix(str2, "/") + "/one";
        }
        TemplateFileConfig locala = new TemplateFileConfig(str2);
        this.generateFile(locala, str1, localMap);
        logger.info("----els----Code----Generation-----[\u5355\u8868\u6a21\u578b\uff1a" + this.tableVo.getTableName() + "]------ \u751f\u6210\u5b8c\u6210\u3002\u3002\u3002");
    }

    @Override
    public void generateCodeFile(String projectPath, String templatePath) throws Exception {
        if (projectPath != null && !"".equals(projectPath)) {
            ResourceConfig.a(projectPath);
        }
        if (templatePath != null && !"".equals(templatePath)) {
            ResourceConfig.b(templatePath);
        }
        this.generateCodeFile();
    }

    public static void main(String[] args) {
        System.out.println("----els--------- Code------------- Generation -----[\u5355\u8868\u6a21\u578b]------- \u751f\u6210\u4e2d\u3002\u3002\u3002");
        TableVo localTableVo = new TableVo();
        localTableVo.setTableName("demo");
        localTableVo.setPrimaryKeyPolicy("uuid");
        localTableVo.setEntityPackage("test");
        localTableVo.setEntityName("ELSDemo");
        localTableVo.setFtlDescription("els \u6d4b\u8bd5demo");
        try {
            new CodeGenerateOne(localTableVo).generateCodeFile();
        }
        catch (Exception localException) {
            localException.printStackTrace();
        }
        System.out.println("----els--------- Code------------- Generation -----[\u5355\u8868\u6a21\u578b]------- \u751f\u6210\u5b8c\u6210\u3002\u3002\u3002");
    }
}

