/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.codegenerate.generate.impl;

import com.els.framework.codegenerate.config.ResourceConfig;
import com.els.framework.codegenerate.database.DbReadTableUtil;
import com.els.framework.codegenerate.generate.IGenerate;
import com.els.framework.codegenerate.generate.impl.framework.FrameworkFileUtil;
import com.els.framework.codegenerate.generate.pojo.ColumnVo;
import com.els.framework.codegenerate.generate.pojo.onetomany.MainTableVo;
import com.els.framework.codegenerate.generate.pojo.onetomany.SubTableVo;
import com.els.framework.codegenerate.generate.template.TemplateFileConfig;
import com.els.framework.codegenerate.generate.util.NonceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeGenerateOneToMany
extends FrameworkFileUtil
implements IGenerate {
    private static final Logger logger = LoggerFactory.getLogger(CodeGenerateOneToMany.class);
    private MainTableVo mainTableVo;
    private List<ColumnVo> tableColumns;
    private List<ColumnVo> tableFields;
    private List<SubTableVo> subTableVoList;

    public CodeGenerateOneToMany(MainTableVo mainTableVo, List<SubTableVo> subTables) {
        this.subTableVoList = subTables;
        this.mainTableVo = mainTableVo;
    }

    public CodeGenerateOneToMany(MainTableVo mainTableVo, List<ColumnVo> mainColums, List<ColumnVo> originalMainColumns, List<SubTableVo> subTables) {
        this.mainTableVo = mainTableVo;
        this.tableColumns = mainColums;
        this.tableFields = originalMainColumns;
        this.subTableVoList = subTables;
    }

    @Override
    public Map<String, Object> configMap() throws Exception {
        HashMap<String, Object> localHashMap = new HashMap<String, Object>();
        localHashMap.put("bussiPackage", ResourceConfig.basePackage);
        localHashMap.put("entityPackage", this.mainTableVo.getEntityPackage());
        localHashMap.put("entityName", this.mainTableVo.getEntityName());
        localHashMap.put("tableName", this.mainTableVo.getTableName());
        localHashMap.put("ftl_description", this.mainTableVo.getFtlDescription());
        localHashMap.put("primaryKeyField", ResourceConfig.dbTableId);
        localHashMap.put("left", "${");
        localHashMap.put("right", "}");
        if (this.mainTableVo.getFieldRequiredNum() == null) {
            this.mainTableVo.setFieldRequiredNum(4);
        }
        if (this.mainTableVo.getSearchFieldNum() == null) {
            this.mainTableVo.setSearchFieldNum(StringUtils.isNotEmpty((String)ResourceConfig.pageSearchFieldNum) ? Integer.parseInt(ResourceConfig.pageSearchFieldNum) : -1);
        }
        if (this.mainTableVo.getFieldRowNum() == null) {
            this.mainTableVo.setFieldRowNum(1);
        }
        localHashMap.put("tableVo", this.mainTableVo);
        if (this.tableColumns == null || this.tableColumns.size() == 0) {
            this.tableColumns = DbReadTableUtil.queryTableColumns(this.mainTableVo.getTableName());
        }
        if (this.tableFields == null || this.tableFields.size() == 0) {
            this.tableFields = DbReadTableUtil.getTableFields(this.mainTableVo.getTableName());
        }
        localHashMap.put("columns", this.tableColumns);
        localHashMap.put("originalColumns", this.tableFields);
        for (ColumnVo localObject1 : this.tableFields) {
            if (!localObject1.getFieldName().toLowerCase().equals(ResourceConfig.dbTableId.toLowerCase())) continue;
            localHashMap.put("primaryKeyPolicy", localObject1.getFieldType());
        }
        for (SubTableVo localObject1 : this.subTableVoList) {
            String[] localObject2;
            if (localObject1.getColums() == null || localObject1.getColums().size() == 0) {
                localObject2 = DbReadTableUtil.queryTableColumns(localObject1.getTableName());
                localObject1.setColums((List<ColumnVo>)localObject2);
            }
            if (localObject1.getOriginalColumns() == null || localObject1.getOriginalColumns().size() == 0) {
                localObject2 = DbReadTableUtil.getTableFields(localObject1.getTableName());
                localObject1.setOriginalColumns((List<ColumnVo>)localObject2);
            }
            localObject2 = localObject1.getForeignKeys();
            ArrayList<String> localArrayList = new ArrayList<String>();
            for (String str : localObject2) {
                localArrayList.add(DbReadTableUtil.tableColumnName2CodeField(str));
            }
            localObject1.setForeignKeys(localArrayList.toArray(new String[0]));
            localObject1.setOriginalForeignKeys(localObject2);
        }
        localHashMap.put("subTables", this.subTableVoList);
        long l = NonceUtils.randomNextLong() + NonceUtils.currentTime();
        localHashMap.put("serialVersionUID", String.valueOf(l));
        logger.info("code template data: " + localHashMap.toString());
        return localHashMap;
    }

    @Override
    public void generateCodeFile() throws Exception {
        logger.info("----els---Code----Generation----[\u4e00\u5bf9\u591a\u6a21\u578b:" + this.mainTableVo.getTableName() + "]------- \u751f\u6210\u4e2d\u3002\u3002\u3002");
        String str1 = ResourceConfig.projectPath;
        Map<String, Object> localMap = this.configMap();
        String str2 = ResourceConfig.templatePath;
        if (CodeGenerateOneToMany.getPathSuffix(str2, "/").equals("els/code-template")) {
            str2 = "/" + CodeGenerateOneToMany.getPathSuffix(str2, "/") + "/onetomany";
        }
        TemplateFileConfig locala = new TemplateFileConfig(str2);
        this.generateFile(locala, str1, localMap);
        logger.info("----els----Code----Generation-----[\u4e00\u5bf9\u591a\u6a21\u578b\uff1a" + this.mainTableVo.getTableName() + "]------ \u751f\u6210\u5b8c\u6210\u3002\u3002\u3002");
    }

    @Override
    public void generateCodeFile(String projectPath, String templatePath) throws Exception {
        if (projectPath != null && !"".equals(projectPath)) {
            ResourceConfig.a(projectPath);
        }
        if (templatePath != null && !"".equals(templatePath)) {
            ResourceConfig.b(templatePath);
        }
        this.generateCodeFile();
    }
}

