/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.codegenerate.generate.impl.framework;

import com.els.framework.codegenerate.config.ResourceConfig;
import com.els.framework.codegenerate.generate.template.TemplateFileConfig;
import com.els.framework.codegenerate.generate.util.FrameworkUtil;
import com.els.framework.codegenerate.generate.util.GenerateFileUtil;
import freemarker.template.Template;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkFileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FrameworkFileUtil.class);
    protected static String ENCODING = "UTF-8";

    protected void generateFile(TemplateFileConfig parama, String paramString, Map<String, Object> paramMap) throws Exception {
        logger.info("--------generate----projectPath--------" + paramString);
        for (int i = 0; i < parama.getTemplateFileList().size(); ++i) {
            File localFile = parama.getTemplateFileList().get(i);
            this.generate(paramString, localFile, paramMap, parama);
        }
    }

    protected void generate(String paramString, File paramFile, Map<String, Object> paramMap, TemplateFileConfig parama) throws Exception {
        if (paramFile == null) {
            throw new IllegalStateException("'templateRootDir' must be not null");
        }
        logger.debug("-------------------load template from templateRootDir = '" + paramFile.getAbsolutePath() + "' outJavaRootDir:" + new File(ResourceConfig.sourceRootPackage.replace(".", File.separator)).getAbsolutePath() + "' outWebappRootDir:" + new File(ResourceConfig.webRootPackage.replace(".", File.separator)).getAbsolutePath());
        List<File> localList = GenerateFileUtil.sortFile(paramFile);
        logger.debug("----srcFiles----size-----------" + localList.size());
        logger.debug("----srcFiles----list------------" + localList.toString());
        for (int i = 0; i < localList.size(); ++i) {
            File localFile = localList.get(i);
            this.generateToLocal(paramString, paramFile, paramMap, localFile, parama);
        }
    }

    protected void generateToLocal(String paramString, File paramFile1, Map<String, Object> paramMap, File paramFile2, TemplateFileConfig parama) throws Exception {
        logger.debug("-------templateRootDir--" + paramFile1.getPath());
        logger.debug("-------srcFile--" + paramFile2.getPath());
        String templateFileName = GenerateFileUtil.getFileAbsolutePath(paramFile1, paramFile2);
        try {
            logger.debug("-------templateFile--" + templateFileName);
            String outputFilepath = FrameworkFileUtil.getOutputFilepath(paramMap, templateFileName, parama);
            logger.debug("-------outputFilepath--" + outputFilepath);
            if (outputFilepath.startsWith("java")) {
                String str3;
                String str4 = str3 = paramString + File.separator + ResourceConfig.sourceRootPackage.replace(".", File.separator);
                outputFilepath = outputFilepath.substring("java".length());
                outputFilepath = str4 + outputFilepath;
                logger.debug("-------java----outputFilepath--" + outputFilepath);
                this.generateTpl2Local(templateFileName, outputFilepath, paramMap, parama);
            } else if (outputFilepath.startsWith("webapp")) {
                String str3;
                String str4 = str3 = paramString + File.separator + ResourceConfig.webRootPackage.replace(".", File.separator);
                outputFilepath = outputFilepath.substring("webapp".length());
                outputFilepath = str4 + outputFilepath;
                logger.debug("-------webapp---outputFilepath---" + outputFilepath);
                this.generateTpl2Local(templateFileName, outputFilepath, paramMap, parama);
            }
        }
        catch (Exception localException) {
            localException.printStackTrace();
            logger.error(localException.toString());
        }
    }

    protected void generateTpl2Local(String templateFileName, String outputFilepath, Map<String, Object> paramMap, TemplateFileConfig parama) throws Exception {
        if (outputFilepath.endsWith("i")) {
            outputFilepath = outputFilepath.substring(0, outputFilepath.length() - 1);
        }
        Template localTemplate = this.getTemplate(templateFileName, parama);
        localTemplate.setOutputEncoding(ENCODING);
        File localFile = GenerateFileUtil.getFile(outputFilepath);
        logger.debug("[generate]\t template:" + templateFileName + " ==> " + outputFilepath);
        FrameworkUtil.write2TargetFile(localTemplate, paramMap, localFile, ENCODING);
        if (this.isSubTableFile(localFile)) {
            FrameworkFileUtil.write2Local(localFile, "#segment#");
        }
    }

    protected Template getTemplate(String paramString, TemplateFileConfig parama) throws IOException {
        return FrameworkUtil.getConfiguration(parama.getTemplateFileList(), ENCODING, paramString).getTemplate(paramString);
    }

    protected boolean isSubTableFile(File paramFile) {
        return paramFile.getName().startsWith("[1-n]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void write2Local(File paramFile, String subTableFileContentFlag) {
        InputStreamReader localInputStreamReader = null;
        BufferedReader localBufferedReader = null;
        try {
            String readerTmp;
            localInputStreamReader = new InputStreamReader((InputStream)new FileInputStream(paramFile), "UTF-8");
            localBufferedReader = new BufferedReader(localInputStreamReader);
            boolean m = false;
            File templateFile = null;
            while ((readerTmp = localBufferedReader.readLine()) != null) {
                if (readerTmp.trim().length() > 0 && readerTmp.startsWith(subTableFileContentFlag)) {
                    String str2 = readerTmp.substring(subTableFileContentFlag.length());
                    String str3 = paramFile.getParentFile().getAbsolutePath();
                    str2 = str3 + File.separator + str2;
                    logger.debug("[generate]\t split file:" + paramFile.getAbsolutePath() + " ==> " + str2);
                    templateFile = new File(str2);
                    m = true;
                    continue;
                }
                if (!m) continue;
                logger.debug("row : " + readerTmp);
                FileUtils.writeStringToFile(templateFile, (String)(readerTmp + "\r\n"), (boolean)true);
            }
            localBufferedReader.close();
            localInputStreamReader.close();
            logger.debug("[generate]\t delete file:" + paramFile.getAbsolutePath());
            FrameworkFileUtil.deleteFile(paramFile);
        }
        catch (FileNotFoundException localFileNotFoundException) {
            localFileNotFoundException.printStackTrace();
            logger.error("\u6ca1\u627e\u5230\u6a21\u677f\u6587\u4ef6\uff1a", (Throwable)localFileNotFoundException);
        }
        catch (IOException localIOException3) {
            localIOException3.printStackTrace();
            logger.error("\u6587\u4ef6\u6d41\u51fa\u6765\u51fa\u9519\uff1a", (Throwable)localIOException3);
        }
        finally {
            try {
                if (localBufferedReader != null) {
                    localBufferedReader.close();
                }
                if (localInputStreamReader != null) {
                    localInputStreamReader.close();
                }
            }
            catch (IOException localIOException5) {
                localIOException5.printStackTrace();
                logger.error("\u6587\u4ef6\u6d41\u51fa\u6765\u51fa\u9519\uff1a", (Throwable)localIOException5);
            }
        }
    }

    protected static String getOutputFilepath(Map<String, Object> paramMap, String templateFileName, TemplateFileConfig parama) throws Exception {
        Object localObject1;
        String str1 = templateFileName;
        int i = -1;
        i = templateFileName.indexOf(64);
        if (i != -1) {
            str1 = templateFileName.substring(0, i);
            localObject1 = templateFileName.substring(i + 1);
            Object localObject2 = paramMap.get(localObject1);
            if (localObject2 == null) {
                System.err.println("[not-generate] WARN: test expression is null by key:[" + (String)localObject1 + "] on template:[" + templateFileName + "]");
                return null;
            }
            if (!"true".equals(String.valueOf(localObject2))) {
                logger.error("[not-generate]\t test expression '@" + (String)localObject1 + "' is false,template:" + templateFileName);
                return null;
            }
        }
        localObject1 = FrameworkUtil.getConfiguration(parama.getTemplateFileList(), ENCODING, "/");
        String author = "lanYing";
        if (StringUtils.isNotBlank((String)author)) {
            paramMap.put("author", author);
        } else {
            paramMap.put("author", "");
        }
        str1 = FrameworkUtil.templateFillWithParams(str1, paramMap, localObject1);
        String localObject2 = str1.substring(str1.lastIndexOf("."));
        String str2 = str1.substring(0, str1.lastIndexOf(".")).replace(".", File.separator);
        str1 = str2 + localObject2;
        return str1;
    }

    protected static boolean deleteFile(File paramFile) {
        boolean bool = false;
        int i = 0;
        while (!bool && i++ < 10) {
            System.gc();
            bool = paramFile.delete();
        }
        return bool;
    }

    protected static String getPathSuffix(String templatePath, String suffix) {
        boolean i = true;
        boolean j = true;
        do {
            int k = templatePath.indexOf(suffix) == 0 ? 1 : 0;
            int m = templatePath.lastIndexOf(suffix) + 1 == templatePath.length() ? templatePath.lastIndexOf(suffix) : templatePath.length();
            templatePath = templatePath.substring(k, m);
            i = templatePath.indexOf(suffix) == 0;
            boolean bl = j = templatePath.lastIndexOf(suffix) + 1 == templatePath.length();
        } while (i || j);
        return templatePath;
    }
}

