/*
 * Decompiled with CFR 0.152.
 */
package com.els.framework.codegenerate.generate.util;

import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang.RandomStringUtils;

public class NonceUtils {
    private static final SimpleDateFormat DATE_FULL_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final String[] ZERO_ARRAY = new String[]{"0", "00", "0000", "00000000"};
    private static Date dateFlag;
    private static int NONCE;

    public static String random(int paramInt) {
        return RandomStringUtils.randomAlphanumeric((int)paramInt);
    }

    public static int random() {
        return new SecureRandom().nextInt();
    }

    public static String hexRandom() {
        return Integer.toHexString(NonceUtils.random());
    }

    public static long randomNextLong() {
        return new SecureRandom().nextLong();
    }

    public static String hexRandomLong() {
        return Long.toHexString(NonceUtils.randomNextLong());
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String dateFullStr() {
        Date localDate = new Date();
        return DATE_FULL_FORMAT.format(localDate);
    }

    public static long currentTime() {
        return System.currentTimeMillis();
    }

    public static String hexCurrentTime() {
        return Long.toHexString(NonceUtils.currentTime());
    }

    public static synchronized String getDateQueue() {
        Date localDate = new Date();
        if (localDate.equals(dateFlag)) {
            ++NONCE;
        } else {
            dateFlag = localDate;
            NONCE = 0;
        }
        return Integer.toHexString(NONCE);
    }

    public static String fillWith0(String paramString, int paramInt) {
        int i;
        StringBuilder localStringBuilder = new StringBuilder();
        for (i = paramInt - paramString.length(); i >= 8; i -= 8) {
            localStringBuilder.append(ZERO_ARRAY[3]);
        }
        for (int j = 2; j >= 0; --j) {
            if ((i & 1 << j) == 0) continue;
            localStringBuilder.append(ZERO_ARRAY[j]);
        }
        localStringBuilder.append(paramString);
        return localStringBuilder.toString();
    }

    static {
        NONCE = 0;
    }
}

