/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integration.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.SpringContextUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.integration.service.OpenApiService;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.template.entity.TemplateConfigHead;
import com.els.modules.template.entity.TemplateConfigItem;
import com.els.modules.template.entity.TemplateHead;
import com.els.modules.template.service.TemplateConfigHeadService;
import com.els.modules.template.service.TemplateConfigItemService;
import com.els.modules.template.service.TemplateHeadService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractOpenApiService
implements OpenApiService {
    protected static final String HEAD_LIST = "headList";
    protected static final String ITEM_LIST = "itemList";

    protected TemplateHeadService getTemplateHeadService() {
        return SpringContextUtils.getBean(TemplateHeadService.class);
    }

    protected TemplateConfigHeadService getTemplateConfigHeadService() {
        return SpringContextUtils.getBean(TemplateConfigHeadService.class);
    }

    protected TemplateConfigItemService getTemplateConfigItemService() {
        return SpringContextUtils.getBean(TemplateConfigItemService.class);
    }

    protected TemplateHead getTemplateHead() {
        String elsAccount = TenantContext.getTenant();
        if (CharSequenceUtil.isBlank((CharSequence)elsAccount)) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_jDUiLVW_d90dbede", "\u7528\u6237\u51ed\u8bc1\u4e3a\u7a7a\uff01"));
        }
        List<TemplateHead> list = this.getTemplateHeadService().getAllByAccountAndType(elsAccount, this.getBusinessType());
        if (list.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_empty_businessTemplate", "\u672a\u914d\u7f6e\u4e1a\u52a1\u6a21\u677f\uff01\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458"));
        }
        return list.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public JSONObject invoke(JSONObject param) {
        TemplateHead templateHead = this.getTemplateHead();
        List<TemplateConfigHead> configHeadList = this.getTemplateConfigHeadService().selectByMainId(templateHead.getId());
        List<TemplateConfigItem> configItemList = this.getTemplateConfigItemService().selectByMainId(templateHead.getId());
        JSONArray array = param.getJSONArray(HEAD_LIST);
        if (null == array || array.isEmpty()) {
            throw new ELSBootException(I18nUtil.translate("i18n_alert_yVWWWWWsWsWWWWWWWWsWxOLV_f20bd04c", "\u63a5\u53e3param\u53c2\u6570\u4e2dheadList\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        HashMap<String, String> defaultHeadMap = new HashMap<String, String>();
        for (TemplateConfigHead configHead : configHeadList) {
            if (!CharSequenceUtil.isNotBlank((CharSequence)configHead.getDefaultValue())) continue;
            defaultHeadMap.put(configHead.getFieldName(), configHead.getDefaultValue());
        }
        HashMap<String, String> defaultItemMap = new HashMap<String, String>();
        for (TemplateConfigItem configItem : configItemList) {
            if (!CharSequenceUtil.isNotBlank((CharSequence)configItem.getDefaultValue())) continue;
            defaultItemMap.put(configItem.getFieldName(), configItem.getDefaultValue());
        }
        this.commonParamCheck(array, templateHead, defaultHeadMap, defaultItemMap, configHeadList, configItemList);
        return this.doCreateInvoke(array, templateHead, defaultHeadMap, defaultItemMap);
    }

    private void commonParamCheck(JSONArray array, TemplateHead templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHead> configHeadList, List<TemplateConfigItem> configItemList) {
        List<String> headRequiredFieldList = configHeadList.stream().filter(x -> "1".equals(x.getRequired())).map(TemplateConfigHead::getFieldName).collect(Collectors.toList());
        List<String> itemRequiredFieldList = configItemList.stream().filter(x -> "1".equals(x.getRequired())).map(TemplateConfigItem::getFieldName).collect(Collectors.toList());
        headRequiredFieldList.removeAll(defaultHeadMap.keySet());
        itemRequiredFieldList.removeAll(defaultItemMap.keySet());
        if (CollUtil.isNotEmpty(headRequiredFieldList)) {
            for (int index = 0; index < array.size(); ++index) {
                JSONObject head = (JSONObject)Convert.convert(JSONObject.class, (Object)array.get(index));
                if (null == head || head.size() == 0) continue;
                this.containAndHaveValueCheck(headRequiredFieldList, head, index, 0, HEAD_LIST);
                this.checkItemRequiredParam(head, itemRequiredFieldList, index);
            }
        } else {
            for (int index = 0; index < array.size(); ++index) {
                JSONObject head = (JSONObject)Convert.convert(JSONObject.class, (Object)array.get(index));
                if (null == head || head.size() == 0) continue;
                this.checkItemRequiredParam(head, itemRequiredFieldList, index);
            }
        }
        this.doParamCheck(array, templateHead, defaultHeadMap, defaultItemMap, configHeadList, configItemList);
    }

    private void checkItemRequiredParam(JSONObject head, List<String> itemRequiredFieldList, int headIndex) {
        if (CollUtil.isEmpty(itemRequiredFieldList)) {
            return;
        }
        if (!head.containsKey((Object)ITEM_LIST)) {
            return;
        }
        JSONArray arrayParam = head.getJSONArray(ITEM_LIST);
        if (null == arrayParam || arrayParam.isEmpty()) {
            return;
        }
        for (int itemIndex = 0; itemIndex < arrayParam.size(); ++itemIndex) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, (Object)arrayParam.get(itemIndex));
            this.containAndHaveValueCheck(itemRequiredFieldList, object, headIndex, itemIndex, ITEM_LIST);
        }
    }

    private void containAndHaveValueCheck(List<String> requiredFieldNameList, JSONObject object, int headIndex, int itemIndex, String paramItem) {
        for (String fieldName : requiredFieldNameList) {
            String string = paramItem = ITEM_LIST.equals(paramItem) ? String.format("headList[%s].itemList[%s]", headIndex + 1, itemIndex + 1) : String.format("headList[%s]", headIndex + 1);
            if (!object.containsKey((Object)fieldName)) {
                throw new ELSBootException(I18nUtil.translate("i18n_alert_sWWWRRlSJOsWJOWWW_667f6fa5", String.format("\u53c2\u6570%s\u7f3a\u5c11\u5fc5\u586b\u5b57\u6bb5\u53c2\u6570\u5b57\u6bb5:%s", paramItem, fieldName)));
            }
            Object fieldValue = object.get((Object)fieldName);
            boolean flag = null == fieldValue || fieldValue instanceof String && CharSequenceUtil.isBlank((CharSequence)((String)fieldValue));
            if (!flag) continue;
            throw new ELSBootException(I18nUtil.translate("i18n_alert_sWWWJOWWWRxOLV_2e48863e", String.format("\u53c2\u6570${0}\u5b57\u6bb5:${1}\u503c\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]), paramItem), fieldName);
        }
    }

    protected void doParamCheck(JSONArray array, TemplateHead templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHead> configHeadList, List<TemplateConfigItem> configItemList) {
    }

    protected abstract JSONObject doCreateInvoke(JSONArray var1, TemplateHead var2, Map<String, String> var3, Map<String, String> var4);

    protected abstract String getBusinessType();
}

