/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integration.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.util.RedisUtil;
import com.els.modules.integration.service.CallInterfaceService;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="interface", name={"appId"})
public class CallInterfaceServiceImpl
implements CallInterfaceService {
    private Logger logger = LoggerFactory.getLogger(CallInterfaceServiceImpl.class);
    @Value(value="${interface.url}")
    private String url;
    @Value(value="${interface.tokenUrl}")
    private String tokenUrl;
    @Value(value="${interface.elsAccount}")
    private String elsAccount;
    @Value(value="${interface.appId}")
    private String appId;
    @Value(value="${interface.appSerect}")
    private String appSerect;
    @Value(value="${interface.tianyan.common-url}")
    private String tianYan_common_url;
    @Value(value="${interface.tianyan.token-url}")
    private String tianYan_common_tokenUrl;
    @Value(value="${interface.esign.common-url}")
    private String esign_common_url;
    @Value(value="${interface.esign.token-url}")
    private String esign_common_tokenUrl;
    @Autowired
    private RedisUtil redisUtil;
    private static final String INTERFACE_TOKEN = "INTERFACE_TOKEN";
    private static final String INTERFACE_START_TIME = "INTERFACE_START_TIME";
    private static final String EFFECT_TIME = "EFFECT_TIME";
    private static final String TOKEN_SUCCESS = "200";
    private static final String SUCCES = "S";
    private static final String ESIGN_SUCCESS = "0";

    @Override
    public String getToken(String account, String link, String id, String serect) {
        return this.refuashToken(account, link, id, serect);
    }

    public String refuashToken(String account, String link, String id, String serect) {
        String url = null;
        url = link.endsWith("/") ? link + account + "/" + id + "/" + serect : link + "/" + account + "/" + id + "/" + serect;
        try {
            String reponse = HttpRequest.get((String)url).execute().body();
            JSONObject jsonObject = JSONObject.parseObject((String)reponse);
            if (TOKEN_SUCCESS.equals(jsonObject.getString("statusCode"))) {
                this.redisUtil.set(INTERFACE_TOKEN, jsonObject.getString("accessToken"));
                this.redisUtil.set(INTERFACE_START_TIME, jsonObject.get((Object)"startTime"));
                this.redisUtil.set(EFFECT_TIME, jsonObject.getString("expires"));
                return jsonObject.getString("accessToken");
            }
            this.logger.error("token\u83b7\u53d6\u5931\u8d25\uff1a" + jsonObject.getString("message"));
        }
        catch (Exception e) {
            this.logger.error("token\u83b7\u53d6\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a", (Throwable)e);
        }
        return null;
    }

    @Override
    public Result<?> callInterfacePost(String interfaceCode, JSONObject realbody) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("elsAccount", this.elsAccount);
        headers.put("subAccount", this.appId);
        headers.put("pwd", this.appSerect);
        headers.put("Content-Type", "application/json");
        JSONObject request = new JSONObject();
        request.put("elsAccount", (Object)this.elsAccount);
        request.put("service", (Object)"valueAddedApplication");
        request.put("interfaceCode", (Object)interfaceCode);
        request.put("data", (Object)realbody);
        try {
            String reponse = ((HttpRequest)HttpRequest.post((String)this.url).addHeaders(headers)).body(request.toString()).execute().body();
            JSONObject jsonObject = JSONObject.parseObject((String)reponse);
            if (TOKEN_SUCCESS.equals(jsonObject.getString("code"))) {
                if (jsonObject.getString("result") != null) {
                    return Result.ok(jsonObject.toJSONString());
                }
                return Result.ok(jsonObject.toJSONString());
            }
            return Result.error(jsonObject.toJSONString());
        }
        catch (Exception e) {
            this.logger.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Throwable)e);
            return Result.error(e.getMessage());
        }
    }

    @Override
    public Result<?> callTianYanCommonPost(JSONObject object, String consumAccount, String projectId, String projectKey, String consumSubAccount, String appId, String appSerect) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("elsAccount", consumAccount);
        headers.put("accessToken", this.getToken(consumAccount, this.tianYan_common_tokenUrl, appId, appSerect));
        headers.put("projectId", projectId);
        headers.put("projectKey", projectKey);
        headers.put("subAccount", consumSubAccount);
        try {
            String reponse = ((HttpRequest)HttpRequest.post((String)this.tianYan_common_url).addHeaders(headers)).body(object.toString()).execute().body();
            JSONObject jsonObject = JSONObject.parseObject((String)reponse);
            if (TOKEN_SUCCESS.equals(jsonObject.getString("code"))) {
                if (StringUtils.isNotBlank((String)jsonObject.getString("data"))) {
                    return Result.ok(jsonObject.getString("data"));
                }
                return Result.ok(jsonObject.getString("datas"));
            }
            return Result.error(jsonObject.getString("message"));
        }
        catch (Exception e) {
            this.logger.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Throwable)e);
            return Result.error(e.getMessage());
        }
    }

    @Override
    public Result<?> callEsignCommonPost(String interfaceCode, JSONObject object, String consumAccount, String consumSubAccount, String appId, String appSerect) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("elsAccount", consumAccount);
        headers.put("accessToken", this.getToken(consumAccount, this.esign_common_tokenUrl, appId, appSerect));
        headers.put("subAccount", consumSubAccount);
        JSONObject request = new JSONObject();
        request.put("elsAccount", (Object)consumAccount);
        request.put("businessType", (Object)interfaceCode);
        request.put("data", (Object)object.toString());
        try {
            String reponse = ((HttpRequest)HttpRequest.post((String)this.esign_common_url).addHeaders(headers)).body(request.toString()).execute().body();
            JSONObject jsonObject = JSONObject.parseObject((String)reponse);
            if (SUCCES.equals(jsonObject.getString("status"))) {
                JSONObject returnData = JSONObject.parseObject((String)jsonObject.getString("data"));
                if (ESIGN_SUCCESS.equals(returnData.getString("code"))) {
                    return Result.ok(returnData.getString("data"));
                }
                return Result.error(returnData.getString("message"));
            }
            return Result.error(jsonObject.getString("message"));
        }
        catch (Exception e) {
            this.logger.error("\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Throwable)e);
            return Result.error(e.getMessage());
        }
    }
}

