/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.message.entity.ElsMsgConfigHead;
import com.els.modules.message.entity.ElsMsgConfigItem;
import com.els.modules.message.handle.ISendMsgService;
import com.els.modules.message.handle.enums.ReceiveTypeEnum;
import com.els.modules.message.handle.enums.SendMsgTypeEnum;
import com.els.modules.message.service.ElsMsgConfigHeadService;
import com.els.modules.message.service.ElsMsgConfigItemService;
import com.els.modules.message.service.MsgService;
import com.els.modules.message.util.MessageHandleFactory;
import com.els.modules.message.vo.MsgParamsVO;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.UserRoleService;
import com.els.modules.system.util.I18nUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class MsgServiceImpl
implements MsgService {
    private static final Logger log = LoggerFactory.getLogger(MsgServiceImpl.class);
    @Autowired
    private ElsMsgConfigHeadService elsMsgConfigHeadService;
    @Autowired
    private ElsMsgConfigItemService elsMsgConfigItemService;
    @Autowired
    private PersonalSettingService personalSettingService;
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private UserRoleService userRoleService;

    @Override
    @Async
    public void sendMsg(List<ElsMsgConfigItem> configItemList, String businessType, String operateType, MsgParamsVO paramsVO) {
        try {
            LoginUser loginUser;
            ElsMsgConfigHead elsMsgConfigHead;
            Map<String, List<ElsSubAccount>> receiverMap = paramsVO.getReceiverMap();
            List<Object> configAccountList = new ArrayList();
            if (!CollectionUtils.isEmpty(configItemList) && (elsMsgConfigHead = (ElsMsgConfigHead)this.elsMsgConfigHeadService.getById((Serializable)((Object)configItemList.get(0).getHeadId()))) != null) {
                configAccountList = this.getReceiverAccountList(elsMsgConfigHead);
            }
            HashMap<String, List<ElsSubAccount>> receiverMapEnd = new HashMap<String, List<ElsSubAccount>>();
            if (!CollectionUtils.isEmpty(configAccountList)) {
                List elsAccountStrList = configAccountList.stream().map(BaseEntity::getElsAccount).collect(Collectors.toList());
                for (String elsAccountStr : elsAccountStrList) {
                    List selectList = configAccountList.stream().filter(p -> elsAccountStr.equals(p.getElsAccount())).collect(Collectors.toList());
                    receiverMapEnd.put(elsAccountStr, selectList);
                }
            }
            if (receiverMapEnd.size() > 0) {
                receiverMap = receiverMapEnd;
            }
            Map<String, JSONObject> receiveParamMap = paramsVO.getReceiveParamMap();
            if (receiverMap == null) {
                return;
            }
            try {
                loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            }
            catch (Exception e) {
                loginUser = new LoginUser();
                loginUser.setElsAccount("system");
                loginUser.setSubAccount("system");
                loginUser.setRealname("system");
            }
            for (String elsAccount : receiverMap.keySet()) {
                List<ElsSubAccount> accountList = receiverMap.get(elsAccount);
                if (CollectionUtils.isEmpty(accountList)) continue;
                for (ElsSubAccount account : accountList) {
                    LambdaQueryWrapper query = new LambdaQueryWrapper();
                    query.eq(PersonalSetting::getElsAccount, (Object)elsAccount);
                    query.eq(PersonalSetting::getSubAccount, (Object)account.getSubAccount());
                    query.eq(PersonalSetting::getIsReceive, (Object)"0");
                    List personalSettings = this.personalSettingService.list((Wrapper)query);
                    List<String> list = this.processData(personalSettings);
                    for (ElsMsgConfigItem item : configItemList) {
                        if (!list.contains(item.getMsgType())) continue;
                        ISendMsgService sendMsgHandle = MessageHandleFactory.getMsgHandle(item.getMsgType());
                        MsgVO msgVO = new MsgVO();
                        msgVO.setElsMsgConfigItem(item);
                        msgVO.setAccount(account);
                        msgVO.setLoginUser(loginUser);
                        msgVO.setParams(paramsVO.getParams());
                        if (receiveParamMap != null && receiveParamMap.containsKey(elsAccount)) {
                            msgVO.setUrlParam(SysUtil.getUrlParamByJson(receiveParamMap.get(elsAccount)));
                        } else {
                            msgVO.setUrlParam(paramsVO.getUrlParam());
                        }
                        msgVO.setBusinessType(businessType);
                        msgVO.setOperateType(operateType);
                        sendMsgHandle.sendMsg(msgVO);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("sendMsg failed:", (Throwable)e);
        }
    }

    protected List<ElsSubAccount> getReceiverAccountList(ElsMsgConfigHead elsMsgConfigHead) {
        String[] userIds;
        ArrayList<ElsSubAccount> list = new ArrayList<ElsSubAccount>();
        if (StrUtil.isNotBlank((CharSequence)elsMsgConfigHead.getPurchaseNoticeUser())) {
            for (String userId : userIds = elsMsgConfigHead.getPurchaseNoticeUser().split(",")) {
                this.addSubAccount(list, userId);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)elsMsgConfigHead.getSaleNoticeUser())) {
            for (String userId : userIds = elsMsgConfigHead.getSaleNoticeUser().split(",")) {
                this.addSubAccount(list, userId);
            }
        }
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        List distinctList = list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ElsSubAccount>(Comparator.comparing(BaseEntity::getId))), ArrayList::new));
        return distinctList;
    }

    private void addSubAccount(List<ElsSubAccount> list, String userId) {
        ElsSubAccount account = (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)userId));
        if (account != null) {
            list.add(account);
        }
    }

    private List<String> processData(List<PersonalSetting> personalSettings) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(SendMsgTypeEnum.IN_MSG.getType());
        for (PersonalSetting personalSetting : personalSettings) {
            if (ReceiveTypeEnum.EMAIL.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.EMAIL.getType());
                continue;
            }
            if (ReceiveTypeEnum.MSG.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.SMS.getType());
                continue;
            }
            if (ReceiveTypeEnum.NEWS.getValue().equals(personalSetting.getReceiveType())) {
                list.add(SendMsgTypeEnum.IN_MSG.getType());
                continue;
            }
            if (!ReceiveTypeEnum.WECHAT.getValue().equals(personalSetting.getReceiveType())) continue;
            list.add(SendMsgTypeEnum.WX.getType());
        }
        return list;
    }

    @Override
    @Async
    public void sendMsg(String purchaseElsAccount, String businessType, String operateType, MsgParamsVO paramsVO) {
        try {
            List<ElsMsgConfigItem> configItemList = this.getMsgConfigItemList(purchaseElsAccount, businessType, operateType);
            if (configItemList.isEmpty()) {
                return;
            }
            this.sendMsg(configItemList, businessType, operateType, paramsVO);
        }
        catch (Exception e) {
            log.error("sendMsg failed:", (Throwable)e);
        }
    }

    private List<ElsMsgConfigItem> getMsgConfigItemList(String purchaseElsAccount, String businessType, String operateType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"business_type", (Object)businessType)).eq((Object)"operate_type", (Object)operateType)).eq((Object)"els_account", (Object)purchaseElsAccount);
        List configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        if (configHeadList.isEmpty()) {
            queryWrapper.clear();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"business_type", (Object)businessType)).eq((Object)"operate_type", (Object)operateType)).eq((Object)"els_account", (Object)"100000");
            configHeadList = this.elsMsgConfigHeadService.list((Wrapper)queryWrapper);
        }
        Assert.notEmpty((Collection)configHeadList, (String)I18nUtil.translate("i18n_alert_LYuXHERW_44d10b7d", "\u672a\u627e\u5230\u6d88\u606f\u914d\u7f6e\uff01"));
        List<ElsMsgConfigItem> configItemList = this.elsMsgConfigItemService.selectByMainId(((ElsMsgConfigHead)configHeadList.get(0)).getId());
        HashMap<String, String> distinctMap = new HashMap<String, String>();
        ArrayList<ElsMsgConfigItem> resultList = new ArrayList<ElsMsgConfigItem>();
        for (ElsMsgConfigItem item : configItemList) {
            if (distinctMap.containsKey(item.getMsgType())) continue;
            resultList.add(item);
            distinctMap.put(item.getMsgType(), item.getMsgType());
        }
        return resultList;
    }
}

