/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.monitor.controller;

import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.modules.monitor.domain.RedisInfo;
import com.els.modules.monitor.service.RedisService;
import java.io.File;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.filechooser.FileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/actuator/redis"})
public class ActuatorRedisController {
    private static final Logger log = LoggerFactory.getLogger(ActuatorRedisController.class);
    @Autowired
    private RedisService redisService;

    @AutoLog(value="Redis-Redis\u8be6\u7ec6\u4fe1\u606f", logType=2, operateType=1)
    @GetMapping(value={"/info"})
    public Result<?> getRedisInfo() throws Exception {
        List<RedisInfo> infoList = this.redisService.getRedisInfo();
        log.info(infoList.toString());
        return Result.ok(infoList);
    }

    @AutoLog(value="Redis-\u67e5\u8be2\u7f13\u5b58\u952e\u503c\u6570\u91cf", logType=2, operateType=1)
    @GetMapping(value={"/keysSize"})
    public Map<String, Object> getKeysSize() throws Exception {
        return this.redisService.getKeysSize();
    }

    @AutoLog(value="Redis-\u67e5\u8be2\u5185\u5b58\u4fe1\u606f", logType=2, operateType=1)
    @GetMapping(value={"/memoryInfo"})
    public Map<String, Object> getMemoryInfo() throws Exception {
        return this.redisService.getMemoryInfo();
    }

    @AutoLog(value="Server-\u67e5\u8be2\u670d\u52a1\u5668\u4fe1\u606f", logType=2, operateType=1)
    @GetMapping(value={"/getServerInfo"})
    public Map<String, Object> getServerInfo() throws Exception {
        InetAddress localHost = null;
        localHost = Inet4Address.getLocalHost();
        String ip = localHost.getHostAddress();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ip", ip);
        return map;
    }

    @AutoLog(value="Server-\u83b7\u53d6\u78c1\u76d8\u4fe1\u606f", logType=2, operateType=1)
    @GetMapping(value={"/queryDiskInfo"})
    public Result<List<Map<String, Object>>> queryDiskInfo(HttpServletRequest request, HttpServletResponse response) {
        Result<List<Map<String, Object>>> res = new Result<List<Map<String, Object>>>();
        try {
            FileSystemView fsv = FileSystemView.getFileSystemView();
            File[] fs = File.listRoots();
            log.info("\u67e5\u8be2\u78c1\u76d8\u4fe1\u606f:" + fs.length + "\u4e2a");
            ArrayList list = new ArrayList();
            for (int i = 0; i < fs.length; ++i) {
                if (fs[i].getTotalSpace() == 0L) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", fsv.getSystemDisplayName(fs[i]));
                map.put("max", fs[i].getTotalSpace());
                map.put("rest", fs[i].getFreeSpace());
                map.put("restPPT", (fs[i].getTotalSpace() - fs[i].getFreeSpace()) * 100L / fs[i].getTotalSpace());
                list.add(map);
                log.info(((Object)map).toString());
            }
            res.setResult(list);
            res.success("\u67e5\u8be2\u6210\u529f");
        }
        catch (Exception e) {
            res.error500("\u67e5\u8be2\u5931\u8d25" + e.getMessage());
        }
        return res;
    }
}

