/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.shiro.authc.aop;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootExceptionHandler;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.shiro.authc.JwtToken;
import com.els.modules.shiro.contants.DefContants;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.mapper.ElsSubAccountMapper;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.util.I18nUtil;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;

public class JwtFilter
extends BasicHttpAuthenticationFilter {
    private static final Logger log = LoggerFactory.getLogger(JwtFilter.class);

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        try {
            return this.executeLogin(request, response);
        }
        catch (Exception e) {
            throw new AuthenticationException(I18nUtil.translate("i18n_alert_WWWWWKXWVVVEHW_8bdef769", "Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55"));
        }
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        Result result;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String token = httpServletRequest.getHeader(DefContants.X_ACCESS_TOKEN);
        if (StrUtil.isBlank((CharSequence)token)) {
            token = httpServletRequest.getParameter(DefContants.X_ACCESS_TOKEN);
        }
        if (StrUtil.isBlank((CharSequence)token) && StrUtil.isBlank((CharSequence)(token = httpServletRequest.getParameter(DefContants.X_TOKEN)))) {
            token = httpServletRequest.getHeader(DefContants.X_TOKEN);
        }
        if (!(result = this.checkUser(token)).isSuccess()) {
            this.returnJson(response, JSON.toJSONString(Result.tokenExpire(result.getMessage())));
            return false;
        }
        JwtToken jwtToken = new JwtToken(token);
        try {
            this.getSubject(request, response).login((AuthenticationToken)jwtToken);
        }
        catch (AuthenticationException e) {
            ELSBootExceptionHandler handler = new ELSBootExceptionHandler();
            this.returnJson(response, JSON.toJSONString(handler.handleAuthcException(e)));
            return false;
        }
        return true;
    }

    public Result checkUser(String token) {
        String account = JwtUtil.getAccount(token);
        ElsSubAccountMapper userMapper = SpringContextUtils.getBean(ElsSubAccountMapper.class);
        ElsSubAccount sysUser = userMapper.getUserByAccount(account);
        if (null != sysUser) {
            ElsSubAccountService elsSubAccountService = SpringContextUtils.getBean(ElsSubAccountService.class);
            return elsSubAccountService.checkUserIsEffective(sysUser);
        }
        return Result.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnJson(ServletResponse response, String json) {
        PrintWriter writer = null;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        try {
            writer = response.getWriter();
            writer.print(json);
        }
        catch (IOException e) {
            log.error("response error", (Throwable)e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    protected boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        httpServletResponse.setHeader("Access-control-Allow-Origin", httpServletRequest.getHeader("Origin"));
        httpServletResponse.setHeader("Access-Control-Allow-Methods", "GET,POST,OPTIONS,PUT,DELETE");
        httpServletResponse.setHeader("Access-Control-Allow-Headers", httpServletRequest.getHeader("Access-Control-Request-Headers"));
        if (httpServletRequest.getMethod().equals(RequestMethod.OPTIONS.name())) {
            httpServletResponse.setStatus(HttpStatus.OK.value());
            return false;
        }
        return super.preHandle(request, response);
    }
}

