/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.aspect;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.InterfaceRecordLog;
import com.els.common.util.DateUtils;
import com.els.config.mybatis.TenantContext;
import com.els.modules.record.entity.InterfaceRecord;
import com.els.modules.record.service.InterfaceRecordService;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class InterfaceRecordAspect {
    private static final Logger log = LoggerFactory.getLogger(InterfaceRecordAspect.class);
    @Autowired
    private InterfaceRecordService interfaceRecordService;

    @Pointcut(value="@annotation(com.els.common.aspect.annotation.InterfaceRecordLog)")
    public void logPointCut() {
    }

    @Around(value="logPointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        String message = "";
        Object result = new Object();
        Timestamp startTime = DateUtils.getTimestamp();
        Long startTimeSecond = System.currentTimeMillis();
        try {
            result = point.proceed();
        }
        catch (Exception e) {
            message = "\u63a5\u53e3\u8c03\u7528\u5931\u8d25:" + e.getMessage();
            log.info(message);
        }
        Long endTimeSecond = System.currentTimeMillis();
        Timestamp endTime = DateUtils.getTimestamp();
        Long invokLong = endTimeSecond - startTimeSecond;
        this.saveInterfaceRecord(point, startTime, endTime, invokLong, result, message);
        return result;
    }

    public void saveInterfaceRecord(ProceedingJoinPoint point, Timestamp startTime, Timestamp endTime, Long invokLong, Object result, String message) {
        InterfaceRecord interfaceRecord = new InterfaceRecord();
        String sendContext = "";
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        InterfaceRecordLog interfaceRecordLog = method.getAnnotation(InterfaceRecordLog.class);
        String interfaceType = interfaceRecordLog.interfaceType();
        String interfaceMethod = interfaceRecordLog.interfaceMethod();
        interfaceRecord.setInterfaceType(interfaceType);
        if ("http-get".equals(interfaceType)) {
            Object param;
            String fromid = "";
            Object[] args = point.getArgs();
            Object object = param = args.length > 0 ? point.getArgs()[0] : new Object();
            if (param instanceof String) {
                fromid = (String)param;
            }
            interfaceRecord.setMethod(fromid);
            interfaceRecord.setFormId(fromid);
            interfaceRecord.setFlowType("2");
        } else if ("http-post".equals(interfaceType)) {
            Object param;
            String fromid = "ipaas";
            Object[] args = point.getArgs();
            Object object = param = args.length > 0 ? point.getArgs()[0] : new Object();
            if (param instanceof JSONObject) {
                sendContext = param.toString();
            }
            interfaceRecord.setMethod(interfaceMethod);
            interfaceRecord.setFormId(fromid);
            interfaceRecord.setFlowType("2");
        } else if ("srm-post".equals(interfaceType)) {
            Object param;
            Object[] args = point.getArgs();
            Object object = param = args.length > 0 ? point.getArgs()[0] : new Object();
            if (param instanceof String) {
                sendContext = param.toString();
            }
            String formId = JSONObject.parseObject((String)sendContext).getString("interfaceCode");
            String InterfaceMethod = JSONObject.parseObject((String)sendContext).getString("executeMethod");
            interfaceRecord.setMethod(InterfaceMethod);
            interfaceRecord.setFormId(formId);
            interfaceRecord.setFlowType("1");
        } else if ("kingdee-post".equals(interfaceType) && "Login".equals(interfaceMethod)) {
            Object param;
            Object[] args = point.getArgs();
            Object object = param = args.length > 0 ? JSONArray.toJSON((Object)point.getArgs()) : new Object();
            if (param instanceof JSONArray) {
                sendContext = ((JSONArray)param).toJSONString();
            }
            if (!"true".equals(String.valueOf(result))) {
                message = String.valueOf(result);
            }
            interfaceRecord.setMethod(interfaceMethod);
            interfaceRecord.setFormId("ValidateUser");
            interfaceRecord.setSendContext(sendContext);
            interfaceRecord.setFlowType("2");
        } else if ("kingdee-post".equals(interfaceType) && ("ExecuteBillQuery".equals(interfaceMethod) || "QueryGroupInfo".equals(interfaceMethod))) {
            Object param;
            String fromid = "";
            Object[] args = point.getArgs();
            Object object = param = args.length > 0 ? JSONArray.toJSON((Object)point.getArgs()) : new Object();
            if (param instanceof JSONArray) {
                sendContext = ((JSONArray)param).toJSONString();
                fromid = JSONObject.parseObject((String)String.valueOf(((JSONArray)param).get(0))).getString("FormId");
            }
            interfaceRecord.setMethod(interfaceMethod);
            interfaceRecord.setFormId(fromid);
            interfaceRecord.setSendContext(sendContext);
            interfaceRecord.setFlowType("2");
        } else if ("kingdee-post".equals(interfaceType) && !"Login".equals(interfaceMethod)) {
            Object param;
            String fromid = "";
            Object[] args = point.getArgs();
            Object object = param = args.length > 0 ? JSONArray.toJSON((Object)point.getArgs()) : new Object();
            if (param instanceof JSONArray) {
                sendContext = ((JSONArray)param).toJSONString();
                fromid = ((JSONArray)param).get(0).toString();
            }
            if (!this.getInterfaceStatus(String.valueOf(result))) {
                message = String.valueOf(result);
            }
            interfaceRecord.setMethod(interfaceMethod);
            interfaceRecord.setFormId(fromid);
            interfaceRecord.setSendContext(sendContext);
            interfaceRecord.setFlowType("2");
        } else if ("mes-post".equals(interfaceType)) {
            Object param;
            String fromid = "mes";
            Object[] args = point.getArgs();
            Object object = param = args.length > 0 ? point.getArgs()[0] : new Object();
            if (param instanceof String) {
                sendContext = param.toString();
            }
            interfaceRecord.setMethod(interfaceMethod);
            interfaceRecord.setFormId(fromid);
            interfaceRecord.setFlowType("2");
            try {
                if (!"ok".equals(JSONObject.parseObject((String)String.valueOf(result)).getString("code"))) {
                    message = String.valueOf(result);
                }
            }
            catch (Exception e) {
                message = String.valueOf(result);
            }
        } else if ("oa-post".equals(interfaceType)) {
            Object param;
            String fromid = "oa";
            Object[] args = point.getArgs();
            Object object = param = args.length > 0 ? point.getArgs()[0] : new Object();
            if (param instanceof String) {
                sendContext = param.toString();
            }
            interfaceRecord.setMethod(interfaceMethod);
            interfaceRecord.setFormId(fromid);
            interfaceRecord.setFlowType("2");
            try {
                if (!((Boolean)JSONObject.parseObject((String)String.valueOf(result)).getObject("success", Boolean.class)).booleanValue()) {
                    message = String.valueOf(result);
                }
            }
            catch (Exception e) {
                message = e.getMessage();
            }
        }
        interfaceRecord.setSendContext(sendContext);
        interfaceRecord.setSendTime(startTime);
        interfaceRecord.setReturnTime(endTime);
        interfaceRecord.setReturnContext(result == null ? "" : result.toString());
        interfaceRecord.setInvokLong(invokLong);
        interfaceRecord.setDeleted(0);
        interfaceRecord.setElsAccount(TenantContext.getTenant());
        interfaceRecord.setErrorMessage(message);
        interfaceRecord.setStatus(StringUtils.isBlank((CharSequence)message) ? "1" : "0");
        log.info("\u63a5\u53e3\u8bb0\u5f55\u6570\u636e\uff1a" + interfaceRecord.toString());
        this.interfaceRecordService.saveInterfaceRecord(interfaceRecord);
        log.info("\u63a5\u53e3\u8bb0\u5f55\u6570\u636e\u552f\u4e00\u952e\uff1a" + interfaceRecord.getId());
    }

    public boolean getInterfaceStatus(String json) {
        Boolean flag = false;
        try {
            flag = (Boolean)((JSONObject)((JSONObject)JSONObject.parseObject((String)String.valueOf(json)).getObject("Result", JSONObject.class)).getObject("ResponseStatus", JSONObject.class)).getObject("IsSuccess", Boolean.class);
        }
        catch (Exception e) {
            log.info("\u91d1\u8776\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c\u89e3\u6790\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return flag;
    }
}

