/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.CompanyI18n;
import com.els.modules.system.entity.I18n;
import com.els.modules.system.service.AbstractExcelHandler;
import com.els.modules.system.service.CompanyI18nService;
import com.els.modules.system.service.I18nService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class I18nDataImportImpl
extends AbstractExcelHandler {
    @Autowired
    private I18nService i18nService;
    @Autowired
    private CompanyI18nService companyI18nService;

    @Override
    public void importExcel(List<Map<String, Object>> dataList) {
        String elsAccount = TenantContext.getTenant();
        ArrayList<I18n> list = new ArrayList<I18n>();
        ArrayList<String> keyList = new ArrayList<String>();
        for (Map<String, Object> data : dataList) {
            I18n i18n = (I18n)JSON.parseObject((String)JSON.toJSONString(data), I18n.class);
            i18n.setElsAccount(elsAccount);
            i18n.setDeleted(CommonConstant.DEL_FLAG_0);
            i18n.setCreateTime(new Date());
            keyList.add(i18n.getI18nKey());
            list.add(i18n);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"i18n_key", keyList);
        List i18nList = this.i18nService.list((Wrapper)queryWrapper);
        HashMap<String, Object> dbMap = new HashMap<String, Object>();
        for (Object i18n : i18nList) {
            dbMap.put(((BaseEntity)i18n).getElsAccount() + ((I18n)i18n).getLanguage() + ((I18n)i18n).getI18nKey(), i18n);
        }
        if (elsAccount.equals("100000")) {
            ArrayList<I18n> i18nInsertList = new ArrayList<I18n>();
            for (I18n i18n : list) {
                if (dbMap.containsKey(i18n.getElsAccount() + i18n.getLanguage() + i18n.getI18nKey())) {
                    i18n.setId(((I18n)dbMap.get(i18n.getElsAccount() + i18n.getLanguage() + i18n.getI18nKey())).getId());
                    this.i18nService.updateById(i18n);
                    continue;
                }
                i18nInsertList.add(i18n);
            }
            if (!i18nInsertList.isEmpty()) {
                this.i18nService.saveBatch(i18nInsertList);
            }
        } else {
            ArrayList<CompanyI18n> companyI18nList = new ArrayList<CompanyI18n>();
            ArrayList<I18n> i18nInsertList = new ArrayList<I18n>();
            for (I18n i18n : list) {
                if (dbMap.containsKey("100000" + i18n.getLanguage() + i18n.getI18nKey())) {
                    String i18nId = ((I18n)dbMap.get("100000" + i18n.getLanguage() + i18n.getI18nKey())).getId();
                    this.companyI18nService.deleteByI18nId(elsAccount, i18nId);
                    CompanyI18n companyI18n = new CompanyI18n();
                    companyI18n.setElsAccount(elsAccount);
                    companyI18n.setId(IdWorker.getIdStr());
                    companyI18n.setI18nId(i18nId);
                    companyI18n.setI18nValue(i18n.getI18nValue());
                    companyI18n.setDeleted(CommonConstant.DEL_FLAG_0);
                    companyI18n.setCreateTime(new Date());
                    companyI18nList.add(companyI18n);
                    continue;
                }
                if (dbMap.containsKey(i18n.getElsAccount() + i18n.getLanguage() + i18n.getI18nKey())) {
                    i18n.setId(((I18n)dbMap.get(i18n.getElsAccount() + i18n.getLanguage() + i18n.getI18nKey())).getId());
                    this.i18nService.updateById(i18n);
                    continue;
                }
                i18nInsertList.add(i18n);
            }
            if (!companyI18nList.isEmpty()) {
                this.companyI18nService.saveBatch(companyI18nList);
            }
            if (!i18nInsertList.isEmpty()) {
                this.i18nService.saveBatch(i18nInsertList);
            }
        }
    }
}

