/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsCompanySet;
import com.els.modules.system.mapper.ElsCompanySetMapper;
import com.els.modules.system.service.ElsCompanySetService;
import com.els.modules.system.vo.ElsCompanySetVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ElsCompanySetServiceImpl
extends ServiceImpl<ElsCompanySetMapper, ElsCompanySet>
implements ElsCompanySetService {
    @Override
    public List<ElsCompanySetVO> findList(String elsAccount) {
        return ((ElsCompanySetMapper)this.baseMapper).findList(elsAccount);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void save(List<ElsCompanySetVO> list) {
        String elsAccount = TenantContext.getTenant();
        ((ElsCompanySetMapper)this.baseMapper).deleteByAccount(elsAccount);
        ArrayList<ElsCompanySet> companySetList = new ArrayList<ElsCompanySet>();
        for (ElsCompanySetVO vo : list) {
            ElsCompanySet companySet = new ElsCompanySet();
            BeanUtils.copyProperties((Object)vo, (Object)companySet);
            companySet.setId(null);
            companySet.setSystemId(vo.getId());
            companySet.setElsAccount(elsAccount);
            companySetList.add(companySet);
        }
        if (!companySetList.isEmpty()) {
            this.saveBatch(companySetList);
        }
    }
}

