/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.mapper.PermissionDataMapper;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.vo.PermissionDataVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionDataServiceImpl
extends ServiceImpl<PermissionDataMapper, PermissionData>
implements PermissionDataService {
    private static final String PERMISSION_DATA_KEY = "sys:permissionData:";
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ElsSubAccountService elsSubAccountService;

    @Override
    public void savePermissionData(PermissionData permissionData) {
        ElsSubAccount elsSubAccount = new ElsSubAccount();
        elsSubAccount.setSensitivityFieldGroup(permissionData.getSensitivityFieldGroup());
        LambdaUpdateWrapper itemWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)itemWrapper.eq(BaseEntity::getElsAccount, (Object)permissionData.getElsAccount())).eq(ElsSubAccount::getSubAccount, (Object)permissionData.getSubAccount());
        this.elsSubAccountService.update(elsSubAccount, (Wrapper)itemWrapper);
        ((PermissionDataMapper)this.baseMapper).insert(permissionData);
    }

    @Override
    public void updatePermissionData(PermissionDataVO permissionData) {
        String elsAccount = permissionData.getElsAccount();
        String subAccount = permissionData.getSubAccount();
        ElsSubAccount elsSubAccount = new ElsSubAccount();
        elsSubAccount.setSensitivityFieldGroup(permissionData.getSensitivityFieldGroup());
        LambdaUpdateWrapper itemWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)itemWrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(ElsSubAccount::getSubAccount, (Object)subAccount);
        this.elsSubAccountService.update(elsSubAccount, (Wrapper)itemWrapper);
        List<PermissionData> dataList = permissionData.getPermissionDataList();
        ((PermissionDataMapper)this.baseMapper).deleteByMainId(elsAccount, subAccount);
        for (PermissionData data : dataList) {
            data.setId(IdWorker.getIdStr());
            data.setUserId(permissionData.getId());
            data.setElsAccount(elsAccount);
            data.setSubAccount(subAccount);
            data.setDeleted(CommonConstant.DEL_FLAG_0);
            data.setCreateTime(new Date());
        }
        if (dataList.size() > 0) {
            ((PermissionDataMapper)this.baseMapper).insertBatchSomeColumn(dataList);
        }
        String redisKey = this.getRedisKey(elsAccount, subAccount);
        this.redisUtil.del(redisKey);
    }

    @Override
    public void delPermissionData(String id) {
        PermissionData data = (PermissionData)((PermissionDataMapper)this.baseMapper).selectById((Serializable)((Object)id));
        if (data != null) {
            ((PermissionDataMapper)this.baseMapper).deleteById((Serializable)((Object)id));
            String redisKey = this.getRedisKey(data.getElsAccount(), data.getSubAccount());
            this.redisUtil.del(redisKey);
        }
    }

    @Override
    public void delBatchPermissionData(List<String> idList) {
        ((PermissionDataMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<PermissionData> getPermissionDataList(String elsAccount, String subAccount) {
        String redisKey = this.getRedisKey(elsAccount, subAccount);
        List dataList = (List)this.redisUtil.get(redisKey);
        if (dataList == null) {
            dataList = ((PermissionDataMapper)this.baseMapper).selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).eq((Object)"sub_account", (Object)subAccount));
            this.redisUtil.set(redisKey, dataList);
        }
        return dataList;
    }

    @Override
    public List<PermissionData> getPermissionDataList(String elsAccount, String subAccount, String businessType) {
        List<PermissionData> dataList = this.getPermissionDataList(elsAccount, subAccount);
        if (dataList != null) {
            dataList = dataList.parallelStream().filter(data -> data.getBusinessType().equals(businessType)).collect(Collectors.toList());
        }
        return dataList;
    }

    private String getRedisKey(String elsAccount, String subAccount) {
        StringBuilder key = new StringBuilder(PERMISSION_DATA_KEY);
        key.append(elsAccount).append("_").append(subAccount);
        return key.toString();
    }

    @Override
    public void batchSave(List<PermissionData> dataList) {
        ((PermissionDataMapper)this.baseMapper).insertBatchSomeColumn(dataList);
        String elsAccount = TenantContext.getTenant();
        List list = dataList.parallelStream().map(o -> o.getSubAccount()).distinct().collect(Collectors.toList());
        for (String subAccount : list) {
            String key = this.getRedisKey(elsAccount, subAccount);
            this.redisUtil.del(key);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void copyPermission(PermissionDataVO data) {
        ElsSubAccount thisSubAccount = this.elsSubAccountService.getByAccount(TenantContext.getTenant(), data.getSubAccount());
        List<PermissionData> suorceList = this.getPermissionDataList(TenantContext.getTenant(), data.getSubAccount());
        List<String> sourceUserRoles = this.elsSubAccountService.getRoleId(TenantContext.getTenant(), data.getSubAccount());
        if (suorceList == null || suorceList.isEmpty()) {
            return;
        }
        List<ElsSubAccount> accountList = data.getSubAccountList();
        if (accountList == null || accountList.isEmpty()) {
            return;
        }
        ArrayList<PermissionData> insertList = new ArrayList<PermissionData>();
        for (ElsSubAccount account : accountList) {
            if (account.getSubAccount().equals(data.getSubAccount())) continue;
            ((PermissionDataMapper)this.baseMapper).deleteByMainId(account.getElsAccount(), account.getSubAccount());
            String redisKey = this.getRedisKey(account.getElsAccount(), account.getSubAccount());
            this.redisUtil.del(redisKey);
            for (PermissionData suorceData : suorceList) {
                PermissionData permissionData = new PermissionData();
                BeanUtils.copyProperties((Object)suorceData, (Object)permissionData);
                permissionData.setId(IdWorker.getIdStr());
                permissionData.setUserId(account.getId());
                permissionData.setElsAccount(account.getElsAccount());
                permissionData.setSubAccount(account.getSubAccount());
                permissionData.setDeleted(CommonConstant.DEL_FLAG_0);
                permissionData.setCreateTime(new Date());
                insertList.add(permissionData);
                if (!StringUtils.isNotBlank((CharSequence)permissionData.getPermissionField()) || !"createBy".equals(permissionData.getPermissionField())) continue;
                permissionData.setPermissionValue(account.getSubAccount());
            }
            if (CollectionUtil.isNotEmpty(sourceUserRoles)) {
                String userRole = sourceUserRoles.stream().collect(Collectors.joining(","));
                this.elsSubAccountService.editUserWithRole(account, userRole);
            }
            if (thisSubAccount == null || !StringUtils.isNotEmpty((CharSequence)thisSubAccount.getSensitivityFieldGroup())) continue;
            this.elsSubAccountService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(BaseEntity::getElsAccount, (Object)thisSubAccount.getElsAccount())).eq(ElsSubAccount::getSubAccount, (Object)account.getSubAccount())).set(ElsSubAccount::getSensitivityFieldGroup, (Object)thisSubAccount.getSensitivityFieldGroup()));
        }
        if (!insertList.isEmpty()) {
            this.saveBatch(insertList, 2000);
        }
    }
}

