/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.els.modules.system.enums.PwComplexityVerifyEnum;
import com.els.modules.system.enums.i18n.I18nElsPwSecurityEnum;
import com.els.modules.system.util.I18nUtil;
import com.els.modules.system.util.LocalDateTimeUtil;
import java.util.Date;
import java.util.Map;
import org.springframework.util.Assert;

public class PwVerifyUtil {
    private PwVerifyUtil() {
    }

    public static void pwComplexityVerify(Map<String, Integer> pwComplexityItem, String pwString) {
        if (pwComplexityItem.isEmpty()) {
            return;
        }
        Map<String, PwComplexityVerifyEnum> enumMap = PwComplexityVerifyEnum.getEnumMap();
        for (Map.Entry<String, Integer> entry : pwComplexityItem.entrySet()) {
            if (!enumMap.containsKey(entry.getKey()) || entry.getValue() == null || entry.getValue() == 0) continue;
            PwComplexityVerifyEnum pwComplexityVerifyEnum = enumMap.get(entry.getKey());
            Assert.isTrue((boolean)pwComplexityVerifyEnum.verify(pwString), (String)pwComplexityVerifyEnum.description());
        }
    }

    public static void pwMinLengthVerify(String pwString, int minLength) {
        Assert.isTrue((minLength == 0 || pwString.length() >= minLength ? 1 : 0) != 0, (String)I18nUtil.translate(I18nElsPwSecurityEnum.I18N_MIN_LENGTH, String.valueOf(minLength)));
    }

    public static void pwModifyIntervalVerify(Date lastModifyDate, int modifyInterval) {
        Assert.isTrue((modifyInterval == 0 || !LocalDateTimeUtil.compareMonthLater(lastModifyDate, modifyInterval) ? 1 : 0) != 0, (String)I18nUtil.translate(I18nElsPwSecurityEnum.I18N_MODIFY_INTERVAL, String.valueOf(modifyInterval)));
    }
}

