/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.logic.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.constant.CommonConstant;
import com.els.common.system.api.ISysBaseAPI;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.vo.LoginUser;
import com.els.modules.logic.service.AccountRpcService;
import com.els.modules.system.entity.CompanyPermission;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.ElsTenant;
import com.els.modules.system.entity.Permission;
import com.els.modules.system.entity.PermissionData;
import com.els.modules.system.entity.PersonalSetting;
import com.els.modules.system.entity.Role;
import com.els.modules.system.entity.RolePermission;
import com.els.modules.system.entity.ThirdAccount;
import com.els.modules.system.service.CompanyPermissionService;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.ElsTenantService;
import com.els.modules.system.service.PermissionDataService;
import com.els.modules.system.service.PermissionService;
import com.els.modules.system.service.PersonalSettingService;
import com.els.modules.system.service.RolePermissionService;
import com.els.modules.system.service.RoleService;
import com.els.modules.system.service.ThirdAccountService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AccountBeanServiceImpl
implements AccountRpcService {
    private static final Logger log = LoggerFactory.getLogger(AccountBeanServiceImpl.class);
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private RoleService roleService;
    @Resource
    private PermissionService permissionService;
    private CompanyPermissionService companyPermissionService;
    @Resource
    private ISysBaseAPI sysBaseAPI;
    @Resource
    private PermissionDataService permissionDataService;
    @Resource
    private ThirdAccountService thirdAccountService;
    @Resource
    private PersonalSettingService personalSettingService;
    @Resource
    private RolePermissionService rolePermissionService;
    @Resource
    private ElsTenantService elsTenantService;

    @Override
    public List<ThirdAccount> getThirdAccount(String accountId, String thirdType) {
        return this.thirdAccountService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)accountId)).eq((Object)"third_type", (Object)thirdType));
    }

    @Override
    public List<PersonalSetting> getPersonalSetting(String elsAccount, String subAccount) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(PersonalSetting::getElsAccount, (Object)elsAccount);
        query.eq(PersonalSetting::getSubAccount, (Object)subAccount);
        query.eq(PersonalSetting::getIsReceive, (Object)"0");
        return this.personalSettingService.list((Wrapper)query);
    }

    @Override
    public ElsSubAccount getAccount(String elsAccount, String subAccount) {
        return this.elsSubAccountService.getByAccount(elsAccount, subAccount);
    }

    @Override
    public ElsSubAccount getAccountById(String id) {
        return (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)id));
    }

    @Override
    public LoginUser getLoginUser(String account) {
        return this.sysBaseAPI.getUserByAccount(account);
    }

    @Override
    public Set<String> getUserRolesSet(String elsAccount, String subAccount) {
        return this.elsSubAccountService.getUserRolesSet(elsAccount, subAccount);
    }

    @Override
    public Set<String> getUserPermissionsSet(String elsAccount, String subAccount) {
        return this.elsSubAccountService.getUserPermissionsSet(String.valueOf(elsAccount) + "_" + subAccount);
    }

    @Override
    public Set<String> getAllOptPermission() {
        return this.permissionService.getAllOptPermission();
    }

    @Override
    public List<PermissionData> getPermissionDataList(String elsAccount, String subAccount, String businessType) {
        return this.permissionDataService.getPermissionDataList(elsAccount, subAccount, businessType);
    }

    @Override
    public List<ElsSubAccount> getAccountList(String elsAccount, List<String> subAccounts) {
        return this.elsSubAccountService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)elsAccount)).in((Object)"sub_account", subAccounts));
    }

    @Override
    public List<ElsSubAccount> getAccountListByElsSubAccountWithoutUser(List<String> elsSubAccountList) {
        return this.elsSubAccountService.getAccountListByElsSubAccountWithoutUser(elsSubAccountList);
    }

    @Override
    public List<ElsSubAccount> getAllByAccount(String account) {
        return this.elsSubAccountService.list((Wrapper)new QueryWrapper().eq((Object)"els_account", (Object)account));
    }

    @Override
    public ElsSubAccount addUserWithRole(ElsSubAccount user, String roles) {
        this.elsSubAccountService.addUserWithRole(user, roles);
        return user;
    }

    @Override
    public ElsSubAccount save(ElsSubAccount account) {
        this.elsSubAccountService.save(account);
        return account;
    }

    @Override
    public Role saveRole(Role role) {
        this.roleService.save(role);
        return role;
    }

    @Override
    public List<Permission> selectDefault() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_default_menu", (Object)"1");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        return this.permissionService.list((Wrapper)queryWrapper);
    }

    @Override
    public List<CompanyPermission> insertCompanyMenuBatch(List<CompanyPermission> companyPermissionDTOs) {
        this.companyPermissionService.saveBatch(companyPermissionDTOs);
        return companyPermissionDTOs;
    }

    @Override
    public RolePermission saveRolePermission(RolePermission permission) {
        this.rolePermissionService.save(permission);
        return permission;
    }

    @Override
    public List<PersonalSetting> savePersonalSetting(List<PersonalSetting> personalSettings) {
        this.personalSettingService.saveBatch(personalSettings);
        return personalSettings;
    }

    @Override
    public Page<ElsSubAccount> getSubAccountPage(int pageIndex, int pageSize, String elsAccount) {
        Page page = new Page((long)pageIndex, (long)pageSize);
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEntity::getElsAccount, (Object)elsAccount);
        return (Page)this.elsSubAccountService.page((IPage)page, (Wrapper)wrapper);
    }

    @Override
    public ElsSubAccount getAccountByPhone(String phone) {
        return this.elsSubAccountService.getUserByPhone(phone);
    }

    @Override
    public List<ElsSubAccount> queryByElsAccountList(List<String> accountList) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{BaseEntity::getId, BaseEntity::getElsAccount, ElsSubAccount::getSubAccount, ElsSubAccount::getRealname});
        return this.elsSubAccountService.list((Wrapper)wrapper);
    }

    @Override
    public List<Role> getAllRole() {
        return this.roleService.list();
    }

    @Override
    public ElsSubAccount getUserBySubAccount(String subAccount) {
        return this.elsSubAccountService.getUserBySubAccount(subAccount);
    }

    @Override
    public void batchSaveRolePermission(List<RolePermission> companyPermissionList) {
        this.rolePermissionService.saveBatch(companyPermissionList);
    }

    private List<PersonalSetting> buildPersonalSetting(String elsAccount, String subaccount) {
        List<String> list = Arrays.asList("EMAIL", "NEWS", "VOICE", "MSG", "WECHAT", "DINGTALK");
        ArrayList<PersonalSetting> personalSettings = new ArrayList<PersonalSetting>();
        for (String str : list) {
            PersonalSetting personalSetting = new PersonalSetting();
            personalSetting.setId(UUID.randomUUID().toString().replace("-", ""));
            personalSetting.setElsAccount(elsAccount);
            personalSetting.setSubAccount(subaccount);
            personalSetting.setCreateBy("1001");
            personalSetting.setCreateTime(new Date());
            personalSetting.setUpdateBy("1001");
            personalSetting.setUpdateTime(new Date());
            personalSetting.setReceiveType(str);
            personalSetting.setIsReceive(0);
            personalSettings.add(personalSetting);
        }
        return personalSettings;
    }

    @Override
    public ElsSubAccount initSupplierAccountInfo(String elsAccount, ElsSubAccount user, String companyName, String sourceType) {
        log.info("::: AccountDubboServiceImpl#initSupplierAccountInfo start initSupplierAccountInfo...{}", (Object)companyName);
        Role role = new Role();
        role.setElsAccount(elsAccount);
        role.setRoleName("\u4f01\u4e1a\u7ba1\u7406\u5458");
        role.setRoleCode("companyAdmin");
        this.roleService.save(role);
        this.elsSubAccountService.addUserWithRole(user, role.getId());
        List<PersonalSetting> personalSettingList = this.buildPersonalSetting(elsAccount, user.getSubAccount());
        this.personalSettingService.saveBatch(personalSettingList);
        ElsTenant elsTenant = new ElsTenant();
        elsTenant.setAccountStatus("1");
        elsTenant.setElsAccount(elsAccount);
        elsTenant.setCompanyName(companyName);
        elsTenant.setSourceType(sourceType);
        try {
            elsTenant.setExpiryDate(new SimpleDateFormat("yyyy-MM-dd").parse("2029-12-31"));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.elsTenantService.save(elsTenant);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_default_menu", (Object)"1");
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        List list = this.permissionService.list((Wrapper)queryWrapper);
        ArrayList<CompanyPermission> companyPermissions = new ArrayList<CompanyPermission>();
        for (Permission permission : list) {
            CompanyPermission companyPermission = new CompanyPermission();
            companyPermission.setId(IdWorker.getIdStr());
            companyPermission.setElsAccount(elsAccount);
            companyPermission.setPermissionId(permission.getId());
            companyPermission.setName(permission.getName());
            companyPermission.setSortNo(permission.getSortNo());
            companyPermission.setIcon(permission.getIcon());
            companyPermission.setIconColor(permission.getIconColor());
            companyPermission.setRuleFlag(permission.getRuleFlag());
            companyPermission.setStatus(permission.getStatus());
            companyPermission.setDeleted(CommonConstant.DEL_FLAG_0);
            companyPermission.setUpdateTime(new Date());
            companyPermissions.add(companyPermission);
        }
        if (!companyPermissions.isEmpty()) {
            this.companyPermissionService.saveBatch(companyPermissions);
            ArrayList companyPermissionList = Lists.newArrayList();
            for (CompanyPermission companyPermission : companyPermissions) {
                RolePermission rolePermission = new RolePermission();
                rolePermission.setElsAccount(elsAccount);
                rolePermission.setRoleId(role.getId());
                rolePermission.setPermissionId(companyPermission.getPermissionId());
                companyPermissionList.add(rolePermission);
            }
            if (CollUtil.isNotEmpty((Collection)companyPermissionList)) {
                this.rolePermissionService.saveBatch(companyPermissionList);
            }
        }
        log.info("::: AccountDubboServiceImpl#initSupplierAccountInfo end initSupplierAccountInfo...{}", (Object)companyName);
        return user;
    }

    @Override
    public List<Role> selectWithoutElsAccountOfAllRole(List<String> accountList) {
        return this.roleService.selectWithoutElsAccountOfAllRole(accountList);
    }
}

